/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.base.sct;

import java.security.Key;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Node;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.security.wssc.base.sct.SCCredentialProviderBase;
import weblogic.wsee.security.wssc.base.sct.SCTokenBase;
import weblogic.wsee.security.wssc.faults.FaultVersionHelper;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wssc.sct.SCTStore;
import weblogic.wsee.security.wssc.sct.SCTokenReference;
import weblogic.wsee.security.wst.faults.WSTFaultUtil;
import weblogic.wsee.security.wst.helpers.TrustTokenHelper;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.common.keyinfo.SecretKeyProvider;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.SecurityTokenHelper;
import weblogic.xml.crypto.wss.SecurityTokenValidateResult;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.dom.marshal.MarshalException;

public abstract class SCTokenHandlerBase
implements SecurityTokenHandler {
    private static final boolean verbose = Verbose.isVerbose(SCTokenHandlerBase.class);

    protected abstract String getSCT_IDENTIFIER();

    protected abstract String getSCT_RST_ACTION();

    protected abstract String getSCT_RST_CANCEL_ACTION();

    protected abstract String getSCT_RST_RENEW_ACTION();

    protected abstract QName[] getSCT_QNAMES();

    protected abstract String[] getSCT_VALUE_TYPES();

    protected abstract String getSCT_VALUE_TYPE();

    protected abstract String getXMLNS_WSC();

    protected abstract SCTokenBase newSCToken();

    protected abstract SCTokenBase newSCToken(SCCredential var1);

    protected abstract SCCredential newSCCredential();

    protected abstract String getCANNED_POLICY_INCLUDE_SCT_FOR_IDENTITY();

    public SecurityToken getSecurityToken(String string, Object object, ContextHandler contextHandler) throws WSSecurityException {
        SecurityToken securityToken;
        if (!(object instanceof SCCredential)) {
            return null;
        }
        if (contextHandler != null && (securityToken = this.getSecurityToken(string, null, null, contextHandler)) != null && ((SCTokenBase)securityToken).getCredential().equals(object)) {
            return securityToken;
        }
        return this.newSCToken((SCCredential)object);
    }

    public SecurityToken getSecurityToken(String string, String string2, Purpose purpose, ContextHandler contextHandler) throws WSSecurityException {
        return SecurityTokenHelper.findSecurityTokenInContext(contextHandler, string);
    }

    public SecurityTokenReference getSTR(QName qName, String string, SecurityToken securityToken) throws WSSecurityException {
        SCTokenBase sCTokenBase = (SCTokenBase)securityToken;
        SCCredential sCCredential = sCTokenBase.getCredential();
        if (sCCredential != null) {
            SCCredential.SecurityTokenReferenceInfo securityTokenReferenceInfo = null;
            securityTokenReferenceInfo = sCCredential.getUnattachedSecurityTokenReferenceInfo();
            if (securityTokenReferenceInfo == null) {
                securityTokenReferenceInfo = sCCredential.getAttachedSecurityTokenReferenceInfo();
            }
            if (securityTokenReferenceInfo != null) {
                SCTokenReference sCTokenReference = new SCTokenReference(sCTokenBase);
                SCCredential.copyFromInfoToSTR(securityTokenReferenceInfo, sCTokenReference);
                return sCTokenReference;
            }
        }
        return new SCTokenReference(qName, sCTokenBase);
    }

    public QName[] getQNames() {
        return this.getSCT_QNAMES();
    }

    public String[] getValueTypes() {
        return this.getSCT_VALUE_TYPES();
    }

    public SecurityToken newSecurityToken(Node node) throws weblogic.xml.crypto.api.MarshalException {
        SCTokenBase sCTokenBase = this.newSCToken();
        try {
            sCTokenBase.unmarshal(node);
        }
        catch (MarshalException marshalException) {
            throw new weblogic.xml.crypto.api.MarshalException("Failed to unmarshal SecurityContextToken.", marshalException);
        }
        return sCTokenBase;
    }

    public SecurityTokenReference newSecurityTokenReference(Node node) throws MarshalException {
        SCTokenReference sCTokenReference = new SCTokenReference();
        sCTokenReference.unmarshal(node);
        return sCTokenReference;
    }

    public KeyProvider getKeyProvider(SecurityToken securityToken, MessageContext messageContext) {
        SCTokenBase sCTokenBase;
        Key key;
        SecretKeyProvider secretKeyProvider = null;
        if (securityToken instanceof SCTokenBase && (key = (sCTokenBase = (SCTokenBase)securityToken).getSecretKey()) != null) {
            byte[] byArray = sCTokenBase.getId() != null ? sCTokenBase.getId().getBytes() : null;
            String string = sCTokenBase.getTrustCredential().getIdentifier();
            Set<String> set = string != null ? new HashSet<String>(Arrays.asList(SecurityTokenHelper.getURI(sCTokenBase), string)) : Collections.singleton(SecurityTokenHelper.getURI(sCTokenBase));
            secretKeyProvider = new SecretKeyProvider(key, null, byArray, set, securityToken);
        }
        return secretKeyProvider;
    }

    public SecurityToken getSecurityToken(SecurityTokenReference securityTokenReference, MessageContext messageContext) throws WSSecurityException {
        Object object;
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
        String string = null;
        if (WSSConstants.REFERENCE_QNAME.equals(securityTokenReference.getSTRType())) {
            object = securityTokenReference.getReferenceURI();
            string = ((String)object).startsWith("#") ? SecurityTokenHelper.getIdFromURI(securityTokenReference.getReferenceURI()) : object;
        } else if (WSSConstants.KEY_IDENTIFIER_QNAME.equals(securityTokenReference.getSTRType())) {
            object = securityTokenReference.getKeyIdentifier();
            string = object.getIdentifier() == null ? null : new String(object.getIdentifier());
        }
        object = null;
        if (string != null) {
            object = this.findSecurityTokenByIdInContext(wSSecurityContext, securityTokenReference.getValueType(), string);
        }
        if (object != null) {
            if (object instanceof SCTokenBase) {
                SCTokenBase sCTokenBase = (SCTokenBase)object;
                SCTokenHandlerBase.checkExpiration(messageContext, sCTokenBase.getCredential(), this.getXMLNS_WSC());
            }
            return object;
        }
        String string2 = SCCredentialProviderBase.getPhysicalStoreNameFromMessageContext(messageContext);
        SCCredential sCCredential = SCTStore.get(string, string2);
        if (sCCredential != null) {
            if (verbose) {
                Verbose.log("=== got SCCredential '" + string + "' from SCTStore ===");
            }
            SCTokenHandlerBase.checkExpiration(messageContext, sCCredential, this.getXMLNS_WSC());
            return this.newSCToken(sCCredential);
        }
        if (verbose) {
            Verbose.log("===  NO SCCredential '" + string + "' in SCTStore ===");
        }
        throw new WSSecurityException("Failed to retrieve token for reference " + securityTokenReference, WSSConstants.FAILURE_TOKEN_UNAVAILABLE);
    }

    static SCCredential checkExpiration(MessageContext messageContext, SCCredential sCCredential, String string) {
        if ("true".equals(messageContext.getProperty("weblogic.wsee.security.wssc.needCheckSCTExpiration"))) {
            String string2;
            if (null == sCCredential) {
                return null;
            }
            if (verbose) {
                Verbose.log("Checking SCT experation");
            }
            if ("laxCheckingSCTExpiration".equals(string2 = (String)messageContext.getProperty("weblogic.wsee.security.wssc.checkingSCTExpiration"))) {
                return sCCredential;
            }
            Calendar calendar = null;
            if (null != sCCredential.getExpires()) {
                calendar = (Calendar)sCCredential.getExpires().clone();
                if ("tolerantCheckingSCTExpiration".equals(string2)) {
                    calendar.add(13, 60);
                }
            }
            if (sCCredential != null && TrustTokenHelper.isExpired(messageContext, sCCredential.getCreated(), calendar)) {
                WSTFaultUtil.raiseFault(FaultVersionHelper.newRenewNeededException(string, "SCToken expired: " + sCCredential.getIdentifier()));
            }
        }
        return sCCredential;
    }

    private final SecurityToken findSecurityTokenByIdInContext(WSSecurityContext wSSecurityContext, String string, String string2) {
        List list = wSSecurityContext.getSecurityTokens();
        SecurityToken securityToken = null;
        for (SecurityToken securityToken2 : list) {
            if (!(securityToken2 instanceof SCTokenBase) || !securityToken2.getValueType().equals(string) || !string2.equals(securityToken2.getId()) && !string2.equals(((SCTokenBase)securityToken2).getTrustCredential().getIdentifier())) continue;
            securityToken = securityToken2;
            break;
        }
        return securityToken;
    }

    public SecurityTokenValidateResult validateUnmarshalled(SecurityToken securityToken, MessageContext messageContext) throws WSSecurityException {
        this.resolveCredential((SCTokenBase)securityToken, messageContext);
        return new SecurityTokenValidateResult(true);
    }

    public SecurityTokenValidateResult validateProcessed(SecurityToken securityToken, MessageContext messageContext) {
        return new SecurityTokenValidateResult(true);
    }

    public boolean matches(SecurityToken securityToken, String string, String string2, ContextHandler contextHandler, Purpose purpose) {
        if (!(securityToken instanceof SCTokenBase)) {
            return false;
        }
        return string.equals(this.getSCT_VALUE_TYPE());
    }

    public Subject getSubject(SecurityToken securityToken, MessageContext messageContext) throws WSSecurityException {
        return ((SCCredential)securityToken.getCredential()).getSubject();
    }

    private void resolveCredential(SCTokenBase sCTokenBase, MessageContext messageContext) throws WSSecurityException {
        SCCredential sCCredential;
        SCCredential sCCredential2 = sCTokenBase.getCredential();
        if (sCCredential2.equals(sCCredential = SCCredentialProviderBase.getSCFromContext(messageContext))) {
            sCTokenBase.setCredential(sCCredential);
        } else {
            WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
            CredentialProvider credentialProvider = wSSecurityContext.getCredentialProvider(sCTokenBase.getValueType());
            SecurityTokenContextHandler securityTokenContextHandler = new SecurityTokenContextHandler(wSSecurityContext);
            SCCredentialProviderBase.setSCToContext(messageContext, sCCredential2);
            sCCredential2 = (SCCredential)credentialProvider.getCredential(sCTokenBase.getValueType(), null, securityTokenContextHandler, Purpose.IDENTITY);
            if (sCCredential2 == null) {
                throw new WSSecurityException("Can not find SCT with id: " + sCTokenBase.getId(), WSSConstants.FAILURE_TOKEN_UNAVAILABLE);
            }
            sCTokenBase.setCredential(sCCredential2);
            SCCredentialProviderBase.setSCToContext(messageContext, sCCredential2);
        }
    }
}

