/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.base.sct;

import java.security.Key;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.rpc.handler.MessageContext;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.connection.transport.servlet.HttpTransportUtils;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.jaxws.persistence.PersistenceConfig;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.security.wssc.base.faults.WSCFaultException;
import weblogic.wsee.security.wssc.base.sct.ClientSCCredentialProviderBase;
import weblogic.wsee.security.wssc.base.sct.SCCredentialProviderBase;
import weblogic.wsee.security.wssc.base.sct.SCTokenBase;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wssc.sct.SCTStore;
import weblogic.wsee.security.wssc.sct.SCTokenReference;
import weblogic.wsee.security.wssc.utils.WSSCCompatibilityUtil;
import weblogic.wsee.security.wst.faults.BadRequestException;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.faults.WSTFaultUtil;
import weblogic.wsee.security.wst.framework.TrustToken;
import weblogic.wsee.security.wst.framework.TrustTokenProvider;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.helpers.TrustTokenHelper;
import weblogic.wsee.server.WsLifeCycleEvent;
import weblogic.wsee.server.WsLifeCycleListenerRegistry;
import weblogic.wsee.util.Guid;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;

public abstract class ServerSCCredentialProviderBase
extends SCCredentialProviderBase
implements TrustTokenProvider {
    protected static final boolean verbose = Verbose.isVerbose(ClientSCCredentialProviderBase.class);

    protected ServerSCCredentialProviderBase() {
    }

    protected abstract SCTokenBase newSCToken(SCCredential var1);

    protected abstract WSCFaultException newUnableToRenewException(String var1);

    public Object getCredential(String string, String string2, ContextHandler contextHandler, Purpose purpose, String string3) {
        if (purpose == null || purpose.equals(Purpose.ENCRYPT_RESPONSE)) {
            return null;
        }
        SecurityTokenContextHandler securityTokenContextHandler = ServerSCCredentialProviderBase.getSecurityCtxHandler(contextHandler);
        if (securityTokenContextHandler == null) {
            return null;
        }
        MessageContext messageContext = ServerSCCredentialProviderBase.getMessageContext(securityTokenContextHandler);
        if (messageContext == null) {
            return null;
        }
        String string4 = ServerSCCredentialProviderBase.getAppliesToEndpoint(messageContext);
        if (string4 == null) {
            return null;
        }
        WSTContext wSTContext = WSTContext.getWSTContext(messageContext);
        wSTContext.setAppliesTo(string4);
        SCCredential sCCredential = ServerSCCredentialProviderBase.getSCFromContext(messageContext);
        if (sCCredential != null && sCCredential.getSecret() != null) {
            ServerSCCredentialProviderBase.checkExpiration(messageContext, sCCredential, string3);
            ServerSCCredentialProviderBase.removeDelayedCancelSCToken(messageContext, sCCredential.getIdentifier());
            return sCCredential;
        }
        SCCredential sCCredential2 = null;
        if (sCCredential != null) {
            String string5 = ServerSCCredentialProviderBase.getPhysicalStoreNameFromMessageContext(messageContext);
            sCCredential2 = SCTStore.get(sCCredential.getIdentifier(), string5);
        }
        ServerSCCredentialProviderBase.getSession(messageContext, false);
        ServerSCCredentialProviderBase.checkExpiration(messageContext, sCCredential2, string3);
        if (sCCredential2 != null) {
            ServerSCCredentialProviderBase.removeDelayedCancelSCToken(messageContext, sCCredential2.getIdentifier());
        }
        return sCCredential2;
    }

    public TrustToken issueTrustToken(WSTContext wSTContext) throws WSTFaultException {
        SCCredential sCCredential = ServerSCCredentialProviderBase.createNewSCCredential(wSTContext);
        SCTokenBase sCTokenBase = this.newSCToken(sCCredential);
        return sCTokenBase;
    }

    public TrustToken renewTrustToken(WSTContext wSTContext, TrustToken trustToken) throws WSTFaultException {
        SCTokenBase sCTokenBase = (SCTokenBase)trustToken;
        SCCredential sCCredential = sCTokenBase.getCredential();
        sCCredential.setCreated(wSTContext.getCreated());
        sCCredential.setExpires(wSTContext.getExpires());
        WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_RECV_AFTER_RENEW);
        ServerSCCredentialProviderBase.getSession(wSTContext.getMessageContext(), false);
        String string = this.getPhysicalStoreNameFromWSTContext(wSTContext);
        SCTStore.addToServer(sCCredential, !wSTContext.isSessionPersisted(), string);
        WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_RECV_AFTER_RENEW_SAVE);
        return sCTokenBase;
    }

    public void cancelTrustToken(WSTContext wSTContext, TrustToken trustToken) throws WSTFaultException {
        String string;
        MessageContext messageContext = wSTContext.getMessageContext();
        int n = WSSCCompatibilityUtil.getWSSCVersion(messageContext);
        boolean bl = n == 2 || n == 3;
        String string2 = trustToken.getTrustCredential().getIdentifier();
        if (bl) {
            string = ServerSCCredentialProviderBase.getPhysicalStoreNameFromMessageContext(messageContext);
            SCCredential sCCredential = SCTStore.get(string2, string);
            ServerSCCredentialProviderBase.setSCToContext(messageContext, sCCredential);
            String string3 = (String)messageContext.getProperty("DELAYED_SCTOKEN_CANCEL");
            if (string3 != null) {
                if (!string3.equals(string2)) {
                    ServerSCCredentialProviderBase.removeDelayedCancelSCToken(messageContext, string3);
                } else {
                    return;
                }
            }
            messageContext.setProperty("DELAYED_SCTOKEN_CANCEL", (Object)string2);
        }
        string = ServerSCCredentialProviderBase.getPhysicalStoreNameFromMessageContext(messageContext);
        SCTStore.removeFromServer(string2, string);
        ServerSCCredentialProviderBase.getSession(wSTContext.getMessageContext(), false);
    }

    public SecurityTokenReference createSecurityTokenReference(WSTContext wSTContext, TrustToken trustToken) throws WSTFaultException {
        if (!(trustToken instanceof SCTokenBase)) {
            WSTFaultUtil.raiseFault(new BadRequestException(trustToken.getValueType() + " is not a supported SCT"));
        }
        try {
            return new SCTokenReference(WSSConstants.REFERENCE_QNAME, (SCTokenBase)trustToken);
        }
        catch (WSSecurityException wSSecurityException) {
            WSTFaultUtil.raiseFault(new BadRequestException(wSSecurityException.getMessage()));
            return null;
        }
    }

    public TrustToken resolveTrustToken(WSTContext wSTContext, SecurityTokenReference securityTokenReference) throws WSTFaultException {
        TrustToken trustToken = TrustTokenHelper.getTrustCredentialFromSecurityContext(wSTContext, securityTokenReference);
        if (trustToken != null) {
            return trustToken;
        }
        throw this.newUnableToRenewException("Unable to resolve SC Token from STR: " + securityTokenReference.getReferenceURI());
    }

    private static void removeDelayedCancelSCToken(MessageContext messageContext, String string) {
        String string2 = (String)messageContext.getProperty("DELAYED_SCTOKEN_CANCEL");
        if (string2 != null && string2.equals(string)) {
            messageContext.removeProperty("DELAYED_SCTOKEN_CANCEL");
            try {
                String string3 = ServerSCCredentialProviderBase.getPhysicalStoreNameFromMessageContext(messageContext);
                SCTStore.removeFromServer(string, string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static HttpSession getSession(MessageContext messageContext, boolean bl) {
        if (messageContext == null) {
            return null;
        }
        HttpServletRequest httpServletRequest = HttpTransportUtils.getHttpServletRequest(messageContext);
        if (httpServletRequest != null) {
            return httpServletRequest.getSession(bl);
        }
        return null;
    }

    private static SCCredential createNewSCCredential(WSTContext wSTContext) {
        Object object;
        String string;
        Key key = wSTContext.getSymmetricKey();
        if (key == null) {
            throw new IllegalArgumentException("SecretKey is not yet generated");
        }
        MessageContext messageContext = wSTContext.getMessageContext();
        String string2 = null;
        if (!ServerSCCredentialProviderBase.isJaxwsRuntime(messageContext)) {
            string = Guid.generateGuidWithServerName();
        } else {
            boolean bl;
            block5: {
                object = WlMessageContext.narrow(messageContext);
                PersistenceConfig.Common common = ServerSCCredentialProviderBase.getPersistenceConfigFromMessageContext((WlMessageContext)object);
                string2 = ServerSCCredentialProviderBase.getPhysicalStoreName(common);
                bl = false;
                try {
                    bl = !common.getLogicalStoreMBean().getPersistenceStrategy().equals("NETWORK_ACCESSIBLE");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!verbose) break block5;
                    Verbose.log("Logical Store Not Found Error Message = " + illegalArgumentException.getMessage());
                }
            }
            string = bl ? ServerSCCredentialProviderBase.getRoutableId(string2) : Guid.generateGuidWithServerName();
        }
        object = new SCCredential();
        ((SCCredential)object).setIdentifier(string);
        ((SCCredential)object).setSecret(key);
        ((SCCredential)object).setAppliesTo(wSTContext.getAppliesTo());
        ((SCCredential)object).setAppliesToElement(wSTContext.getAppliesToElement());
        ((SCCredential)object).setCreated(wSTContext.getCreated());
        ((SCCredential)object).setExpires(wSTContext.getExpires());
        WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_RECV_RST_BEFORE_SAVE);
        SCTStore.addToServer((SCCredential)object, !wSTContext.isSessionPersisted(), string2);
        WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_RECV_RST_AFTER_SAVE);
        ServerSCCredentialProviderBase.setSCToContext(messageContext, (SCCredential)object);
        ServerSCCredentialProviderBase.getSession(messageContext, true);
        return object;
    }

    private static String getRoutableId(String string) {
        return WsUtil.generateRoutableUUID(string);
    }
}

