/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.dk;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.wss.policy.GeneralPolicy;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wssp.AlgorithmSuiteInfo;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityInfo;
import weblogic.xml.crypto.wss.policy.Claims;
import weblogic.xml.crypto.wss.policy.ClaimsBuilder;

public class DKClaims
implements Claims {
    private static final boolean verbose = Verbose.isVerbose(DKClaims.class);
    private static final String POLICY_URI = "http://www.bea.com/wls90/security/policy";
    private static final QName CLAIMS = new QName("http://www.bea.com/wls90/security/policy", "Claims");
    private static final QName LABEL = new QName("http://www.bea.com/wls90/security/policy", "Label");
    private static final QName LENGTH = new QName("http://www.bea.com/wls90/security/policy", "Length");

    public static Element makeClaimsNode() throws SecurityPolicyArchitectureException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            if (verbose) {
                Verbose.log("makeDKClaimsNode: got document");
            }
            Element element = document.createElementNS(CLAIMS.getNamespaceURI(), "wssp:" + CLAIMS.getLocalPart());
            if (verbose) {
                Verbose.log("makeDKClaimsNode: got CLAIMS element");
            }
            return element;
        }
        catch (Exception exception) {
            if (verbose) {
                Verbose.log("makeDKClaimsNode: caught exception: " + exception.toString());
            }
            exception.printStackTrace();
            throw new SecurityPolicyArchitectureException(exception);
        }
    }

    public static Node makeDKClaimsNode(GeneralPolicy generalPolicy, String string, AlgorithmSuiteInfo algorithmSuiteInfo) throws SecurityPolicyArchitectureException {
        String string2;
        if (verbose) {
            Verbose.banner("makeDKClaimsNode");
            Verbose.log("label is '" + string + "'");
            if (algorithmSuiteInfo == null) {
                Verbose.log("AlgorithmSuiteInfo is null!");
            } else {
                Verbose.log("MinSKL from ASI is '" + Integer.toString(algorithmSuiteInfo.getMinSymKeyLength()) + "'");
            }
        }
        Element element = DKClaims.makeClaimsNode();
        Element element2 = DOMUtils.createAndAddElement(element, LABEL, element.getPrefix());
        if (verbose) {
            Verbose.log("makeDKClaimsNode: got LABEL element");
        }
        String string3 = string2 = string != null ? string : "WS-SecureConversationWS-SecureConversation";
        if (verbose) {
            Verbose.log("makeDKClaimsNode: label string is " + string2);
        }
        DOMUtils.addText(element2, string2);
        if (verbose) {
            Verbose.log("makeDKClaimsNode: set label string");
        }
        Element element3 = DOMUtils.createAndAddElement(element, LENGTH, element.getPrefix());
        if (verbose) {
            Verbose.log("makeDKClaimsNode: got LENGTH element");
        }
        int n = algorithmSuiteInfo != null && algorithmSuiteInfo.getMinSymKeyLength() > 0 ? algorithmSuiteInfo.getMinSymKeyLength() / 8 : 32;
        String string4 = Integer.toString(n);
        if (verbose) {
            Verbose.log("makeDKClaimsNode: length string is " + string4);
        }
        DOMUtils.addText(element3, string4);
        if (verbose) {
            Verbose.log("makeDKClaimsNode: set length string");
        }
        if (verbose) {
            Verbose.log("makeDKClaimsNode: returning claims");
        }
        return element;
    }

    public static String getLabelFromContextHandler(ContextHandler contextHandler) {
        String string;
        String string2;
        if (verbose) {
            Verbose.banner("DKClaims.getLabelFromContextHandler");
        }
        if ((string2 = (String)contextHandler.getValue(SecurityTokenContextHandler.DK_LABEL)) != null) {
            if (verbose) {
                Verbose.log("DKLabel: returning label from context handler: " + string2);
            }
            return string2;
        }
        Node node = (Node)contextHandler.getValue("weblogic.xml.crypto.wss.policy.Claims");
        if (node != null) {
            if (verbose) {
                Verbose.log("DKLabel: claims not null");
            }
            if ((string2 = ClaimsBuilder.getClaimFromElt(node, LABEL)) != null) {
                if (verbose) {
                    Verbose.log("DKLabel: label from claims is " + string2);
                }
                return string2;
            }
        }
        if ((string = DKClaims.getDKlabelFromWSSConfig(contextHandler)) != null) {
            if (verbose) {
                Verbose.log("DKLabel: returning label configured via mbean from context handler: " + string);
            }
            return string;
        }
        if (verbose) {
            Verbose.log("DKLabel: returning default label: WS-SecureConversation");
        }
        return "WS-SecureConversation";
    }

    public static int getLengthFromContextHandler(ContextHandler contextHandler) {
        Object object;
        Integer n;
        if (verbose) {
            Verbose.banner("DKClaims.getLengthFromContextHandler");
        }
        if ((n = (Integer)contextHandler.getValue("weblogic.wsee.wssc.dk.length")) != null) {
            if (verbose) {
                Verbose.log("DKLength: returning length from context handler: " + n);
            }
            return n;
        }
        Node node = (Node)contextHandler.getValue("weblogic.xml.crypto.wss.policy.Claims");
        if (node != null) {
            if (verbose) {
                Verbose.log("DKLength: claims not null");
            }
            if ((object = ClaimsBuilder.getClaimFromElt(node, LENGTH)) != null) {
                if (verbose) {
                    Verbose.log("DKLength: length from claims is " + (String)object);
                }
                return Integer.parseInt((String)object);
            }
            if (node instanceof Element && "http://schemas.xmlsoap.org/ws/2005/02/sc/dk".equals(((Element)node).getAttribute("TokenType"))) {
                if (verbose) {
                    Verbose.log("DKLength: returning 9.2 default length 16");
                }
                return 16;
            }
        }
        if ((object = DKClaims.getDKLengthFromWSSConfig(contextHandler)) != null && (Integer)object != -1) {
            if (verbose) {
                Verbose.log("DKLength: returning length configured via mbeanfrom context handler: " + object);
            }
            return (Integer)object;
        }
        if (verbose) {
            Verbose.log("DKLength: returning default length: 32");
        }
        return 32;
    }

    private static Integer getDKLengthFromWSSConfig(ContextHandler contextHandler) {
        WssPolicyContext wssPolicyContext = DKClaims.getWSSPolicyContext(contextHandler);
        if (wssPolicyContext != null) {
            return wssPolicyContext.getWssConfiguration().getDKLength();
        }
        return null;
    }

    private static String getDKlabelFromWSSConfig(ContextHandler contextHandler) {
        WssPolicyContext wssPolicyContext = DKClaims.getWSSPolicyContext(contextHandler);
        if (wssPolicyContext != null) {
            return wssPolicyContext.getWssConfiguration().getDKLabel();
        }
        return null;
    }

    private static WssPolicyContext getWSSPolicyContext(ContextHandler contextHandler) {
        WSSecurityContext wSSecurityContext;
        MessageContext messageContext;
        WSSecurityInfo wSSecurityInfo = (WSSecurityInfo)contextHandler.getValue("com.bea.contextelement.xml.SecurityInfo");
        if (wSSecurityInfo instanceof WSSecurityContext && (messageContext = (wSSecurityContext = (WSSecurityContext)wSSecurityInfo).getMessageContext()) != null) {
            return (WssPolicyContext)messageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
        }
        return null;
    }
}

