/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.sct;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.Key;
import java.util.Calendar;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.security.configuration.TimestampConfiguration;
import weblogic.wsee.security.wssc.sct.SCTExternalizationUtil;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.framework.TrustCredential;
import weblogic.wsee.server.StateExpiration;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.KeyIdentifierImpl;
import weblogic.xml.crypto.wss.api.KeyIdentifier;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;

public class SCCredential
implements TrustCredential,
Externalizable,
StateExpiration {
    private static final long serialVersionUID = -2509719402171717073L;
    protected static final boolean verbose = Verbose.isVerbose(SCCredential.class);
    private static final String ELEMENT_FLAG = "<![[]]>";
    public static final int SCT_RETENTION_PRIOR = 600;
    private static final int ELEMENT_FLAG_SIZE = "<![[]]>".length();
    protected String identifier;
    protected Key secretKey;
    protected Subject authenticatedSubject;
    protected String appliesTo;
    protected Element appliesToElement;
    protected Calendar created;
    protected Calendar expires;
    protected String tokenId;
    protected String securityContextTokenIDAttribute;
    protected String NETCookieValue;
    protected QName NETCookieQName;
    protected String NETCookiePrefix;
    protected SecurityTokenReferenceInfo unattachedSecurityTokenReferenceInfo;
    protected SecurityTokenReferenceInfo attachedSecurityTokenReferenceInfo;
    protected String scNamespace = "";

    public Subject getSubject() {
        return this.authenticatedSubject;
    }

    public void setSubject(Subject subject) {
        this.authenticatedSubject = subject;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public String getSecurityContextTokenIDAttribute() {
        return this.securityContextTokenIDAttribute;
    }

    public void setSecurityContextTokenIDAttribute(String string) {
        this.securityContextTokenIDAttribute = string;
    }

    public Key getSecret() {
        return this.secretKey;
    }

    public void setSecret(Key key) {
        this.secretKey = key;
    }

    public String getAppliesTo() {
        return this.appliesTo;
    }

    public void setAppliesTo(String string) {
        this.appliesTo = string;
    }

    public Element getAppliesToElement() {
        return this.appliesToElement;
    }

    public void setAppliesToElement(Element element) {
        this.appliesToElement = element;
    }

    public void setCreated(Calendar calendar) {
        this.created = calendar;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public void setExpires(Calendar calendar) {
        this.expires = calendar;
    }

    public Calendar getExpires() {
        return this.expires;
    }

    public void setScNamespace(String string) {
        this.scNamespace = string;
    }

    public String getScNamespace() {
        return this.scNamespace;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String string) {
        this.tokenId = string;
    }

    public void setNETCookieValue(String string) {
        this.NETCookieValue = string;
    }

    public String getNETCookieValue() {
        return this.NETCookieValue;
    }

    public void setNETCookieQName(QName qName) {
        this.NETCookieQName = qName;
    }

    public QName getNETCookieQName() {
        return this.NETCookieQName;
    }

    public SecurityTokenReferenceInfo newUnattachedSecurityTokenReferenceInfo() {
        this.unattachedSecurityTokenReferenceInfo = new SecurityTokenReferenceInfo();
        return this.unattachedSecurityTokenReferenceInfo;
    }

    public SecurityTokenReferenceInfo newAttachedSecurityTokenReferenceInfo() {
        this.attachedSecurityTokenReferenceInfo = new SecurityTokenReferenceInfo();
        return this.attachedSecurityTokenReferenceInfo;
    }

    public SecurityTokenReferenceInfo getUnattachedSecurityTokenReferenceInfo() {
        return this.unattachedSecurityTokenReferenceInfo;
    }

    public SecurityTokenReferenceInfo getAttachedSecurityTokenReferenceInfo() {
        return this.attachedSecurityTokenReferenceInfo;
    }

    public void setUnattachedSecurityTokenReferenceInfo(SecurityTokenReferenceInfo securityTokenReferenceInfo) {
        this.unattachedSecurityTokenReferenceInfo = securityTokenReferenceInfo;
    }

    public void setAttachedSecurityTokenReferenceInfo(SecurityTokenReferenceInfo securityTokenReferenceInfo) {
        this.attachedSecurityTokenReferenceInfo = securityTokenReferenceInfo;
    }

    public boolean hasUnattachedSecurityTokenReference() {
        return this.unattachedSecurityTokenReferenceInfo != null;
    }

    public boolean hasAttachedSecurityTokenReference() {
        return this.attachedSecurityTokenReferenceInfo != null;
    }

    public boolean equals(Object object) {
        SCCredential sCCredential;
        if (object instanceof SCCredential && (sCCredential = (SCCredential)object).getIdentifier() != null && this.getIdentifier() != null) {
            return sCCredential.getIdentifier().equals(this.getIdentifier());
        }
        return false;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.identifier);
        SCTExternalizationUtil.writeKey(this.secretKey, objectOutput);
        SCTExternalizationUtil.writeSubject(this.authenticatedSubject, objectOutput);
        if (this.appliesToElement != null) {
            objectOutput.writeUTF(ELEMENT_FLAG + DOMUtils.toXMLString(this.appliesToElement));
        } else {
            objectOutput.writeUTF(this.appliesTo);
        }
        SCTExternalizationUtil.writeCalendar(this.created, objectOutput);
        SCTExternalizationUtil.writeCalendar(this.expires, objectOutput);
        objectOutput.writeUTF(this.scNamespace);
        SCTExternalizationUtil.writeConditionalString(this.NETCookieValue, objectOutput);
        SCTExternalizationUtil.writeConditionalQName(this.NETCookieQName, objectOutput);
        SCTExternalizationUtil.writeConditionalString(this.securityContextTokenIDAttribute, objectOutput);
        SCTExternalizationUtil.writeConditionalSecurityTokenReferenceInfo(this.unattachedSecurityTokenReferenceInfo, objectOutput);
        SCTExternalizationUtil.writeConditionalSecurityTokenReferenceInfo(this.attachedSecurityTokenReferenceInfo, objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.identifier = objectInput.readUTF();
        this.secretKey = SCTExternalizationUtil.readKey(objectInput);
        this.authenticatedSubject = SCTExternalizationUtil.readSubject(objectInput);
        this.appliesTo = objectInput.readUTF();
        if (this.appliesTo != null && this.appliesTo.startsWith(ELEMENT_FLAG)) {
            this.appliesToElement = (Element)DOMUtils.toXMLNode(this.appliesTo.substring(ELEMENT_FLAG_SIZE)).getFirstChild();
            this.appliesTo = null;
        }
        this.created = SCTExternalizationUtil.readCalendar(objectInput);
        this.expires = SCTExternalizationUtil.readCalendar(objectInput);
        this.scNamespace = objectInput.readUTF();
        this.NETCookieValue = SCTExternalizationUtil.readConditionalString(objectInput);
        this.NETCookieQName = SCTExternalizationUtil.readConditionalQName(objectInput);
        this.securityContextTokenIDAttribute = SCTExternalizationUtil.readConditionalString(objectInput);
        this.unattachedSecurityTokenReferenceInfo = SCTExternalizationUtil.readConditionalSecurityTokenReferenceInfo(objectInput);
        this.attachedSecurityTokenReferenceInfo = SCTExternalizationUtil.readConditionalSecurityTokenReferenceInfo(objectInput);
    }

    public boolean isExpired() {
        try {
            if (this.expires == null) {
                return false;
            }
            Calendar calendar = (Calendar)this.expires.clone();
            calendar.add(13, 600);
            TimestampConfiguration timestampConfiguration = new TimestampConfiguration();
            timestampConfiguration.checkExpiration(this.created, calendar);
        }
        catch (SOAPFaultException sOAPFaultException) {
            if (verbose) {
                Verbose.log("SC credential is expired. Msg = " + sOAPFaultException.getMessage());
            }
            return true;
        }
        return false;
    }

    public static SCCredential copy(SCCredential sCCredential, SCCredential sCCredential2) {
        sCCredential2.setAppliesTo(sCCredential.getAppliesTo());
        sCCredential2.setAppliesToElement(sCCredential.getAppliesToElement());
        sCCredential2.setCreated(sCCredential.getCreated());
        sCCredential2.setExpires(sCCredential.getExpires());
        sCCredential2.setIdentifier(sCCredential.getIdentifier());
        sCCredential2.setNETCookieQName(sCCredential.getNETCookieQName());
        sCCredential2.setNETCookieValue(sCCredential.getNETCookieValue());
        sCCredential2.setScNamespace(sCCredential.getScNamespace());
        sCCredential2.setSecret(sCCredential.getSecret());
        sCCredential2.setSecurityContextTokenIDAttribute(sCCredential.getSecurityContextTokenIDAttribute());
        sCCredential2.setSubject(sCCredential.getSubject());
        sCCredential2.setTokenId(sCCredential.getTokenId());
        sCCredential2.setAttachedSecurityTokenReferenceInfo(sCCredential.getAttachedSecurityTokenReferenceInfo());
        sCCredential2.setUnattachedSecurityTokenReferenceInfo(sCCredential.getUnattachedSecurityTokenReferenceInfo());
        return sCCredential2;
    }

    public static void copyFromSTRToInfo(SecurityTokenReference securityTokenReference, SecurityTokenReferenceInfo securityTokenReferenceInfo) throws WSTFaultException {
        QName qName = securityTokenReference.getSTRType();
        if (qName.equals("Embedded")) {
            throw new WSTFaultException("Cannot process <RequestedUnattachedReference> or <RequestedAttachedReference> that contains a <SecurityTokenReference> with an Embedded Security Token");
        }
        securityTokenReferenceInfo.setId(securityTokenReference.getId());
        securityTokenReferenceInfo.setReferenceURI(securityTokenReference.getReferenceURI());
        securityTokenReferenceInfo.setValueType(securityTokenReference.getValueType());
        securityTokenReferenceInfo.setSTRType(qName);
        KeyIdentifier keyIdentifier = securityTokenReference.getKeyIdentifier();
        if (keyIdentifier != null) {
            securityTokenReferenceInfo.setKeyIdentifier_identifier(keyIdentifier.getIdentifier());
            securityTokenReferenceInfo.setKeyIdentifier_encoding(keyIdentifier.getEncodingType());
        }
    }

    public static void copyFromInfoToSTR(SecurityTokenReferenceInfo securityTokenReferenceInfo, SecurityTokenReference securityTokenReference) {
        securityTokenReference.setId(securityTokenReferenceInfo.getId());
        securityTokenReference.setReferenceURI(securityTokenReferenceInfo.getReferenceURI());
        securityTokenReference.setValueType(securityTokenReferenceInfo.getValueType());
        securityTokenReference.setSTRType(securityTokenReferenceInfo.getSTRType());
        byte[] byArray = securityTokenReferenceInfo.getKeyIdentifier_identifier();
        if (byArray != null) {
            String string = securityTokenReferenceInfo.getKeyIdentifier_encoding();
            KeyIdentifierImpl keyIdentifierImpl = new KeyIdentifierImpl(byArray, string);
            securityTokenReference.setKeyIdentifier(keyIdentifierImpl);
        }
    }

    public class SecurityTokenReferenceInfo
    implements Serializable {
        QName strType;
        String id;
        String referenceURI;
        String valueType;
        byte[] keyIdentifier_identifier;
        String keyIdentifier_encoding;

        public void setSTRType(QName qName) {
            this.strType = qName;
        }

        public QName getSTRType() {
            return this.strType;
        }

        public void setId(String string) {
            this.id = string;
        }

        public String getId() {
            return this.id;
        }

        public void setReferenceURI(String string) {
            this.referenceURI = string;
        }

        public String getReferenceURI() {
            return this.referenceURI;
        }

        public void setValueType(String string) {
            this.valueType = string;
        }

        public String getValueType() {
            return this.valueType;
        }

        public void setKeyIdentifier_identifier(byte[] byArray) {
            this.keyIdentifier_identifier = byArray;
        }

        public byte[] getKeyIdentifier_identifier() {
            return this.keyIdentifier_identifier;
        }

        public void setKeyIdentifier_encoding(String string) {
            this.keyIdentifier_encoding = string;
        }

        public String getKeyIdentifier_encoding() {
            return this.keyIdentifier_encoding;
        }
    }
}

