/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.sct;

import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import weblogic.security.service.ContextHandler;
import weblogic.xml.crypto.wss.policy.ClaimsBuilder;

public class SCTClaims {
    private static final String POLICY_URI = "http://www.bea.com/wls90/security/policy";
    private static final QName TOKEN_LIFETIME = new QName("http://www.bea.com/wls90/security/policy", "TokenLifeTime");
    private long lifetime = -1L;

    private SCTClaims(Node node, Long l) {
        this(l);
        String string;
        if (node != null && (string = ClaimsBuilder.getClaimFromElt(node, TOKEN_LIFETIME)) != null && string.length() > 0) {
            try {
                l = Long.parseLong(string) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private SCTClaims(Long l) {
        if (l != null) {
            this.lifetime = l;
        }
    }

    public static SCTClaims newInstance(ContextHandler contextHandler) {
        Long l = (Long)contextHandler.getValue("weblogic.wsee.wssc.sct.lifetime");
        Node node = (Node)contextHandler.getValue("weblogic.xml.crypto.wss.policy.Claims");
        return new SCTClaims(node, l);
    }

    public long getTokenLifetime() {
        return this.lifetime;
    }
}

