/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.sct;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Key;
import java.util.Calendar;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.server.EncryptionUtil;

public class SCTExternalizationUtil {
    private static final String AES_KEY_FACTORY_ID = "AES";

    public static void writeKey(Key key, ObjectOutput objectOutput) throws IOException {
        byte[] byArray = key.getEncoded();
        byte[] byArray2 = EncryptionUtil.encrypt(byArray);
        objectOutput.writeShort(byArray2.length);
        objectOutput.write(byArray2);
    }

    public static Key readKey(ObjectInput objectInput) throws IOException {
        short s = objectInput.readShort();
        byte[] byArray = new byte[s];
        objectInput.read(byArray);
        byte[] byArray2 = EncryptionUtil.decrypt(byArray);
        return new SecretKeySpec(byArray2, AES_KEY_FACTORY_ID);
    }

    public static void writeSubject(Subject subject, ObjectOutput objectOutput) throws IOException {
        if (subject == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(subject);
        }
    }

    public static Subject readSubject(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Subject subject = null;
        if (objectInput.readBoolean()) {
            subject = (Subject)objectInput.readObject();
        }
        return subject;
    }

    public static void writeCalendar(Calendar calendar, ObjectOutput objectOutput) throws IOException {
        if (calendar == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(calendar);
        }
    }

    public static Calendar readCalendar(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Calendar calendar = null;
        if (objectInput.readBoolean()) {
            calendar = (Calendar)objectInput.readObject();
        }
        return calendar;
    }

    public static void writeConditionalString(String string, ObjectOutput objectOutput) throws IOException {
        if (string == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(string);
        }
    }

    public static void writeConditionalQName(QName qName, ObjectOutput objectOutput) throws IOException {
        if (qName == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(qName);
        }
    }

    public static String readConditionalString(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = null;
        if (objectInput.readBoolean()) {
            string = (String)objectInput.readObject();
        }
        return string;
    }

    public static QName readConditionalQName(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        QName qName = null;
        if (objectInput.readBoolean()) {
            qName = (QName)objectInput.readObject();
        }
        return qName;
    }

    public static void writeConditionalSecurityTokenReferenceInfo(SCCredential.SecurityTokenReferenceInfo securityTokenReferenceInfo, ObjectOutput objectOutput) throws IOException {
        if (securityTokenReferenceInfo == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeObject(securityTokenReferenceInfo);
        }
    }

    public static SCCredential.SecurityTokenReferenceInfo readConditionalSecurityTokenReferenceInfo(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        SCCredential.SecurityTokenReferenceInfo securityTokenReferenceInfo = null;
        if (objectInput.readBoolean()) {
            securityTokenReferenceInfo = (SCCredential.SecurityTokenReferenceInfo)objectInput.readObject();
        }
        return securityTokenReferenceInfo;
    }
}

