/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.sct;

import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wssc.sct.SCTObjectHandler;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;

public class SCTStore {
    private static final Logger LOGGER = Logger.getLogger(SCTStore.class.getName());
    public static final String WSSC_STORE_NAME_PREFIX = "weblogic.wsee.wssc.store";
    public static final String WSSC_SERVER_STORE_NAME = ".server";
    public static final String WSSC_CLIENT_STORE_NAME = ".client";
    private static WsStorage rpcServerStore;
    private static WsStorage rpcStore;

    private static void initializeRPCStores() {
        if (rpcServerStore != null) {
            return;
        }
        rpcServerStore = WsStorageFactory.getStorage("weblogic.wsee.wssc.store.server", new SCTObjectHandler());
        rpcStore = WsStorageFactory.getStorage("weblogic.wsee.wssc.store.client", new SCTObjectHandler());
    }

    public static SCCredential get(String string, String string2) {
        WsStorage wsStorage = SCTStore.getServerStore(string2);
        WsStorage wsStorage2 = SCTStore.getClientStore(string2);
        try {
            SCCredential sCCredential;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Trying to get SCT '" + string + "' in in-memory serverStore");
            }
            if ((sCCredential = (SCCredential)wsStorage.get(string)) == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Couldn't find SCT '" + string + "' in in-memory serverStore. Trying in-memory clientStore");
                }
                if ((sCCredential = (SCCredential)wsStorage2.get(string)) == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Couldn't find SCT '" + string + "' in in-memory clientStore. Trying persistent serverStore");
                    }
                    if ((sCCredential = (SCCredential)wsStorage.persistentGet(string)) == null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Couldn't find SCT '" + string + "' in persistent serverStore(" + string2 + "). Trying persistent clientStore");
                        }
                        if ((sCCredential = (SCCredential)wsStorage2.persistentGet(string)) == null) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Couldn't find SCT '" + string + "' in persistent clientStore(" + string2 + "). Giving up.");
                            }
                        } else if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Found SCT '" + string + "' in persistent clientStore(" + string2 + ").");
                        }
                    } else if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Found SCT '" + string + "' in persistent serverStore(" + string2 + ").");
                    }
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Found SCT '" + string + "' in in-memory clientStore.");
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Found SCT '" + string + "' in in-memory serverStore");
            }
            return sCCredential;
        }
        catch (PersistentStoreException persistentStoreException) {
            persistentStoreException.printStackTrace();
            return null;
        }
    }

    public static SCCredential getFromServer(String string, String string2) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Trying to get SCT '" + string + "' from server store with physicalStoreName '" + string2 + "'");
        }
        WsStorage wsStorage = SCTStore.getServerStore(string2);
        return SCTStore.getFromStore(wsStorage, string);
    }

    public static SCCredential getFromClient(String string, String string2) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Trying to get SCT '" + string + "' from client store with physicalStoreName '" + string2 + "'");
        }
        WsStorage wsStorage = SCTStore.getClientStore(string2);
        return SCTStore.getFromStore(wsStorage, string);
    }

    private static SCCredential getFromStore(WsStorage wsStorage, String string) {
        try {
            SCCredential sCCredential;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Trying to get SCT '" + string + "' from store '" + wsStorage.getName() + "'");
            }
            if ((sCCredential = (SCCredential)wsStorage.get(string)) == null) {
                sCCredential = (SCCredential)wsStorage.persistentGet(string);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine((sCCredential == null ? "Couldn't find" : "Found") + " SCT '" + string + "' in store '" + wsStorage.getName() + "'");
            }
            return sCCredential;
        }
        catch (PersistentStoreException persistentStoreException) {
            persistentStoreException.printStackTrace();
            return null;
        }
    }

    public static boolean addToServer(SCCredential sCCredential, boolean bl, String string) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Adding SCT '" + sCCredential.getIdentifier() + "' to server SCT store with physicalStoreName '" + string + "'");
        }
        WsStorage wsStorage = SCTStore.getServerStore(string);
        return SCTStore.addToStore(wsStorage, sCCredential, bl);
    }

    private static WsStorage getClientStore(String string) {
        if (string == null) {
            SCTStore.initializeRPCStores();
            return rpcStore;
        }
        return WsStorageFactory.getStorage("weblogic.wsee.wssc.store.client" + string, new SCTObjectHandler());
    }

    private static WsStorage getServerStore(String string) {
        if (string == null) {
            SCTStore.initializeRPCStores();
            return rpcServerStore;
        }
        return WsStorageFactory.getStorage("weblogic.wsee.wssc.store.server" + string, new SCTObjectHandler());
    }

    public static boolean addToClient(SCCredential sCCredential, boolean bl, String string) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Adding SCT '" + sCCredential.getIdentifier() + "' to client SCT store with physicalStoreName '" + string + "'");
        }
        WsStorage wsStorage = SCTStore.getClientStore(string);
        return SCTStore.addToStore(wsStorage, sCCredential, bl);
    }

    private static boolean addToStore(WsStorage wsStorage, SCCredential sCCredential, boolean bl) {
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Adding SCT '" + sCCredential.getIdentifier() + "' to store '" + wsStorage.getName() + "'");
            }
            if (bl) {
                return wsStorage.put(sCCredential.getIdentifier(), sCCredential);
            }
            return wsStorage.persistentPut(sCCredential.getIdentifier(), sCCredential);
        }
        catch (PersistentStoreException persistentStoreException) {
            return false;
        }
    }

    public static boolean remove(String string, String string2) {
        return SCTStore.removeFromServer(string, string2) || SCTStore.removeFromClient(string, string2);
    }

    public static boolean removeFromServer(String string, String string2) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Removing SCT '" + string + "' from server SCT store with physicalStoreName '" + string2 + "'");
        }
        WsStorage wsStorage = SCTStore.getServerStore(string2);
        return SCTStore.removeFromStore(wsStorage, string);
    }

    public static boolean removeFromClient(String string, String string2) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Removing SCT '" + string + "' from client SCT store with physicalStoreName '" + string2 + "'");
        }
        WsStorage wsStorage = SCTStore.getClientStore(string2);
        return SCTStore.removeFromStore(wsStorage, string);
    }

    private static boolean removeFromStore(WsStorage wsStorage, String string) {
        try {
            Object object;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Removing SCT '" + string + "' from store '" + wsStorage.getName() + "'");
            }
            if ((object = wsStorage.get(string)) != null) {
                return wsStorage.remove(string);
            }
            return wsStorage.persistentRemove(string);
        }
        catch (PersistentStoreException persistentStoreException) {
            return false;
        }
    }
}

