/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.ws.BindingProvider;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.reliability.WsrmSAFManager;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability.WsrmSequenceContext;
import weblogic.wsee.reliability2.property.WsrmInvocationPropertyBag;
import weblogic.wsee.reliability2.sequence.SourceSequence;
import weblogic.wsee.reliability2.sequence.SourceSequenceManager;
import weblogic.wsee.reliability2.sequence.UnknownSourceSequenceException;
import weblogic.wsee.security.wssc.base.sct.ClientSCCredentialProviderBase;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wst.framework.WSTContext;

public class WSSCClientUtil {
    private static final Logger LOGGER = Logger.getLogger(WSSCClientUtil.class.getName());

    public static void terminateWssc(Stub stub) {
        RmHelper rmHelper = new RmHelper(stub);
        if (rmHelper.checkSCCredentialInContext()) {
            ClientSCCredentialProviderBase.cancelSCToken(stub);
        } else {
            ClientSCCredentialProviderBase.cancelSCToken(rmHelper.getMessageContextAdapter(false));
        }
    }

    public static void terminateWssc(BindingProvider bindingProvider) {
        RmHelper rmHelper = new RmHelper(bindingProvider);
        if (rmHelper.checkSCCredentialInContext()) {
            ClientSCCredentialProviderBase.cancelSCToken(bindingProvider);
        } else {
            ClientSCCredentialProviderBase.cancelSCToken(rmHelper.getMessageContextAdapter(false));
        }
    }

    public static void terminateWssc(MessageContext messageContext) {
        ClientSCCredentialProviderBase.cancelSCToken(messageContext);
    }

    public static void renewWssc(Stub stub) {
        RmHelper rmHelper = new RmHelper(stub);
        if (rmHelper.checkSCCredentialInContext()) {
            ClientSCCredentialProviderBase.renewSCToken(stub);
        } else {
            ClientSCCredentialProviderBase.renewSCToken(rmHelper.getMessageContextAdapter(false));
        }
    }

    public static void renewWssc(BindingProvider bindingProvider) {
        RmHelper rmHelper = new RmHelper(bindingProvider);
        if (rmHelper.checkSCCredentialInContext()) {
            ClientSCCredentialProviderBase.renewSCToken(bindingProvider);
        } else {
            ClientSCCredentialProviderBase.renewSCToken(rmHelper.getMessageContextAdapter(false));
        }
    }

    public static void renewWssc(MessageContext messageContext) {
        ClientSCCredentialProviderBase.renewSCToken(messageContext);
    }

    private static class RmHelper {
        private Map<String, Object> invokeProperties = null;

        public RmHelper(Stub stub) {
            this.invokeProperties = (Map)stub._getProperty("weblogic.wsee.invoke_properties");
        }

        public RmHelper(BindingProvider bindingProvider) {
            this.invokeProperties = bindingProvider.getRequestContext();
        }

        public boolean checkSCCredentialInContext() {
            Object object = this.invokeProperties.get("weblogic.wsee.wssc.sct");
            return object != null && object instanceof SCCredential;
        }

        private WsrmSecurityContext getRmSecurityContext() {
            String string = (String)this.invokeProperties.get("weblogic.wsee.sequenceid");
            if (string == null || string.equals("")) {
                return null;
            }
            SAFConversationInfo sAFConversationInfo = WsrmSAFManager.getConversationInfo(true, string, true);
            if (sAFConversationInfo == null) {
                return null;
            }
            WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
            return wsrmSequenceContext.getWsrmSecurityContext();
        }

        private WsrmSecurityContext getRm2SecurityContext() {
            WsrmInvocationPropertyBag wsrmInvocationPropertyBag = (WsrmInvocationPropertyBag)this.invokeProperties.get(WsrmInvocationPropertyBag.key);
            if (wsrmInvocationPropertyBag == null) {
                return null;
            }
            String string = wsrmInvocationPropertyBag.getSequenceId();
            if (string == null) {
                string = (String)this.invokeProperties.get("weblogic.wsee.reliability2.SequenceID");
            }
            if (string == null) {
                return null;
            }
            try {
                SourceSequence sourceSequence = SourceSequenceManager.getInstance().getSequence(wsrmInvocationPropertyBag.getWsrmVersion(), string, true);
                if (sourceSequence == null) {
                    return null;
                }
                return sourceSequence.getSecurityContext();
            }
            catch (UnknownSourceSequenceException unknownSourceSequenceException) {
                return null;
            }
        }

        public MessageContext getMessageContextAdapter(final boolean bl) {
            WsrmSecurityContext wsrmSecurityContext = this.getRmSecurityContext();
            if (wsrmSecurityContext == null) {
                wsrmSecurityContext = this.getRm2SecurityContext();
            }
            if (wsrmSecurityContext == null) {
                throw new IllegalStateException("Can not find WSRM security context");
            }
            final WsrmSecurityContext wsrmSecurityContext2 = wsrmSecurityContext;
            return new SoapMessageContext(){
                private Map properties = new HashMap(RmHelper.access$000(RmHelper.this));
                {
                    WSTContext wSTContext;
                    if (bl) {
                        this.properties.put("weblogic.wsee.invoke_properties", RmHelper.this.invokeProperties);
                    }
                    if (wsrmSecurityContext2.getSCCredential() != null) {
                        this.properties.put("weblogic.wsee.wssc.sct", wsrmSecurityContext2.getSCCredential());
                    }
                    if ((wSTContext = wsrmSecurityContext2.getWSTContext()) != null) {
                        this.properties.put("weblogic.wsee.security.wst.framework.WSTContext", wSTContext);
                    }
                    try {
                        Map map = wsrmSecurityContext2.newInitializedMap();
                        MessageContext messageContext = wSTContext.getMessageContext();
                        for (String string : map.keySet()) {
                            Object v = map.get(string);
                            messageContext.setProperty(string, v);
                            if (!LOGGER.isLoggable(Level.FINEST)) continue;
                            LOGGER.log(Level.FINEST, "Has put additional security information into WST original message context: " + string + " = [" + v + "]");
                        }
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Has put all additional security information into WST original message context form WSRM security context");
                        }
                    }
                    catch (PolicyException policyException) {
                        throw new IllegalStateException("Can not get properties from WSRM security context", policyException);
                    }
                }

                private boolean isSCCredentialProperty(String string) {
                    return string != null && string.equals("weblogic.wsee.wssc.sct");
                }

                private boolean isWSTContextProperty(String string) {
                    return string != null && string.equals("weblogic.wsee.security.wst.framework.WSTContext");
                }

                public void setProperty(String string, Object object) {
                    this.properties.put(string, object);
                    if (this.isSCCredentialProperty(string)) {
                        wsrmSecurityContext2.setSCCredential((SCCredential)object);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Sets the SC credential into WSRM security context, the SC credential identifier is: " + ((SCCredential)object).getIdentifier());
                        }
                    }
                    if (this.isWSTContextProperty(string)) {
                        wsrmSecurityContext2.setWSTContext((WSTContext)object);
                    }
                }

                public void removeProperty(String string) {
                    this.properties.remove(string);
                    if (this.isSCCredentialProperty(string)) {
                        wsrmSecurityContext2.setSCCredential(null);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Removes the SC credential from WSRM security context");
                        }
                    }
                    if (this.isWSTContextProperty(string)) {
                        wsrmSecurityContext2.setWSTContext(null);
                    }
                }

                public Iterator getPropertyNames() {
                    return this.properties.keySet().iterator();
                }

                public Object getProperty(String string) {
                    return this.properties.get(string);
                }

                public boolean containsProperty(String string) {
                    return this.properties.containsKey(string);
                }

                public boolean isSoap12() {
                    boolean bl2 = false;
                    WSTContext wSTContext = (WSTContext)this.properties.get("weblogic.wsee.security.wst.framework.WSTContext");
                    if (wSTContext != null) {
                        bl2 = ((SoapMessageContext)wSTContext.getMessageContext()).isSoap12();
                    }
                    return bl2;
                }
            };
        }
    }
}

