/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssc.utils;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.rpc.handler.MessageContext;
import weblogic.utils.StringUtils;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.security.configuration.WssConfiguration;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.ws.WsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSCCompatibilityUtil {
    public static final int WSSC13 = 1;
    public static final int MSFT = 2;
    public static final int WSSC14 = 3;
    public static final String WST_HEURISTIC_FLAG = "weblogic.wsee.security.wssp.handlers.wst_heuristic";
    private static final String RST_ACTION_V200502 = "/trust/RST/";
    private static final String RST_ACTION_V13 = "ws-trust/200512/RST/";
    private static final String SCT_CANCEL = "/SCT/Cancel";
    private static final String SCT_RENEW = "/SCT/Renew";

    public static int getWSSCVersion(MessageContext messageContext) {
        String string = (String)messageContext.getProperty("weblogic.wsee.policy.compat.preference");
        return WSSCCompatibilityUtil.getWSSCVersion(string);
    }

    public static int getWSSCVersion(String string) {
        if ("wssc1.3".equals(string)) {
            return 1;
        }
        if ("msft".equals(string)) {
            return 2;
        }
        if (string == null || "".equals(string) || "wssc1.4".equals(string)) {
            return 3;
        }
        return 3;
    }

    public static OrderingIterator<String> getCompatibilityOrdering(String string) {
        if (string == null || "".equals(string)) {
            string = "wssc1.4_wssc1.3_msft";
        }
        String[] stringArray = StringUtils.splitCompletely((String)string, (String)"_");
        OrderingIterator<String> orderingIterator = new OrderingIterator<String>(Arrays.asList(stringArray));
        return orderingIterator;
    }

    public static String getCompatibilityOrdering(OrderingIterator<String> orderingIterator) {
        return StringUtils.join((String[])orderingIterator.toArray(new String[orderingIterator.size()]), (String)"_");
    }

    public static OrderingIterator<String> resetCompatibilityOrdering(OrderingIterator<String> orderingIterator, String string) {
        orderingIterator.resetFirst(string);
        return orderingIterator;
    }

    public static boolean isHeuristicCompatibility() {
        return "true".equalsIgnoreCase(System.getProperty("weblogic.wsee.policy.compat.dynamic"));
    }

    public static boolean isHeuristicStrategyRequired(MessageContext messageContext) {
        WlMessageContext wlMessageContext;
        MsgHeaders msgHeaders;
        ActionHeader actionHeader;
        String string = (String)messageContext.getProperty("weblogic.wsee.addressing.Action");
        if (string == null && (actionHeader = (ActionHeader)(msgHeaders = (wlMessageContext = WlMessageContext.narrow(messageContext)).getHeaders()).getHeader(ActionHeader.TYPE)) != null) {
            string = actionHeader.getActionURI();
            messageContext.setProperty("weblogic.wsee.addressing.Action", (Object)string);
        }
        if (string != null && (string.indexOf(RST_ACTION_V200502) > -1 || string.indexOf(RST_ACTION_V13) > -1)) {
            return string.endsWith(SCT_CANCEL) || string.endsWith(SCT_RENEW);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjustOrderingPreference(MessageContext messageContext) {
        WssPolicyContext wssPolicyContext = WSSCCompatibilityUtil.getPolicyContext(messageContext);
        String string = wssPolicyContext.getWssConfiguration().getCompatibilityPreference(messageContext);
        WssConfiguration wssConfiguration = wssPolicyContext.getWssConfiguration();
        synchronized (wssConfiguration) {
            String string2 = wssPolicyContext.getWssConfiguration().getCompatibilityOrderingPreference();
            OrderingIterator<String> orderingIterator = WSSCCompatibilityUtil.getCompatibilityOrdering(string2);
            WSSCCompatibilityUtil.resetCompatibilityOrdering(orderingIterator, string);
            String string3 = WSSCCompatibilityUtil.getCompatibilityOrdering(orderingIterator);
            wssPolicyContext.getWssConfiguration().setCompatibilityOrderingPreference(string3);
        }
    }

    public static WssPolicyContext getPolicyContext(MessageContext messageContext) {
        WssPolicyContext wssPolicyContext = (WssPolicyContext)messageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
        if (wssPolicyContext == null) {
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            WsService wsService = wlMessageContext.getDispatcher().getWsPort().getEndpoint().getService();
            wssPolicyContext = wsService.getWssPolicyContext();
            messageContext.setProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx", (Object)wssPolicyContext);
        }
        return wssPolicyContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrderingIterator<E>
    implements Iterator<E> {
        private LinkedList<E> ordering = null;
        private Iterator<E> it = null;

        public OrderingIterator(List<E> list) {
            this.ordering = list instanceof LinkedList ? (LinkedList)list : new LinkedList<E>(list);
            this.it = this.ordering.iterator();
        }

        public Object[] toArray() {
            return this.ordering.toArray();
        }

        public <T> T[] toArray(T[] TArray) {
            return this.ordering.toArray(TArray);
        }

        public int size() {
            return this.ordering.size();
        }

        public void resetFirst(E e) {
            if (!this.ordering.getFirst().equals(e)) {
                this.ordering.removeFirstOccurrence(e);
                this.ordering.addFirst(e);
            }
            this.it = this.ordering.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public E next() {
            return this.it.next();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

