/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssp;

import java.util.LinkedList;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;

public final class SecurityPolicyAssertionInfoFactory {
    private static final LinkedList<String> supportedSecurityInfo = new LinkedList();

    public static boolean hasSecurityPolicy(NormalizedExpression normalizedExpression) {
        if (normalizedExpression.getPolicyAlternatives() == null) {
            return false;
        }
        for (PolicyAlternative policyAlternative : normalizedExpression.getPolicyAlternatives()) {
            SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(policyAlternative);
            if (securityPolicyAssertionInfo == null || !securityPolicyAssertionInfo.isMessageSecurityEnabled() && securityPolicyAssertionInfo.getTransportBindingInfo() == null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMessageSecurityPolicy(NormalizedExpression normalizedExpression) {
        if (normalizedExpression.getPolicyAlternatives() == null) {
            return false;
        }
        for (PolicyAlternative policyAlternative : normalizedExpression.getPolicyAlternatives()) {
            SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(policyAlternative);
            if (securityPolicyAssertionInfo == null || !securityPolicyAssertionInfo.isMessageSecurityEnabled()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTransportSecurityPolicy(NormalizedExpression normalizedExpression) {
        if (normalizedExpression.getPolicyAlternatives() == null) {
            return false;
        }
        for (PolicyAlternative policyAlternative : normalizedExpression.getPolicyAlternatives()) {
            SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(policyAlternative);
            if (securityPolicyAssertionInfo == null || securityPolicyAssertionInfo.getTransportBindingInfo() == null) continue;
            return true;
        }
        return false;
    }

    public static final boolean hasWsTrustPolicy(NormalizedExpression normalizedExpression) {
        if (normalizedExpression == null) {
            return false;
        }
        if (normalizedExpression.getPolicyAlternatives() == null) {
            return false;
        }
        for (PolicyAlternative policyAlternative : normalizedExpression.getPolicyAlternatives()) {
            SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(policyAlternative);
            if (securityPolicyAssertionInfo == null || securityPolicyAssertionInfo.getWsTrustOptions() == null || securityPolicyAssertionInfo.getWsTrustBootstrapPolicy() == null) continue;
            return true;
        }
        return false;
    }

    public static final SecurityPolicyAssertionInfo getSecurityPolicyAssertionInfo(PolicyAlternative policyAlternative) {
        for (String string : supportedSecurityInfo) {
            SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.newInstance(string);
            securityPolicyAssertionInfo.init(policyAlternative);
            if (securityPolicyAssertionInfo.getTransportBindingInfo() == null && !securityPolicyAssertionInfo.isMessageSecurityEnabled()) continue;
            return securityPolicyAssertionInfo;
        }
        return null;
    }

    private static final SecurityPolicyAssertionInfo newInstance(String string) {
        try {
            return (SecurityPolicyAssertionInfo)Class.forName(string).newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    static {
        supportedSecurityInfo.add("weblogic.wsee.security.policy12.internal.SecurityPolicyAssertionInfoImpl");
    }
}

