/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssp;

import java.util.ArrayList;
import java.util.List;
import weblogic.wsee.security.policy12.assertions.AbstractSupportingTokens;
import weblogic.wsee.security.policy12.assertions.Header;
import weblogic.wsee.security.policy12.assertions.QNameParts;
import weblogic.wsee.security.policy12.assertions.SecurityPolicy12Assertion;
import weblogic.wsee.security.policy12.assertions.SignedParts;
import weblogic.wsee.security.policy12.assertions.XPath;
import weblogic.wsee.security.policy12.assertions.XPathElements;
import weblogic.wsee.security.policy12.internal.QNameExprImpl;
import weblogic.wsee.security.wssp.QNameExpr;
import weblogic.wsee.security.wssp.TokenAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SupportingTokensAssertion {
    public boolean hasSupportingTokens();

    public List<TokenAssertion> getSupportingTokens();

    public SecurityInfo getSecurityInfoOfSupportingTokens();

    public boolean hasSignedSupportingTokens();

    public List<TokenAssertion> getSignedSupportingTokens();

    public SecurityInfo getSecurityInfoOfSignedSupportingTokens();

    public boolean hasSignedEncryptedSupportingTokens();

    public List<TokenAssertion> getSignedEncryptedSupportingTokens();

    public SecurityInfo getSecurityInfoOfSignedEncryptedSupportingTokens();

    public boolean hasEndorsingSupportingTokens();

    public List<TokenAssertion> getEndorsingSupportingTokens();

    public SecurityInfo getSecurityInfoOfEndorsingSupportingTokens();

    public boolean hasSignedEndorsingSupportingTokens();

    public List<TokenAssertion> getSignedEndorsingSupportingTokens();

    public SecurityInfo getSecurityInfoOfSignedEndorsingSupportingTokens();

    public boolean hasEncryptedSupportingTokens();

    public List<TokenAssertion> getEncryptedSupportingTokens();

    public SecurityInfo getSecurityInfoOfEncryptedSupportingTokens();

    public boolean isEncryptedBodyRequired();

    public boolean isEncryptedBodyOptional();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SecurityInfo {
        private boolean isSignedBodyRequired = false;
        private boolean isSignedBodyOptional = false;
        private boolean isEncryptedBodyRequired = false;
        private boolean isEncryptedBodyOptional = false;
        private String signedXPathVersion = null;
        private String encryptedXPathVersion = null;
        private List<QNameExpr> signedParts = new ArrayList<QNameExpr>();
        private List<XPath> signedElements = new ArrayList<XPath>();
        private List<QNameExpr> encryptedParts = new ArrayList<QNameExpr>();
        private List<XPath> encryptedElements = new ArrayList<XPath>();

        public boolean isSignedBodyRequired() {
            return this.isSignedBodyRequired;
        }

        public boolean isSignedBodyOptional() {
            return this.isSignedBodyOptional;
        }

        public boolean isEncryptedBodyRequired() {
            return this.isEncryptedBodyRequired;
        }

        public boolean isEncryptedBodyOptional() {
            return this.isEncryptedBodyOptional;
        }

        public String getSignedXPathVersion() {
            return this.signedXPathVersion;
        }

        public String getEncryptedXPathVersion() {
            return this.encryptedXPathVersion;
        }

        public List<QNameExpr> getSignedParts() {
            return this.signedParts;
        }

        public List<XPath> getSignedElements() {
            return this.signedElements;
        }

        public List<QNameExpr> getEncryptedParts() {
            return this.encryptedParts;
        }

        public List<XPath> getEncryptedElements() {
            return this.encryptedElements;
        }

        public void init(AbstractSupportingTokens abstractSupportingTokens) {
            Object object;
            SecurityPolicy12Assertion securityPolicy12Assertion;
            Object object2;
            if (abstractSupportingTokens == null) {
                return;
            }
            SignedParts signedParts = abstractSupportingTokens.getSignedParts();
            if (signedParts != null) {
                if (signedParts.getBody() != null) {
                    this.isSignedBodyRequired = true;
                    this.isSignedBodyOptional = signedParts.isBodyOptional() || signedParts.getBody().isOptional() || signedParts.isOptional();
                }
                object2 = signedParts.getHeaders().iterator();
                while (object2.hasNext()) {
                    securityPolicy12Assertion = (Header)object2.next();
                    this.signedParts.add(new QNameExprImpl(((Header)securityPolicy12Assertion).getHeaderName(), ((Header)securityPolicy12Assertion).getHeaderNamespaceUri(), securityPolicy12Assertion.isOptional() || signedParts.isOptional()));
                }
            }
            if ((object2 = abstractSupportingTokens.getSignedElements()) != null) {
                this.signedElements.addAll(((XPathElements)object2).getXPathExpressions());
                this.signedXPathVersion = ((XPathElements)object2).getXPathVersion();
            }
            if ((securityPolicy12Assertion = abstractSupportingTokens.getEncryptedParts()) != null) {
                if (((QNameParts)securityPolicy12Assertion).getBody() != null) {
                    this.isEncryptedBodyRequired = true;
                    this.isEncryptedBodyOptional = ((QNameParts)securityPolicy12Assertion).isBodyOptional() || ((QNameParts)securityPolicy12Assertion).getBody().isOptional() || securityPolicy12Assertion.isOptional();
                }
                object = ((QNameParts)securityPolicy12Assertion).getHeaders().iterator();
                while (object.hasNext()) {
                    Header header = (Header)object.next();
                    this.encryptedParts.add(new QNameExprImpl(header.getHeaderName(), header.getHeaderNamespaceUri(), header.isOptional() || securityPolicy12Assertion.isOptional()));
                }
            }
            if ((object = abstractSupportingTokens.getEncryptedElements()) != null) {
                this.encryptedElements.addAll(((XPathElements)object).getXPathExpressions());
                this.encryptedXPathVersion = ((XPathElements)object).getXPathVersion();
            }
        }
    }
}

