/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssp.deploy;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.policy.SecurityPolicyAssertionHelper;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertionFactory;
import weblogic.wsee.security.policy12.assertions.TransportBinding;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;

public abstract class WssDeploymentListener
implements WsDeploymentListener {
    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        WsService wsService = wsDeploymentContext.getWsService();
        PolicyServer policyServer = wsService.getPolicyServer();
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            HandlerList handlerList = wsPort.getInternalHandlerList();
            try {
                if (policyServer != null && wsDeploymentContext.getType() == WebServiceType.JAXWS && SecurityPolicyAssertionFactory.hasSecurityPolicy(wsPort, policyServer)) {
                    throw new WsDeploymentException("The WebLogic Server 9.x-style policy is not supported in JAX-WS web services.");
                }
                if (WssDeploymentListener.isWsspEnabled(wsPort, policyServer)) {
                    WssDeploymentListener.checkLogicalError(wsPort, policyServer);
                    this.insertHandlers(handlerList);
                    wsService.initWssConfiguration();
                    if (!WssDeploymentListener.isWSTEnabled(wsPort, policyServer)) continue;
                    this.insertWstHandlers(handlerList, wsPort, policyServer, wsDeploymentContext);
                    this.insertForwardingHandler(handlerList);
                    continue;
                }
                this.removeHandlers(handlerList);
            }
            catch (WssConfigurationException wssConfigurationException) {
                throw new WsDeploymentException(wssConfigurationException);
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException(handlerException);
            }
            catch (PolicyException policyException) {
                throw new WsDeploymentException(policyException);
            }
        }
    }

    private static boolean isWsspEnabled(WsPort wsPort, PolicyServer policyServer) throws PolicyException {
        if (policyServer != null) {
            Iterator iterator = wsPort.getEndpoint().getMethods();
            while (iterator.hasNext()) {
                WsMethod wsMethod = (WsMethod)iterator.next();
                if (SecurityPolicyAssertionInfoFactory.hasSecurityPolicy(PolicyContext.getRequestEffectivePolicy(wsPort, wsMethod, policyServer, policyServer.getCachedPolicies()))) {
                    return true;
                }
                if (!SecurityPolicyAssertionInfoFactory.hasSecurityPolicy(PolicyContext.getResponseEffectivePolicy(wsPort, wsMethod, policyServer, policyServer.getCachedPolicies()))) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkLogicalError(WsPort wsPort, PolicyServer policyServer) throws PolicyException {
        if (policyServer != null) {
            boolean bl = false;
            boolean bl2 = WssDeploymentListener.isHttpsEndpoint(wsPort, policyServer);
            Iterator iterator = wsPort.getEndpoint().getMethods();
            while (iterator.hasNext()) {
                NormalizedExpression normalizedExpression;
                WsMethod wsMethod = (WsMethod)iterator.next();
                if (!bl2) {
                    WssDeploymentListener.validateTransportBindingPolicy(wsPort, wsMethod.getOperationName(), policyServer);
                }
                if (SecurityPolicyAssertionFactory.hasSecurityPolicy(normalizedExpression = PolicyContext.getRequestEffectivePolicy(wsPort, wsMethod, policyServer, policyServer.getCachedPolicies()))) {
                    bl = true;
                    break;
                }
                if (SecurityPolicyAssertionInfoFactory.hasSecurityPolicy(normalizedExpression)) {
                    SecurityPolicyAssertionHelper.checkLogicalError(normalizedExpression);
                    continue;
                }
                SecurityPolicyAssertionHelper.checkLogicalError(PolicyContext.getResponseEffectivePolicy(wsPort, wsMethod, policyServer, policyServer.getCachedPolicies()));
            }
            if (bl) {
                throw new PolicyException("The WebLogic Server 9.x-style policy and Wssp policy is not allowed to mix and match.");
            }
        }
    }

    private static boolean isWSTEnabled(WsPort wsPort, PolicyServer policyServer) throws PolicyException {
        Iterator iterator = wsPort.getEndpoint().getMethods();
        while (iterator.hasNext()) {
            WsMethod wsMethod = (WsMethod)iterator.next();
            if (SecurityPolicyAssertionInfoFactory.hasWsTrustPolicy(PolicyContext.getRequestEffectivePolicy(wsPort, wsMethod, policyServer, policyServer.getCachedPolicies()))) {
                return true;
            }
            if (!SecurityPolicyAssertionInfoFactory.hasWsTrustPolicy(PolicyContext.getResponseEffectivePolicy(wsPort, wsMethod, policyServer, policyServer.getCachedPolicies()))) continue;
            return true;
        }
        return false;
    }

    private static boolean isHttpsEndpoint(WsPort wsPort, PolicyServer policyServer) throws PolicyException {
        Map map = policyServer.getCachedPolicies();
        NormalizedExpression normalizedExpression = WsdlPolicySubject.getEndpointPolicySubject(wsPort.getWsdlPort(), map);
        return normalizedExpression.containsPolicyAssertion(TransportBinding.class);
    }

    private static void validateTransportBindingPolicy(WsPort wsPort, QName qName, PolicyServer policyServer) throws PolicyException {
        WsdlPort wsdlPort = wsPort.getWsdlPort();
        WsdlOperation wsdlOperation = wsdlPort.getPortType().getOperations().get(qName);
        WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(qName);
        Map map = policyServer.getCachedPolicies();
        String string = "Bad usage of Https Policy (TransportBinding assertion): It need be applied at Endpoint (Class) level  or at least another Https policy defined at the Endpoint level!\n NOTE: for JAX-RPC, any Https policy defined at the Endpoint level can NOT have the \"direction\" attribute definition!";
        NormalizedExpression normalizedExpression = WsdlPolicySubject.getOperationPolicySubject(policyServer, wsdlOperation, wsdlBindingOperation, map);
        if (normalizedExpression.containsPolicyAssertion(TransportBinding.class)) {
            throw new PolicyException(string);
        }
        normalizedExpression = WsdlPolicySubject.getMessagePolicySubject(policyServer, wsdlOperation.getInput(), wsdlBindingOperation.getInput(), null, map);
        if (normalizedExpression.containsPolicyAssertion(TransportBinding.class)) {
            throw new PolicyException(string);
        }
        normalizedExpression = WsdlPolicySubject.getMessagePolicySubject(policyServer, wsdlOperation.getOutput(), wsdlBindingOperation.getOutput(), null, map);
        if (normalizedExpression.containsPolicyAssertion(TransportBinding.class)) {
            throw new PolicyException(string);
        }
    }

    private void insertHandlers(HandlerList handlerList) throws HandlerException {
        if (handlerList.contains("WS_SECURITY_1.1")) {
            return;
        }
        handlerList.lenientInsert("WS_SECURITY_1.1", this.getWssHandlerInfo(), this.getFollowingWssHandlers(), this.getPrecedingWssHandlers());
        handlerList.lenientInsert("PRE_WS_SECURITY_POLICY_1.2", this.getPreWssPolicyHandlerInfo(), this.getFollowingPreWssPolicyHandlers(), this.getPrecedingPreWssPolicyHandlers());
        handlerList.insert("POST_WS_SECURITY_POLICY_1.2", this.getPostWssPolicyHandlerInfo(), this.getFollowingPostWssPolicyHandlers(handlerList), this.getPrecedingPostWssPolicyHandlers());
        handlerList.lenientInsert("NORMAL_XOP_HANDLER", this.getXopHandlerInfo(), this.getFollowingXopHandlers(), this.getPrecedingXopHandlers());
    }

    private void removeHandlers(HandlerList handlerList) {
        handlerList.remove("WS_SECURITY_1.1");
        handlerList.remove("PRE_WS_SECURITY_POLICY_1.2");
        handlerList.remove("POST_WS_SECURITY_POLICY_1.2");
        handlerList.remove("NORMAL_XOP_HANDLER");
    }

    abstract HandlerInfo getWssHandlerInfo();

    abstract HandlerInfo getPreWssPolicyHandlerInfo();

    abstract HandlerInfo getPostWssPolicyHandlerInfo();

    abstract List getPrecedingWssHandlers();

    abstract List getFollowingWssHandlers();

    abstract List getPrecedingPreWssPolicyHandlers();

    abstract List getFollowingPreWssPolicyHandlers();

    abstract List getPrecedingPostWssPolicyHandlers();

    abstract List getFollowingPostWssPolicyHandlers(HandlerList var1);

    abstract void insertWstHandlers(HandlerList var1, WsPort var2, PolicyServer var3, WsDeploymentContext var4) throws HandlerException, PolicyException;

    abstract void insertForwardingHandler(HandlerList var1) throws HandlerException;

    abstract HandlerInfo getXopHandlerInfo();

    abstract List getPrecedingXopHandlers();

    abstract List getFollowingXopHandlers();
}

