/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssp.deploy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.cluster.ForwardingHandler;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.jaxws.tubeline.DelegateTubelineDeploymentListener;
import weblogic.wsee.mtom.internal.MtomXopServerHandler;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.security.wssc.utils.WSSCCompatibilityUtil;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.security.wssp.deploy.WssDeploymentListener;
import weblogic.wsee.security.wssp.handlers.PostWssServerPolicyHandler;
import weblogic.wsee.security.wssp.handlers.PreWssServerPolicyHandler;
import weblogic.wsee.security.wssp.handlers.STSMessageHandler;
import weblogic.wsee.security.wssp.handlers.STSPolicyHandler;
import weblogic.wsee.security.wssp.handlers.WSTHeuristicHandler;
import weblogic.wsee.security.wssp.handlers.WssServerHandler;
import weblogic.wsee.security.wssp.tube.WSTHeuristicServerTubelineDeploymentListener;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;

public class WssServerDeploymentListener
extends WssDeploymentListener {
    void insertWstHandlers(HandlerList handlerList, WsPort wsPort, PolicyServer policyServer, WsDeploymentContext wsDeploymentContext) throws HandlerException, PolicyException {
        if (handlerList.contains("WS_TRUST_POLICY_HANDLER")) {
            return;
        }
        int n = handlerList.lenientInsert("WS_TRUST_POLICY_HANDLER", this.getWstPolicyHandlerInfo(wsPort, policyServer), this.getPrecedingWstPolicyHandlers(), this.getFollowingWstPolicyHandlers());
        handlerList.insert("WS_TRUST_STS_HANDLER", this.getWstMessageHandlerInfo(), this.getPrecedingWstMessageHandlers(), this.getFollowingWstMessageHandlers());
        if (wsDeploymentContext.getType() == WebServiceType.JAXWS) {
            if (WSSCCompatibilityUtil.isHeuristicCompatibility()) {
                DelegateTubelineDeploymentListener.registerServerDeploymentListener(new WSTHeuristicServerTubelineDeploymentListener());
            }
        } else if (wsDeploymentContext.getType() == WebServiceType.JAXRPC) {
            HandlerInfo handlerInfo = new HandlerInfo(WSTHeuristicHandler.class, null, null);
            handlerList.insert("WS_TRUST_HEURISTIC_HANDLER", n, handlerInfo);
        }
    }

    void insertForwardingHandler(HandlerList handlerList) throws HandlerException {
        if (handlerList.contains("FORWARDING_HANDLER")) {
            return;
        }
        handlerList.lenientInsert("FORWARDING_HANDLER", this.getForwardingHandlerInfo(), this.getFollowingForwardingHandlers(), this.getPrecedingForwardingHandlers());
    }

    private HandlerInfo getForwardingHandlerInfo() {
        return new HandlerInfo(ForwardingHandler.class, new HashMap(), null);
    }

    HandlerInfo getWssHandlerInfo() {
        HashMap hashMap = new HashMap();
        return new HandlerInfo(WssServerHandler.class, hashMap, null);
    }

    HandlerInfo getPreWssPolicyHandlerInfo() {
        HashMap hashMap = new HashMap();
        return new HandlerInfo(PreWssServerPolicyHandler.class, hashMap, null);
    }

    HandlerInfo getPostWssPolicyHandlerInfo() {
        HashMap hashMap = new HashMap();
        return new HandlerInfo(PostWssServerPolicyHandler.class, hashMap, null);
    }

    List getPrecedingWssHandlers() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    List getFollowingWssHandlers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("CONNECTION_HANDLER");
        arrayList.add("FORWARDING_HANDLER");
        return arrayList;
    }

    List getPrecedingPostWssPolicyHandlers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("PRE_INVOKE_HANDLER");
        return arrayList;
    }

    List getFollowingPostWssPolicyHandlers(HandlerList handlerList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("OPERATION_LOOKUP_HANDLER");
        return arrayList;
    }

    ArrayList getPrecedingPreWssPolicyHandlers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("WS_SECURITY_1.1");
        arrayList.add("SECURITY_HANDLER");
        return arrayList;
    }

    ArrayList getFollowingPreWssPolicyHandlers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("CONNECTION_HANDLER");
        arrayList.add("FORWARDING_HANDLER");
        return arrayList;
    }

    List getFollowingForwardingHandlers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("CONNECTION_HANDLER");
        return arrayList;
    }

    ArrayList getPrecedingForwardingHandlers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("WS_SECURITY_1.1");
        arrayList.add("SECURITY_HANDLER");
        return arrayList;
    }

    private HandlerInfo getWstMessageHandlerInfo() {
        return new HandlerInfo(STSMessageHandler.class, new HashMap(), null);
    }

    private List getPrecedingWstMessageHandlers() {
        return Arrays.asList((Object[])new String[]{"ADDRESSING_HANDLER", "WS_SECURITY_1.1"});
    }

    private List getFollowingWstMessageHandlers() {
        return Arrays.asList((Object[])new String[]{"OPERATION_LOOKUP_HANDLER"});
    }

    private HandlerInfo getWstPolicyHandlerInfo(WsPort wsPort, PolicyServer policyServer) throws PolicyException {
        NormalizedExpression normalizedExpression = null;
        NormalizedExpression normalizedExpression2 = null;
        NormalizedExpression normalizedExpression3 = PolicyContext.getRequestEffectivePolicy(wsPort, null, policyServer, policyServer.getCachedPolicies());
        Set set = normalizedExpression3.getPolicyAlternatives();
        if (set != null) {
            for (PolicyAlternative policyAlternative : set) {
                SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(policyAlternative);
                if (securityPolicyAssertionInfo == null || (normalizedExpression = securityPolicyAssertionInfo.getWsTrustBootstrapPolicy()) == null) continue;
                normalizedExpression2 = normalizedExpression3;
                break;
            }
        }
        if (normalizedExpression == null) {
            throw new PolicyException("Can not determine boot strap policy for WS-Trust. Either there is no boot strap policy or it is attached at method/operation level. The boot strap policy must be attached at service/port level, it can't be determined if it is attached at method/operation level.");
        }
        HashMap hashMap = new HashMap();
        hashMap.put("BootstrapPolicy", normalizedExpression);
        hashMap.put("ServicePolicy", normalizedExpression2);
        return new HandlerInfo(STSPolicyHandler.class, (Map)hashMap, null);
    }

    private List getPrecedingWstPolicyHandlers() {
        return Arrays.asList((Object[])new String[]{"CONNECTION_HANDLER", "FORWARDING_HANDLER"});
    }

    private List getFollowingWstPolicyHandlers() {
        return Arrays.asList((Object[])new String[]{"WS_SECURITY_1.1"});
    }

    List getFollowingXopHandlers() {
        return this.getFollowingPreWssPolicyHandlers();
    }

    List getPrecedingXopHandlers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("PRE_WS_SECURITY_POLICY_1.2");
        return arrayList;
    }

    HandlerInfo getXopHandlerInfo() {
        return new HandlerInfo(MtomXopServerHandler.class, new HashMap(), null);
    }
}

