/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssp.handlers;

import java.util.List;
import java.util.Set;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.monitoring.WsspStats;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wss.plan.SecurityPolicyPlan;
import weblogic.wsee.security.wssp.ConfidentialityAssertion;
import weblogic.wsee.security.wssp.IntegrityAssertion;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.security.wssp.handlers.WssHandler;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss11.internal.WSS11Context;

public class PostWssServerPolicyHandler
extends WssHandler {
    protected boolean processRequest(SOAPMessageContext sOAPMessageContext) throws PolicyException, SOAPException, WSSecurityException {
        try {
            NormalizedExpression normalizedExpression;
            WlMessageContext wlMessageContext = (WlMessageContext)sOAPMessageContext;
            if (wlMessageContext != null && wlMessageContext.getDispatcher() != null && wlMessageContext.getDispatcher().getOperation() != null) {
                wlMessageContext.setProperty("WL_OP_NAME", wlMessageContext.getDispatcher().getOperationName().getLocalPart());
            }
            if ((normalizedExpression = PolicyContext.getRequestEffectivePolicy((MessageContext)sOAPMessageContext)) == null || null == normalizedExpression.getPolicyAlternatives()) {
                return true;
            }
            this.postValidate(normalizedExpression, sOAPMessageContext, true);
            WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext((MessageContext)sOAPMessageContext);
            AuthenticatedSubject authenticatedSubject = wSSecurityContext.getSubject();
            if (authenticatedSubject != null) {
                this.setSubject(authenticatedSubject, sOAPMessageContext);
            }
            this.setupMTOMProperty(sOAPMessageContext);
        }
        catch (MarshalException marshalException) {
            throw new WSSecurityException(marshalException);
        }
        catch (SecurityPolicyException securityPolicyException) {
            throw new WSSecurityException(securityPolicyException);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException);
        }
        this.reportInboundWSSSuccessToWsspStats(this.getWsspStats(sOAPMessageContext), sOAPMessageContext);
        return true;
    }

    protected boolean processResponse(SOAPMessageContext sOAPMessageContext) throws PolicyException, SOAPException, WSSecurityException {
        return true;
    }

    private void setSubject(AuthenticatedSubject authenticatedSubject, SOAPMessageContext sOAPMessageContext) {
        sOAPMessageContext.setProperty("weblogic.wsee.wss.subject", (Object)authenticatedSubject);
    }

    private void setupMTOMProperty(SOAPMessageContext sOAPMessageContext) throws PolicyException {
        NormalizedExpression normalizedExpression = PolicyContext.getRequestEffectivePolicy((MessageContext)sOAPMessageContext);
        if (normalizedExpression != null && null != normalizedExpression.getPolicyAlternatives()) {
            Set set = normalizedExpression.getPolicyAlternatives();
            if (set == null) {
                return;
            }
            for (PolicyAlternative policyAlternative : set) {
                SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(policyAlternative);
                if (securityPolicyAssertionInfo == null) continue;
                List<IntegrityAssertion> list = securityPolicyAssertionInfo.getIntegrityAssertions();
                List<ConfidentialityAssertion> list2 = securityPolicyAssertionInfo.getConfidentialityAssertions();
                if (list != null) {
                    sOAPMessageContext.setProperty("weblogic.wsee.xop.normal", (Object)"sign");
                }
                if (list2 == null || list2.size() <= 0) continue;
                sOAPMessageContext.setProperty("weblogic.wsee.xop.normal", (Object)"encrypt");
                break;
            }
        }
    }

    protected void reportInboundWSSSuccessToWsspStats(WsspStats wsspStats, SOAPMessageContext sOAPMessageContext) {
        super.reportInboundWSSSuccessToWsspStats(this.getWsspStats(sOAPMessageContext), sOAPMessageContext);
        assert (wsspStats != null);
        WSS11Context wSS11Context = (WSS11Context)sOAPMessageContext.getProperty("weblogic.xml.crypto.wss.WSSecurityContext");
        assert (wSS11Context != null);
        SecurityPolicyPlan securityPolicyPlan = (SecurityPolicyPlan)wSS11Context.getPolicyOutline();
        if (securityPolicyPlan != null && securityPolicyPlan.getBuildingPlan() > 0 && (securityPolicyPlan.getIdentityPolicy() != null && securityPolicyPlan.getIdentityPolicy().isAuthenticationRequired() || wSS11Context.getIdTokens().size() > 0)) {
            wsspStats.reportAuthenticationSuccess();
        }
    }
}

