/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssp.handlers;

import java.util.List;
import java.util.Set;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wssp.IntegrityAssertion;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.security.wssp.handlers.WssHandler;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.wss.WSSecurityException;

public class PreWssClientPolicyHandler
extends WssHandler {
    protected boolean processRequest(SOAPMessageContext sOAPMessageContext) throws PolicyException, SOAPException, WSSecurityException {
        NormalizedExpression normalizedExpression = PolicyContext.getRequestEffectivePolicy((MessageContext)sOAPMessageContext);
        if (normalizedExpression != null && null != normalizedExpression.getPolicyAlternatives()) {
            Set set = normalizedExpression.getPolicyAlternatives();
            if (set == null) {
                return true;
            }
            for (PolicyAlternative policyAlternative : set) {
                Object object;
                SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(policyAlternative);
                if (securityPolicyAssertionInfo == null) continue;
                List<IntegrityAssertion> list = securityPolicyAssertionInfo.getIntegrityAssertions();
                if (list != null) {
                    object = list.iterator();
                    while (object.hasNext()) {
                        IntegrityAssertion integrityAssertion = (IntegrityAssertion)object.next();
                        if (integrityAssertion != null && integrityAssertion.isSignedWsaHeadersRequired()) {
                            sOAPMessageContext.setProperty("weblogic.wsee.complex", (Object)"true");
                        }
                        if (integrityAssertion == null || "encrypt".equals(sOAPMessageContext.getProperty("weblogic.wsee.xop.normal"))) continue;
                        sOAPMessageContext.setProperty("weblogic.wsee.xop.normal", (Object)"sign");
                    }
                }
                if ((object = securityPolicyAssertionInfo.getConfidentialityAssertions()) == null || object.size() <= 0) continue;
                sOAPMessageContext.setProperty("weblogic.wsee.xop.normal", (Object)"encrypt");
            }
        }
        return true;
    }

    protected boolean processResponse(SOAPMessageContext sOAPMessageContext) throws PolicyException, SOAPException, WSSecurityException {
        try {
            NormalizedExpression normalizedExpression = PolicyContext.getResponseEffectivePolicy((MessageContext)sOAPMessageContext);
            if (normalizedExpression != null && normalizedExpression.getPolicyAlternatives() != null) {
                this.postValidate(normalizedExpression, sOAPMessageContext, false);
            }
        }
        catch (MarshalException marshalException) {
            throw new WSSecurityException(marshalException);
        }
        catch (SecurityPolicyException securityPolicyException) {
            throw new WSSecurityException(securityPolicyException);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException);
        }
        return true;
    }
}

