/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssp.handlers;

import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.wssc.utils.WSSCCompatibilityUtil;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.security.wst.internal.WSTServerHandler;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsService;

public class STSPolicyHandler
extends WSTServerHandler {
    private static final boolean verbose = Verbose.isVerbose(STSPolicyHandler.class);
    public static final String BOOT_STRAP_POLICY = "BootstrapPolicy";
    public static final String SERVICE_POLICY = "ServicePolicy";
    private static final String SCT_CANCEL = "/SCT/Cancel";
    private static final String SCT_RENEW = "/SCT/Renew";
    private NormalizedExpression bootstrapPolicy;
    private NormalizedExpression servicePolicy;
    private boolean isTransportSecurityRequired;

    public void init(HandlerInfo handlerInfo) {
        this.bootstrapPolicy = (NormalizedExpression)handlerInfo.getHandlerConfig().get(BOOT_STRAP_POLICY);
        this.isTransportSecurityRequired = SecurityPolicyAssertionInfoFactory.hasTransportSecurityPolicy(this.bootstrapPolicy);
        this.servicePolicy = (NormalizedExpression)handlerInfo.getHandlerConfig().get(SERVICE_POLICY);
    }

    public boolean handleTrustRequest(SOAPMessageContext sOAPMessageContext, String string) {
        WssPolicyContext wssPolicyContext;
        String string2;
        if (WSSCCompatibilityUtil.isHeuristicCompatibility() && WSSCCompatibilityUtil.isHeuristicStrategyRequired((MessageContext)sOAPMessageContext) && !sOAPMessageContext.containsProperty("weblogic.wsee.security.wssp.handlers.wst_heuristic")) {
            sOAPMessageContext.setProperty("weblogic.wsee.security.wssp.handlers.wst_heuristic", (Object)"flag");
        }
        if ((string2 = (wssPolicyContext = this.getPolicyContext(sOAPMessageContext)).getWssConfiguration().getCompatibilityPreference((MessageContext)sOAPMessageContext)) == null || "".equals(string2)) {
            sOAPMessageContext.removeProperty("weblogic.wsee.policy.compat.preference");
        } else {
            sOAPMessageContext.setProperty("weblogic.wsee.policy.compat.preference", (Object)string2);
        }
        boolean bl = false;
        switch (WSSCCompatibilityUtil.getWSSCVersion(string2)) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = string.endsWith(SCT_CANCEL) || string.endsWith(SCT_RENEW);
                break;
            }
            default: {
                bl = string.endsWith(SCT_CANCEL);
            }
        }
        if (bl) {
            sOAPMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", (Object)this.servicePolicy);
            sOAPMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", (Object)this.servicePolicy);
        } else {
            sOAPMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", (Object)this.bootstrapPolicy);
            sOAPMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", (Object)this.bootstrapPolicy);
        }
        return true;
    }

    private static boolean isTransportSecure(SOAPMessageContext sOAPMessageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow((MessageContext)sOAPMessageContext);
        Object object = wlMessageContext.getProperty("weblogic.wsee.transport.servlet.request.secure");
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    private WssPolicyContext getPolicyContext(SOAPMessageContext sOAPMessageContext) {
        WssPolicyContext wssPolicyContext = (WssPolicyContext)sOAPMessageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
        if (wssPolicyContext == null) {
            WlMessageContext wlMessageContext = WlMessageContext.narrow((MessageContext)sOAPMessageContext);
            WsService wsService = wlMessageContext.getDispatcher().getWsPort().getEndpoint().getService();
            wssPolicyContext = wsService.getWssPolicyContext();
            sOAPMessageContext.setProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx", (Object)wssPolicyContext);
        }
        return wssPolicyContext;
    }
}

