/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssp.handlers;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.ws.WebServiceException;
import weblogic.wsee.handler.HandlerIterator;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.security.wssp.handlers.WSTHeuristicProcessor;
import weblogic.wsee.ws.WsException;
import weblogic.wsee.ws.dispatch.server.ServerDispatcher;

public class WSTHeuristicHandler
extends GenericHandler
implements WLHandler {
    private WSTHeuristicProcessor processor;

    public QName[] getHeaders() {
        return new QName[0];
    }

    public boolean handleClosure(MessageContext messageContext) {
        return true;
    }

    public boolean handleRequest(MessageContext messageContext) {
        if (this.processor == null) {
            this.processor = new WSTHeuristicProcessor();
        }
        this.processor.setReserve(new Reserve((SoapMessageContext)messageContext));
        this.processor.processRequest(messageContext);
        return super.handleRequest(messageContext);
    }

    public boolean handleResponse(MessageContext messageContext) {
        if (this.processor == null) {
            return true;
        }
        if (this.processor.processResponse(messageContext)) {
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            try {
                ServerDispatcher serverDispatcher = (ServerDispatcher)wlMessageContext.getDispatcher();
                HandlerIterator handlerIterator = serverDispatcher.getHandlerChain();
                serverDispatcher.setContext(this.processor.getReserve().getSoapMessageContext());
                serverDispatcher.dispatch();
                handlerIterator.setIndex(0);
                return false;
            }
            catch (WsException wsException) {
                throw new WebServiceException("Failed to dispatch for heuristic approach", (Throwable)wsException);
            }
        }
        return super.handleResponse(messageContext);
    }

    public boolean handleFault(MessageContext messageContext) {
        if (this.processor.processResponse(messageContext)) {
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            try {
                ServerDispatcher serverDispatcher = (ServerDispatcher)wlMessageContext.getDispatcher();
                HandlerIterator handlerIterator = serverDispatcher.getHandlerChain();
                serverDispatcher.setContext(this.processor.getReserve().getSoapMessageContext());
                serverDispatcher.dispatch();
                handlerIterator.setIndex(0);
                return false;
            }
            catch (WsException wsException) {
                throw new WebServiceException("Failed to dispatch for heuristic approach", (Throwable)wsException);
            }
        }
        return super.handleFault(messageContext);
    }

    private class Reserve
    extends WSTHeuristicProcessor.Reserve {
        private SoapMessageContext originalContext;

        public Reserve(SoapMessageContext soapMessageContext) {
            this.originalContext = soapMessageContext;
        }

        public SoapMessageContext getSoapMessageContext() {
            return this.originalContext;
        }
    }
}

