/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssp.handlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.wssc.utils.WSSCCompatibilityUtil;

public class WSTHeuristicProcessor {
    private WSSCCompatibilityUtil.OrderingIterator<String> ordering;
    private boolean requireHeuristicStrategy = false;
    private Reserve reserve;

    public Reserve getReserve() {
        return this.reserve;
    }

    public void setReserve(Reserve reserve) {
        this.reserve = reserve;
    }

    public boolean processRequest(MessageContext messageContext) {
        this.requireHeuristicStrategy = WSSCCompatibilityUtil.isHeuristicStrategyRequired(messageContext);
        if (!this.requireHeuristicStrategy) {
            return false;
        }
        try {
            this.reserve.reserveContext();
        }
        catch (SOAPException sOAPException) {
            this.reserve.destroy();
            throw new JAXRPCException("Failed to reserve context, can't process heuristic retrying", (Throwable)sOAPException);
        }
        catch (IOException iOException) {
            this.reserve.destroy();
            throw new JAXRPCException("Failed to reserve context, can't process heuristic retrying", (Throwable)iOException);
        }
        WssPolicyContext wssPolicyContext = WSSCCompatibilityUtil.getPolicyContext(messageContext);
        String string = wssPolicyContext.getWssConfiguration().getCompatibilityOrderingPreference();
        this.ordering = WSSCCompatibilityUtil.getCompatibilityOrdering(string);
        if (this.ordering.hasNext()) {
            String string2 = this.ordering.next();
            wssPolicyContext.getWssConfiguration().setCompatibilityPreference(string2, messageContext);
        }
        return true;
    }

    public boolean processResponse(MessageContext messageContext) {
        if (!this.requireHeuristicStrategy) {
            return false;
        }
        if (this.isHeuristicRequired(messageContext)) {
            if (this.hasNextHeuristic(messageContext)) {
                try {
                    this.reserve.resetContext();
                    this.nextHeuristic(this.reserve.getSoapMessageContext());
                    return true;
                }
                catch (IOException iOException) {
                }
                catch (SOAPException sOAPException) {}
            }
        } else {
            WSSCCompatibilityUtil.adjustOrderingPreference(messageContext);
        }
        this.reserve.destroy();
        this.reserve = null;
        this.ordering = null;
        this.requireHeuristicStrategy = false;
        return false;
    }

    private boolean isHeuristicRequired(MessageContext messageContext) {
        Object object = messageContext.getProperty("weblogic.wsee.security.wssp.handlers.wst_heuristic");
        return object != null;
    }

    private boolean hasNextHeuristic(MessageContext messageContext) {
        return this.ordering.hasNext();
    }

    private boolean nextHeuristic(MessageContext messageContext) {
        if (this.ordering.hasNext()) {
            String string = this.ordering.next();
            WssPolicyContext wssPolicyContext = WSSCCompatibilityUtil.getPolicyContext(messageContext);
            wssPolicyContext.getWssConfiguration().setCompatibilityPreference(string, messageContext);
            return true;
        }
        return false;
    }

    public static abstract class Reserve {
        protected Map<String, Object> properties;
        private ByteArrayOutputStream messageStream;
        private MimeHeaders mimeHeaders;
        private int handlerIndex = -1;

        public abstract SoapMessageContext getSoapMessageContext();

        public void reserveContext() throws SOAPException, IOException {
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>();
            } else {
                this.properties.clear();
            }
            SoapMessageContext soapMessageContext = this.getSoapMessageContext();
            Iterator iterator = soapMessageContext.getPropertyNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object = soapMessageContext.getProperty(string);
                this.properties.put(string, object);
            }
            this.mimeHeaders = soapMessageContext.getMessage().getMimeHeaders();
            this.messageStream = new ByteArrayOutputStream();
            soapMessageContext.getMessage().writeTo((OutputStream)this.messageStream);
            if (soapMessageContext.containsProperty("weblogic.wsee.handler.index")) {
                this.handlerIndex = (Integer)soapMessageContext.getProperty("weblogic.wsee.handler.index");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetContext() throws IOException, SOAPException {
            SoapMessageContext soapMessageContext = this.getSoapMessageContext();
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object = soapMessageContext.getPropertyNames();
            while (object.hasNext()) {
                String object2 = (String)object.next();
                arrayList.add(object2);
            }
            arrayList.removeAll(this.properties.keySet());
            for (String string : arrayList) {
                soapMessageContext.removeProperty(string);
            }
            for (Map.Entry entry : this.properties.entrySet()) {
                Object object2 = soapMessageContext.getProperty((String)entry.getKey());
                if (entry.getValue() == object2) continue;
                try {
                    soapMessageContext.setProperty((String)entry.getKey(), entry.getValue());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
            soapMessageContext.setFault(null);
            object = new ByteArrayInputStream(this.messageStream.toByteArray());
            try {
                soapMessageContext.setMessage(this.getSoapMessageContext().getMessageFactory().createMessage(this.mimeHeaders, (InputStream)object));
            }
            finally {
                ((InputStream)object).close();
            }
            if (this.handlerIndex > -1) {
                soapMessageContext.setProperty("weblogic.wsee.handler.index", this.handlerIndex);
            }
        }

        public void destroy() {
            try {
                this.messageStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

