/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssp.handlers;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import weblogic.kernel.KernelStatus;
import weblogic.security.SSL.TrustManager;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.security.bst.StubPropertyBSTCredProv;
import weblogic.wsee.security.saml.PKISAMLCredentialProvider;
import weblogic.wsee.security.saml.SAML2CredentialProvider;
import weblogic.wsee.security.saml.SAMLTrustCredentialProvider;
import weblogic.wsee.security.serviceref.ServiceRefBSTCredProv;
import weblogic.wsee.security.serviceref.ServiceRefTrustManager;
import weblogic.wsee.security.serviceref.ServiceRefUNTCredProv;
import weblogic.wsee.security.wss.SecurityPolicyArchitect;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wssc.WSSCCredentialProviderFactory;
import weblogic.wsee.security.wssc.base.sct.SCCredentialProactiveRequestor;
import weblogic.wsee.security.wssp.IssuedTokenAssertion;
import weblogic.wsee.security.wssp.SecureConversationTokenAssertion;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.security.wssp.SymmetricBindingInfo;
import weblogic.wsee.security.wssp.TokenAssertion;
import weblogic.wsee.security.wssp.X509TokenAssertion;
import weblogic.wsee.security.wssp.handlers.WssHandler;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss11.EncryptedKeyCredentialProviderFactory;
import weblogic.xml.crypto.wss11.internal.WSS11Context;
import weblogic.xml.crypto.wss11.internal.WSS11Factory;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeyToken;
import weblogic.xml.dom.marshal.MarshalException;

public class WssClientHandler
extends WssHandler {
    private static final boolean verbose = Verbose.isVerbose(WssClientHandler.class);
    private SCCredentialProactiveRequestor sccProactiveRequestor;
    private boolean autoReset = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processRequest(SOAPMessageContext sOAPMessageContext) throws PolicyException, SOAPException, WSSecurityException {
        NormalizedExpression normalizedExpression;
        block5: {
            try {
                normalizedExpression = PolicyContext.getRequestEffectivePolicy((MessageContext)sOAPMessageContext);
                if (normalizedExpression != null && null != normalizedExpression.getPolicyAlternatives()) break block5;
                boolean bl = true;
                Object var10_5 = null;
                this.populateSCCProactiveRequestor(sOAPMessageContext);
                return bl;
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                this.populateSCCProactiveRequestor(sOAPMessageContext);
                throw throwable;
            }
        }
        SecurityPolicyArchitect securityPolicyArchitect = this.getSecurityPolicyDriver(sOAPMessageContext);
        WssClientHandler.processOutbound(normalizedExpression, securityPolicyArchitect, sOAPMessageContext);
        WSS11Context wSS11Context = (WSS11Context)WSSecurityContext.getSecurityContext((MessageContext)sOAPMessageContext);
        String[] stringArray = wSS11Context.getSignatureValues();
        int n = wSS11Context.getRequestPolicyIdx();
        EncryptedKeyToken encryptedKeyToken = this.getEncryptedKeyToken(wSS11Context);
        if (this.autoReset) {
            WSSecurityContext.getSecurityContext((MessageContext)sOAPMessageContext).reset();
        }
        wSS11Context.setRequestPolicyIdx(n);
        wSS11Context.addPreviousMessageSignatureValues(stringArray);
        if (encryptedKeyToken != null) {
            wSS11Context.addKeyProvider(encryptedKeyToken.getKeyProvider());
            wSS11Context.addSecurityToken(encryptedKeyToken);
        }
        this.reportOutboundWSSSuccessToWsspStats(this.getWsspStats(sOAPMessageContext), sOAPMessageContext);
        boolean bl = true;
        Object var10_6 = null;
        this.populateSCCProactiveRequestor(sOAPMessageContext);
        return bl;
    }

    private EncryptedKeyToken getEncryptedKeyToken(WSS11Context wSS11Context) throws WSSecurityException {
        EncryptedKeyToken encryptedKeyToken = null;
        List list = wSS11Context.getSecurityTokens("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        if (list.size() > 0) {
            encryptedKeyToken = (EncryptedKeyToken)list.get(0);
        }
        return encryptedKeyToken;
    }

    protected static void processOutbound(NormalizedExpression normalizedExpression, SecurityPolicyArchitect securityPolicyArchitect, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException {
        if (normalizedExpression == null) {
            return;
        }
        try {
            securityPolicyArchitect.processRequestOutbound(normalizedExpression, sOAPMessageContext);
        }
        catch (weblogic.xml.crypto.api.MarshalException marshalException) {
            throw new WSSecurityException(marshalException);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException);
        }
        catch (SecurityPolicyException securityPolicyException) {
            securityPolicyException.printStackTrace();
            throw new WSSecurityException(securityPolicyException);
        }
    }

    protected boolean processResponse(SOAPMessageContext sOAPMessageContext) throws PolicyException, SOAPException, WSSecurityException, SecurityPolicyException {
        this.copyEndpointAddress(sOAPMessageContext);
        NormalizedExpression normalizedExpression = PolicyContext.getResponseEffectivePolicy((MessageContext)sOAPMessageContext);
        this.processInbound(normalizedExpression, sOAPMessageContext);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInbound(NormalizedExpression normalizedExpression, SOAPMessageContext sOAPMessageContext) throws WSSecurityException, SOAPException, SecurityPolicyException, PolicyException {
        block5: {
            try {
                if (!WssClientHandler.hasSecurityHeader(sOAPMessageContext)) break block5;
                this.setupSecurityContext(sOAPMessageContext);
                try {
                    sOAPMessageContext.setProperty("weblogic.wsee.security.wssc.needCheckSCTExpiration", (Object)"true");
                    if (sOAPMessageContext.getProperty("weblogic.wsee.security.wssc.checkingSCTExpiration") == null) {
                        sOAPMessageContext.setProperty("weblogic.wsee.security.wssc.checkingSCTExpiration", (Object)"tolerantCheckingSCTExpiration");
                    }
                    WSS11Factory.getInstance();
                    WSS11Factory.unmarshalAndProcessSecurity(sOAPMessageContext);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    sOAPMessageContext.setProperty("weblogic.wsee.security.wssc.needCheckSCTExpiration", (Object)"false");
                    throw throwable;
                }
                sOAPMessageContext.setProperty("weblogic.wsee.security.wssc.needCheckSCTExpiration", (Object)"false");
                {
                }
            }
            catch (MarshalException marshalException) {
                throw new WSSecurityException(marshalException, WSSConstants.FAILURE_INVALID);
            }
        }
    }

    protected void fillCredentialProviders(SOAPMessageContext sOAPMessageContext, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        List list;
        CredentialProvider credentialProvider;
        boolean bl = KernelStatus.isServer();
        TrustManager trustManager = (TrustManager)sOAPMessageContext.getProperty("weblogic.wsee.security.wss.TrustManager");
        if (trustManager != null) {
            wSSecurityContext.setProperty("weblogic.wsee.security.wss.TrustManager", trustManager);
        } else if (bl) {
            wSSecurityContext.setProperty("weblogic.wsee.security.wss.TrustManager", ServiceRefTrustManager.getInstance());
        }
        List list2 = (List)sOAPMessageContext.getProperty("weblogic.wsee.security.wss.CredentialProviderList");
        if (list2 != null) {
            wSSecurityContext.setCredentialProviders(list2);
        }
        if ((credentialProvider = this.getStubPropCredProv(sOAPMessageContext)) != null) {
            wSSecurityContext.addCredentialProvider(credentialProvider);
        }
        if (bl && (list = this.getServiceRefClientCredProvs()) != null) {
            wSSecurityContext.addCredentialProviders(list);
        }
        WssClientHandler.addWSSCCredProviders(wSSecurityContext, sOAPMessageContext);
    }

    private static void addWSSCCredProviders(WSSecurityContext wSSecurityContext, SOAPMessageContext sOAPMessageContext) throws WSSecurityException {
        if (verbose) {
            Verbose.log("Adding WSS cred providers");
        }
        try {
            NormalizedExpression normalizedExpression = PolicyContext.getRequestEffectivePolicy((MessageContext)sOAPMessageContext);
            Set set = normalizedExpression.getPolicyAlternatives();
            if (set == null) {
                return;
            }
            for (PolicyAlternative policyAlternative : set) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(policyAlternative);
                if (securityPolicyAssertionInfo == null) {
                    return;
                }
                SecureConversationTokenAssertion secureConversationTokenAssertion = null;
                X509TokenAssertion x509TokenAssertion = null;
                IssuedTokenAssertion issuedTokenAssertion = null;
                SymmetricBindingInfo symmetricBindingInfo = securityPolicyAssertionInfo.getSymmetricBindingInfo();
                if (symmetricBindingInfo != null) {
                    object4 = symmetricBindingInfo.getProtectionTokenAssertion();
                    if (object4 == null) {
                        return;
                    }
                    secureConversationTokenAssertion = object4.getSecureConversationTokenAssertion();
                    x509TokenAssertion = object4.getX509TokenAssertion();
                } else {
                    object4 = securityPolicyAssertionInfo.getSupportingTokensAssertion();
                    if (object4 == null) {
                        return;
                    }
                    object3 = new ArrayList<TokenAssertion>();
                    object3.addAll(object4.getSupportingTokens());
                    object3.addAll(object4.getSignedSupportingTokens());
                    object3.addAll(object4.getEncryptedSupportingTokens());
                    object3.addAll(object4.getSignedEncryptedSupportingTokens());
                    object3.addAll(object4.getEndorsingSupportingTokens());
                    object3.addAll(object4.getSignedEndorsingSupportingTokens());
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (TokenAssertion)object2.next();
                        if (object instanceof SecureConversationTokenAssertion) {
                            secureConversationTokenAssertion = (SecureConversationTokenAssertion)object;
                            continue;
                        }
                        if (object instanceof X509TokenAssertion) {
                            x509TokenAssertion = (X509TokenAssertion)object;
                            continue;
                        }
                        if (!(object instanceof IssuedTokenAssertion)) continue;
                        issuedTokenAssertion = (IssuedTokenAssertion)object;
                    }
                }
                object4 = null;
                if (secureConversationTokenAssertion != null) {
                    object4 = secureConversationTokenAssertion.getTokenType();
                } else {
                    if (verbose) {
                        Verbose.log("X509TokenAssertion is: " + x509TokenAssertion);
                    }
                    object3 = null;
                    if (x509TokenAssertion != null) {
                        boolean bl = false;
                        if (null != securityPolicyAssertionInfo.getWsTrustOptions()) {
                            bl = securityPolicyAssertionInfo.getWsTrustOptions().isWst13();
                        }
                        object4 = x509TokenAssertion.getDerivedKeyTokenType(bl);
                        object3 = EncryptedKeyCredentialProviderFactory.getEncryptedKeyCredentialProvider();
                    }
                    if (issuedTokenAssertion != null) {
                        if (verbose) {
                            Verbose.log("IssuedTokenAssertion is: " + issuedTokenAssertion);
                        }
                        object2 = issuedTokenAssertion.getDkTokenType();
                        if (verbose) {
                            Verbose.log("tokenType is: " + (String)object2);
                        }
                        if (null == object4 || ((String[])object4).length == 0) {
                            object4 = new String[]{object2};
                        } else {
                            object = new HashSet<String>(Arrays.asList(object4));
                            object.add((String)object2);
                            object4 = (String[])object.toArray();
                        }
                        object3 = EncryptedKeyCredentialProviderFactory.getEncryptedKeyCredentialProvider();
                    }
                    if (verbose) {
                        Verbose.log("CP for EK is: " + object3);
                    }
                    if (object3 != null) {
                        wSSecurityContext.addCredentialProvider((CredentialProvider)object3);
                    }
                }
                if (object4 == null) {
                    return;
                }
                if (verbose) {
                    object3 = new StringBuffer("tokenTypes:");
                    for (String string : object4) {
                        ((StringBuffer)object3).append(" " + string);
                    }
                    Verbose.log("tokenTypes is: " + ((StringBuffer)object3).toString());
                }
                object3 = WSSCCredentialProviderFactory.getInstance();
                for (String string : object4) {
                    CredentialProvider credentialProvider = ((WSSCCredentialProviderFactory)object3).getCredentialProvider(string);
                    if (credentialProvider == null) continue;
                    wSSecurityContext.addCredentialProvider(credentialProvider);
                }
            }
        }
        catch (PolicyException policyException) {
            throw new WSSecurityException(policyException);
        }
    }

    private CredentialProvider getStubPropCredProv(SOAPMessageContext sOAPMessageContext) throws WSSecurityException {
        X509Certificate x509Certificate = (X509Certificate)sOAPMessageContext.getProperty("weblogic.wsee.security.bst.serverEncryptCert");
        X509Certificate x509Certificate2 = (X509Certificate)sOAPMessageContext.getProperty("weblogic.wsee.security.bst.serverVerifyCert");
        if (x509Certificate == null) {
            if (x509Certificate2 == null) {
                return null;
            }
            throw new WSSecurityException("Invalid to set server's verify certificate but no encryption certificate.");
        }
        return new StubPropertyBSTCredProv(x509Certificate, x509Certificate2);
    }

    private List getServiceRefClientCredProvs() {
        ArrayList<CredentialProvider> arrayList = new ArrayList<CredentialProvider>();
        arrayList.add(new ServiceRefUNTCredProv());
        arrayList.add(new ServiceRefBSTCredProv());
        arrayList.add(new PKISAMLCredentialProvider());
        arrayList.add(new SAML2CredentialProvider());
        arrayList.add(new SAMLTrustCredentialProvider());
        return arrayList;
    }

    private void populateSCCProactiveRequestor(SOAPMessageContext sOAPMessageContext) {
        SCCredentialProactiveRequestor sCCredentialProactiveRequestor = (SCCredentialProactiveRequestor)sOAPMessageContext.getProperty("weblogic.wsee.security.wssc.sct.scCredentialProactiveRequestor");
        if (sCCredentialProactiveRequestor != null && sCCredentialProactiveRequestor.verify((MessageContext)sOAPMessageContext)) {
            this.sccProactiveRequestor = sCCredentialProactiveRequestor;
        }
    }

    public void destroy() {
        if (this.sccProactiveRequestor != null) {
            this.sccProactiveRequestor.dispose();
            this.sccProactiveRequestor = null;
        }
    }
}

