/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssp.handlers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.utils.Debug;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.monitoring.WsspStats;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicySelectionPreference;
import weblogic.wsee.security.configuration.TimestampConfiguration;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.util.FaultUtils;
import weblogic.wsee.security.wss.SecurityPolicyArchitect;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wss.SecurityPolicyInspector;
import weblogic.wsee.security.wss.plan.SecurityPolicyOutlineDescriber;
import weblogic.wsee.security.wss.plan.SecurityPolicyPlan;
import weblogic.wsee.security.wss.policy.SecurityPolicyInspectionException;
import weblogic.wsee.security.wssp.handlers.WssHandlerListener;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsService;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.wss.BinarySecurityTokenHandler;
import weblogic.xml.crypto.wss.TimestampHandler;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.nonce.NonceValidatorFactory;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss11.internal.SecurityBuilderImpl;
import weblogic.xml.crypto.wss11.internal.SecurityValidator;
import weblogic.xml.crypto.wss11.internal.SecurityValidatorFactory;
import weblogic.xml.crypto.wss11.internal.WSS11Constants;
import weblogic.xml.crypto.wss11.internal.WSS11Context;
import weblogic.xml.crypto.wss11.internal.bst.BSTHandler;

public abstract class WssHandler
extends GenericHandler {
    private static final boolean verbose = Verbose.isVerbose(WssHandler.class);
    public static final String VERBOSE_PROPERTY = "weblogic.wsee.security.WssHandler";
    public static final boolean VERBOSE = Boolean.getBoolean("weblogic.wsee.security.WssHandler");
    private static QName[] headers = new QName[]{WSSConstants.SECURITY_QNAME, WSS11Constants.ENC_HEADER_QNAME};

    public QName[] getHeaders() {
        return headers;
    }

    protected abstract boolean processRequest(SOAPMessageContext var1) throws SecurityPolicyException, PolicyException, SOAPException, WSSecurityException;

    protected abstract boolean processResponse(SOAPMessageContext var1) throws SecurityPolicyException, PolicyException, SOAPException, WSSecurityException;

    public boolean handleRequest(MessageContext messageContext) {
        Object object;
        SOAPMessageContext sOAPMessageContext;
        List<WssHandlerListener> list = WssHandlerListener.retreive(messageContext);
        if (list != null) {
            sOAPMessageContext = list.iterator();
            while (sOAPMessageContext.hasNext()) {
                object = sOAPMessageContext.next();
                if (((WssHandlerListener)object).isDisposed()) {
                    sOAPMessageContext.remove();
                    continue;
                }
                try {
                    ((WssHandlerListener)object).preHandlingRequest(messageContext);
                }
                catch (Exception exception) {}
            }
        }
        if (VERBOSE) {
            Debug.say((String)(((Object)((Object)this)).getClass() + ".handleRequest"));
        }
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        sOAPMessageContext = (SOAPMessageContext)messageContext;
        this.copyEndpointAddress(sOAPMessageContext);
        object = null;
        WsspStats wsspStats = this.getWsspStats(sOAPMessageContext);
        try {
            try {
                this.processRequest(sOAPMessageContext);
            }
            catch (SecurityPolicyException securityPolicyException) {
                object = securityPolicyException;
                wsspStats.reportPolicyFault();
                FaultUtils.setSOAPFault(securityPolicyException, (SoapMessageContext)sOAPMessageContext);
                return false;
            }
            catch (PolicyException policyException) {
                object = policyException;
                wsspStats.reportPolicyFault();
                FaultUtils.setSOAPFault(policyException, (SoapMessageContext)sOAPMessageContext);
                return false;
            }
            catch (SecurityPolicyInspectionException securityPolicyInspectionException) {
                object = securityPolicyInspectionException;
                this.reportWSSErrorToWsspStats(wsspStats, sOAPMessageContext, securityPolicyInspectionException);
                FaultUtils.setSOAPFault(securityPolicyInspectionException, (SoapMessageContext)sOAPMessageContext);
                return false;
            }
            catch (WSSecurityException wSSecurityException) {
                WSSecurityException wSSecurityException2;
                object = wSSecurityException;
                this.reportWSSErrorToWsspStats(wsspStats, sOAPMessageContext, wSSecurityException);
                if (!FaultUtils.isDebug()) {
                    wSSecurityException2 = new WSSecurityException("Unknown exception, internal system processing error.");
                }
                FaultUtils.setSOAPFault(wSSecurityException2, (SoapMessageContext)sOAPMessageContext);
                return false;
            }
            catch (SOAPException sOAPException) {
                wsspStats.reportGeneralFault();
                throw new JAXRPCException((Throwable)sOAPException);
            }
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException((Throwable)object);
        }
        list = WssHandlerListener.retreive(messageContext);
        if (list != null) {
            Iterator<WssHandlerListener> iterator = list.iterator();
            while (iterator.hasNext()) {
                WssHandlerListener wssHandlerListener = iterator.next();
                if (wssHandlerListener.isDisposed()) {
                    iterator.remove();
                    continue;
                }
                try {
                    wssHandlerListener.postHandlingRequest(messageContext);
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        Object object;
        SOAPMessageContext sOAPMessageContext;
        List<WssHandlerListener> list = WssHandlerListener.retreive(messageContext);
        if (list != null) {
            sOAPMessageContext = list.iterator();
            while (sOAPMessageContext.hasNext()) {
                object = sOAPMessageContext.next();
                if (((WssHandlerListener)object).isDisposed()) {
                    sOAPMessageContext.remove();
                    continue;
                }
                try {
                    ((WssHandlerListener)object).preHandlingResponse(messageContext);
                }
                catch (Exception exception) {}
            }
        }
        messageContext.setProperty("weblogic.wsee.security.fault", (Object)true);
        if (VERBOSE) {
            Debug.say((String)(((Object)((Object)this)).getClass() + ".handleResponse"));
        }
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        sOAPMessageContext = (SOAPMessageContext)messageContext;
        object = null;
        WsspStats wsspStats = this.getWsspStats(sOAPMessageContext);
        try {
            try {
                this.processResponse(sOAPMessageContext);
            }
            catch (SecurityPolicyException securityPolicyException) {
                object = securityPolicyException;
                wsspStats.reportPolicyFault();
                WssHandler.setFault(securityPolicyException, sOAPMessageContext);
            }
            catch (PolicyException policyException) {
                object = policyException;
                wsspStats.reportPolicyFault();
                WssHandler.setFault(policyException, sOAPMessageContext);
                return false;
            }
            catch (WSSecurityException wSSecurityException) {
                object = wSSecurityException;
                this.reportWSSErrorToWsspStats(wsspStats, sOAPMessageContext, wSSecurityException);
                WssHandler.setFault(wSSecurityException, (SoapMessageContext)sOAPMessageContext);
                return false;
            }
            catch (SOAPException sOAPException) {
                wsspStats.reportGeneralFault();
                throw new JAXRPCException((Throwable)sOAPException);
            }
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException((Throwable)object);
        }
        list = WssHandlerListener.retreive(messageContext);
        if (list != null) {
            Iterator<WssHandlerListener> iterator = list.iterator();
            while (iterator.hasNext()) {
                WssHandlerListener wssHandlerListener = iterator.next();
                if (wssHandlerListener.isDisposed()) {
                    iterator.remove();
                    continue;
                }
                try {
                    wssHandlerListener.postHandlingResponse(messageContext);
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    protected void copyEndpointAddress(SOAPMessageContext sOAPMessageContext) {
        String string = (String)sOAPMessageContext.getProperty("javax.xml.rpc.service.endpoint.address");
        sOAPMessageContext.setProperty("weblogic.wsee.security.wss.end_point_url", (Object)string);
    }

    private static void setFault(Exception exception, SOAPMessageContext sOAPMessageContext) throws SOAPException {
        FaultUtils.setSOAPFault(exception, (SoapMessageContext)sOAPMessageContext);
        sOAPMessageContext.setProperty("weblogic.wsee.security.fault", (Object)true);
    }

    protected SecurityPolicyArchitect getSecurityPolicyDriver(SOAPMessageContext sOAPMessageContext) throws SOAPException, WSSecurityException {
        WSS11Context wSS11Context = this.setupSecurityContext(sOAPMessageContext);
        SecurityBuilderImpl securityBuilderImpl = new SecurityBuilderImpl(wSS11Context);
        return new SecurityPolicyArchitect(securityBuilderImpl, wSS11Context);
    }

    protected static boolean hasSecurityHeader(SOAPMessageContext sOAPMessageContext) throws SOAPException {
        SOAPHeader sOAPHeader = sOAPMessageContext.getMessage().getSOAPHeader();
        if (sOAPHeader == null) {
            return false;
        }
        NodeList nodeList = sOAPHeader.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        return nodeList.getLength() != 0;
    }

    protected WSS11Context setupSecurityContext(SOAPMessageContext sOAPMessageContext) throws SOAPException, WSSecurityException {
        WSS11Context wSS11Context = this.getSecurityContext(sOAPMessageContext);
        this.fillTokenHandlers(sOAPMessageContext, wSS11Context);
        this.fillCredentialProviders(sOAPMessageContext, wSS11Context);
        this.initWsscConfigParams(sOAPMessageContext);
        return wSS11Context;
    }

    private void initWsscConfigParams(SOAPMessageContext sOAPMessageContext) {
        WssPolicyContext wssPolicyContext = this.getPolicyContext(sOAPMessageContext);
        PolicySelectionPreference policySelectionPreference = wssPolicyContext.getWssConfiguration().getPolicySelectionPreference();
        if (null != policySelectionPreference && null == sOAPMessageContext.getProperty("weblogic.wsee.policy.selection.preference")) {
            sOAPMessageContext.setProperty("weblogic.wsee.policy.selection.preference", (Object)policySelectionPreference);
        }
    }

    private static final void updateProperty(SOAPMessageContext sOAPMessageContext, String string, Object object) {
        if (sOAPMessageContext.getProperty(string) == null) {
            sOAPMessageContext.setProperty(string, object);
        }
    }

    protected WSS11Context getSecurityContext(SOAPMessageContext sOAPMessageContext) throws SOAPException {
        WSS11Context wSS11Context = (WSS11Context)WSSecurityContext.getSecurityContext((MessageContext)sOAPMessageContext);
        Object object = sOAPMessageContext.getMessage().getSOAPHeader();
        if (object == null) {
            object = WssHandler.createSOAPHeader(sOAPMessageContext);
        }
        if (wSS11Context == null) {
            wSS11Context = new WSS11Context((Node)object, null, null, null);
        } else {
            wSS11Context.init((Node)object, null, null, null);
        }
        sOAPMessageContext.setProperty("weblogic.xml.crypto.wss.WSSecurityContext", (Object)wSS11Context);
        wSS11Context.setProperty("javax.xml.rpc.handler.MessageContext", sOAPMessageContext);
        return wSS11Context;
    }

    private static Node createSOAPHeader(SOAPMessageContext sOAPMessageContext) throws SOAPException {
        return sOAPMessageContext.getMessage().getSOAPPart().getEnvelope().addHeader();
    }

    protected void fillCredentialProviders(SOAPMessageContext sOAPMessageContext, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        WssPolicyContext wssPolicyContext = this.getPolicyContext(sOAPMessageContext);
        List list = wssPolicyContext.getWssConfiguration().getCredentialProviders();
        for (CredentialProvider credentialProvider : list) {
            wSSecurityContext.setCredentialProvider(credentialProvider);
        }
    }

    protected void fillTokenHandlers(SOAPMessageContext sOAPMessageContext, WSSecurityContext wSSecurityContext) throws WssConfigurationException {
        Object object;
        Object object2;
        Object object3;
        WssPolicyContext wssPolicyContext = this.getPolicyContext(sOAPMessageContext);
        List list = wssPolicyContext.getWssConfiguration().getTokenHandlers();
        if (null != list) {
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (SecurityTokenHandler)object3.next();
                if (null != object2) {
                    if (wSSecurityContext instanceof WSS11Context && object2.getClass() == BinarySecurityTokenHandler.class) {
                        object = (BinarySecurityTokenHandler)object2;
                        boolean bl = ((BinarySecurityTokenHandler)object).isAuthorizationToken();
                        object = new BSTHandler();
                        ((BinarySecurityTokenHandler)object).setAuthorizationToken(bl);
                        object2 = object;
                    }
                    wSSecurityContext.setTokenHandler((SecurityTokenHandler)object2);
                    continue;
                }
                if (!VERBOSE) continue;
                Debug.say((String)"Found a null Security Token from weblogic.xml.crypto.wss.provider.SecurityTokenHandler");
            }
        }
        if ((object3 = wssPolicyContext.getWssConfiguration().getTimestampConfig()) == null) {
            object3 = new TimestampConfiguration();
        }
        wSSecurityContext.setTimestampHandler((TimestampHandler)object3);
        object2 = NonceValidatorFactory.getInstance(((TimestampConfiguration)object3).getMessageAge());
        object = (Integer)sOAPMessageContext.getProperty("weblogic.wsee.security.message_age");
        if (object == null) {
            sOAPMessageContext.setProperty("weblogic.wsee.security.message_age", (Object)new Integer(((TimestampConfiguration)object3).getMessageAge()));
        } else {
            object2.setExpirationTime((Integer)object);
        }
    }

    private WssPolicyContext getPolicyContext(SOAPMessageContext sOAPMessageContext) {
        WssPolicyContext wssPolicyContext = (WssPolicyContext)sOAPMessageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
        if (wssPolicyContext == null) {
            WlMessageContext wlMessageContext = WlMessageContext.narrow((MessageContext)sOAPMessageContext);
            WsService wsService = wlMessageContext.getDispatcher().getWsPort().getEndpoint().getService();
            wssPolicyContext = wsService.getWssPolicyContext();
            sOAPMessageContext.setProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx", (Object)wssPolicyContext);
        }
        return wssPolicyContext;
    }

    protected void preValidate(SOAPMessageContext sOAPMessageContext, boolean bl) throws SOAPException, MarshalException, WSSecurityException {
        WSS11Context wSS11Context = this.getSecurityContext(sOAPMessageContext);
        SecurityValidator securityValidator = SecurityValidatorFactory.getSecurityValidator(wSS11Context);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        SecurityPolicyOutlineDescriber securityPolicyOutlineDescriber = new SecurityPolicyOutlineDescriber(securityValidator);
        securityPolicyOutlineDescriber.sketchPolicyOutline(sOAPMessageContext.getMessage(), hashMap, bl, wSS11Context);
        SecurityPolicyPlan securityPolicyPlan = securityPolicyOutlineDescriber.getPolicyOutline();
        wSS11Context.setPolicyOutline(securityPolicyPlan);
    }

    protected void postValidate(NormalizedExpression normalizedExpression, SOAPMessageContext sOAPMessageContext, boolean bl) throws SOAPException, MarshalException, XMLEncryptionException, SecurityPolicyException, WSSecurityException, PolicyException {
        WSS11Context wSS11Context = this.getSecurityContext(sOAPMessageContext);
        SecurityValidator securityValidator = SecurityValidatorFactory.getSecurityValidator(wSS11Context);
        SecurityPolicyInspector securityPolicyInspector = new SecurityPolicyInspector(securityValidator, wSS11Context);
        if (bl) {
            securityPolicyInspector.processRequestOutbound(normalizedExpression, sOAPMessageContext);
        } else {
            securityPolicyInspector.processResponseOutbound(normalizedExpression, sOAPMessageContext);
        }
    }

    protected WsspStats getWsspStats(SOAPMessageContext sOAPMessageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow((MessageContext)sOAPMessageContext);
        if (wlMessageContext != null && wlMessageContext.getDispatcher() != null && wlMessageContext.getDispatcher().getWsPort().getWsspStats() != null) {
            return wlMessageContext.getDispatcher().getWsPort().getWsspStats();
        }
        return new WsspStats(){

            public void reportAuthenticationSuccess() {
            }

            public void reportAuthenticationViolation() {
            }

            public void reportAuthorizationSuccess() {
            }

            public void reportAuthorizationViolation() {
            }

            public void reportConfidentialitySuccess() {
            }

            public void reportConfidentialityViolation() {
            }

            public void reportIntegritySuccess() {
            }

            public void reportIntegrityViolation() {
            }

            public void reportPolicyFault() {
            }

            public void reportGeneralFault() {
            }
        };
    }

    protected void reportWSSErrorToWsspStats(WsspStats wsspStats, SOAPMessageContext sOAPMessageContext, WSSecurityException wSSecurityException) {
        assert (wsspStats != null);
        if (wSSecurityException instanceof SecurityPolicyInspectionException) {
            SecurityPolicyInspectionException securityPolicyInspectionException = (SecurityPolicyInspectionException)wSSecurityException;
            int n = securityPolicyInspectionException.getErrorCode();
            if (n >= 1000 && n < 2000) {
                wsspStats.reportAuthenticationViolation();
            } else if (n >= 3000 && n < 4000 || n >= 6300 && n < 4000 || n >= 7000 && n < 8000) {
                wsspStats.reportIntegrityViolation();
            } else if (n >= 4000 && n < 6000) {
                wsspStats.reportConfidentialityViolation();
            } else {
                wsspStats.reportPolicyFault();
            }
            return;
        }
        if (wSSecurityException.getFaultCode() != null) {
            QName qName = wSSecurityException.getFaultCode();
            if (WSSConstants.FAILURE_AUTH.equals(qName)) {
                wsspStats.reportAuthenticationViolation();
            } else if (WSSConstants.FAILURE_INVALID.equals(qName) || WSSConstants.FAILURE_VERIFY_OR_DECRYPT.equals(qName)) {
                if (wSSecurityException.getCause() instanceof XMLEncryptionException) {
                    wsspStats.reportConfidentialityViolation();
                } else if (!StringUtil.isEmpty(wSSecurityException.getMessage())) {
                    String string = wSSecurityException.getMessage().toUpperCase(Locale.ENGLISH);
                    if (string.indexOf("SIGNATURE") > 0) {
                        wsspStats.reportIntegrityViolation();
                    } else if (string.indexOf("ENCRYPTED") > 0 || string.indexOf("ENCRYPT") > 0) {
                        wsspStats.reportConfidentialityViolation();
                    } else {
                        wsspStats.reportGeneralFault();
                    }
                } else {
                    wsspStats.reportGeneralFault();
                }
            } else if (WSSConstants.FAILURE_TOKEN_INVALID.equals(qName) || WSSConstants.FAILURE_TOKEN_UNAVAILABLE.equals(qName)) {
                wsspStats.reportGeneralFault();
            } else {
                wsspStats.reportGeneralFault();
            }
        } else if (!StringUtil.isEmpty(wSSecurityException.getMessage())) {
            String string = wSSecurityException.getMessage().toUpperCase(Locale.ENGLISH);
            if (string.indexOf("SIGNATURE") > 0) {
                wsspStats.reportIntegrityViolation();
            } else if (string.indexOf("ENCRYPTED") > 0 || string.indexOf("ENCRYPT") > 0) {
                wsspStats.reportConfidentialityViolation();
            } else if (wSSecurityException.getCause() instanceof SecurityPolicyException) {
                wsspStats.reportPolicyFault();
            } else {
                wsspStats.reportGeneralFault();
            }
        } else {
            wsspStats.reportGeneralFault();
        }
    }

    protected void reportInboundWSSSuccessToWsspStats(WsspStats wsspStats, SOAPMessageContext sOAPMessageContext) {
        assert (wsspStats != null);
        WSS11Context wSS11Context = (WSS11Context)sOAPMessageContext.getProperty("weblogic.xml.crypto.wss.WSSecurityContext");
        assert (wSS11Context != null);
        SecurityPolicyPlan securityPolicyPlan = (SecurityPolicyPlan)wSS11Context.getPolicyOutline();
        if (securityPolicyPlan != null && securityPolicyPlan.getBuildingPlan() > 0) {
            if (securityPolicyPlan.getEncryptionPolicy() != null && securityPolicyPlan.getEncryptionPolicy().isEncryptionRequired()) {
                wsspStats.reportConfidentialitySuccess();
            }
            if (securityPolicyPlan.getSigningPolicy() != null && securityPolicyPlan.getSigningPolicy().isSignatureRequired()) {
                wsspStats.reportIntegritySuccess();
            }
        }
    }

    protected void reportOutboundWSSSuccessToWsspStats(WsspStats wsspStats, SOAPMessageContext sOAPMessageContext) {
        assert (wsspStats != null);
        WSS11Context wSS11Context = (WSS11Context)sOAPMessageContext.getProperty("weblogic.xml.crypto.wss.WSSecurityContext");
        assert (wSS11Context != null);
        SecurityPolicyPlan securityPolicyPlan = (SecurityPolicyPlan)wSS11Context.getPolicyOutline();
        if (securityPolicyPlan != null && securityPolicyPlan.getBuildingPlan() > 0) {
            if (securityPolicyPlan.getEncryptionPolicy() != null && securityPolicyPlan.getEncryptionPolicy().isEncryptionRequired()) {
                wsspStats.reportConfidentialitySuccess();
            }
            if (securityPolicyPlan.getSigningPolicy() != null && securityPolicyPlan.getSigningPolicy().isSignatureRequired()) {
                wsspStats.reportIntegritySuccess();
            }
        }
    }
}

