/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssp.handlers;

import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import weblogic.wsee.handler.WLHandler;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.security.wss.SecurityPolicyArchitect;
import weblogic.wsee.security.wss.SecurityPolicyException;
import weblogic.wsee.security.wssp.handlers.WssHandler;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss11.internal.WSS11Context;
import weblogic.xml.crypto.wss11.internal.WSS11Factory;
import weblogic.xml.dom.marshal.MarshalException;

public class WssServerHandler
extends WssHandler
implements WLHandler {
    private static final boolean verbose = Verbose.isVerbose(WssServerHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processRequest(SOAPMessageContext sOAPMessageContext) throws PolicyException, SOAPException, WSSecurityException {
        String[] stringArray;
        try {
            if (!WssServerHandler.hasSecurityHeader(sOAPMessageContext)) {
                return true;
            }
            this.setupSecurityContext(sOAPMessageContext);
            try {
                sOAPMessageContext.setProperty("weblogic.wsee.security.wssc.needCheckSCTExpiration", (Object)"true");
                WSS11Factory.getInstance();
                WSS11Factory.unmarshalAndProcessSecurity(sOAPMessageContext);
                stringArray = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                sOAPMessageContext.setProperty("weblogic.wsee.security.wssc.needCheckSCTExpiration", (Object)"false");
                throw throwable;
            }
            sOAPMessageContext.setProperty("weblogic.wsee.security.wssc.needCheckSCTExpiration", (Object)"false");
            {
            }
        }
        catch (MarshalException marshalException) {
            Throwable throwable = marshalException.getCause();
            if (throwable instanceof WSSecurityException) {
                throw (WSSecurityException)throwable;
            }
            if (throwable instanceof SOAPException) {
                throw (SOAPException)throwable;
            }
            throw new WSSecurityException(marshalException, WSSConstants.FAILURE_INVALID);
        }
        WSS11Context wSS11Context = (WSS11Context)WSSecurityContext.getSecurityContext((MessageContext)sOAPMessageContext);
        stringArray = wSS11Context.getSignatureValues();
        wSS11Context.addPreviousMessageSignatureValues(stringArray);
        return true;
    }

    protected boolean processResponse(SOAPMessageContext sOAPMessageContext) throws PolicyException, SOAPException, WSSecurityException, SecurityPolicyException {
        WlMessageContext wlMessageContext = WlMessageContext.narrow((MessageContext)sOAPMessageContext);
        if (wlMessageContext.hasFault() || (wlMessageContext.getProperty("weblogic.wsee.queued.invoke") != null || wlMessageContext.getProperty("weblogic.wsee.enable.rm") != null && wlMessageContext.getProperty("weblogic.wsee.async.res") == null) && wlMessageContext.getProperty("weblogic.wsee.reliable.oneway.reply") == null) {
            return true;
        }
        NormalizedExpression normalizedExpression = PolicyContext.getResponseEffectivePolicy((MessageContext)sOAPMessageContext);
        if (normalizedExpression == null || normalizedExpression.getPolicyAlternatives() == null) {
            return true;
        }
        SecurityPolicyArchitect securityPolicyArchitect = this.getSecurityPolicyDriver(sOAPMessageContext);
        try {
            WssServerHandler.processOutbound(normalizedExpression, securityPolicyArchitect, sOAPMessageContext);
        }
        catch (weblogic.xml.crypto.api.MarshalException marshalException) {
            throw new WSSecurityException(marshalException);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new WSSecurityException(xMLEncryptionException);
        }
        this.reportOutboundWSSSuccessToWsspStats(this.getWsspStats(sOAPMessageContext), sOAPMessageContext);
        return true;
    }

    protected static void processOutbound(NormalizedExpression normalizedExpression, SecurityPolicyArchitect securityPolicyArchitect, SOAPMessageContext sOAPMessageContext) throws PolicyException, WSSecurityException, SecurityPolicyException, weblogic.xml.crypto.api.MarshalException, XMLEncryptionException {
        WSS11Context wSS11Context = (WSS11Context)WSSecurityContext.getSecurityContext((MessageContext)sOAPMessageContext);
        int n = wSS11Context.getRequestPolicyIdx();
        wSS11Context.reset();
        wSS11Context.setRequestPolicyIdx(n);
        securityPolicyArchitect.processResponseOutbound(normalizedExpression, sOAPMessageContext);
    }

    protected void fillCredentialProviders(SOAPMessageContext sOAPMessageContext, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        super.fillCredentialProviders(sOAPMessageContext, wSSecurityContext);
    }

    public boolean handleClosure(MessageContext messageContext) {
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        if (wlMessageContext.getProperty("weblogic.wsee.reliable.oneway.reply") != null) {
            return this.handleResponse(messageContext);
        }
        return true;
    }
}

