/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wssp.tube;

import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import weblogic.wsee.jaxws.WLSContainer;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.jaxws.tubeline.AbstractTubeFactory;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;
import weblogic.wsee.jaxws.tubeline.TubelineDeploymentListener;
import weblogic.wsee.security.wssc.utils.WSSCCompatibilityUtil;
import weblogic.wsee.security.wssp.tube.WSTHeuristicTube;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTHeuristicServerTubelineDeploymentListener
implements TubelineDeploymentListener {
    public static final String TUBE_NAME = "WS_TRUST_HEURISTIC_HANDLER";

    @Override
    public void createClient(ClientTubeAssemblerContext clientTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
    }

    @Override
    public void createServer(ServerTubeAssemblerContext serverTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        if (!WSSCCompatibilityUtil.isHeuristicCompatibility()) {
            return;
        }
        TubelineAssemblerItem tubelineAssemblerItem = new TubelineAssemblerItem(TUBE_NAME, new AbstractTubeFactory(){

            public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                if (serverTubeAssemblerContext.getEndpoint().getContainer() instanceof WLSContainer) {
                    EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(serverTubeAssemblerContext.getEndpoint());
                    WSTHeuristicTube wSTHeuristicTube = new WSTHeuristicTube(environmentFactory, tube);
                    return wSTHeuristicTube;
                }
                return tube;
            }
        });
        HashSet<String> hashSet = new HashSet<String>(this.getPrecedingWstHeuristicNames());
        HashSet<String> hashSet2 = new HashSet<String>(this.getFollowingWstHeuristicNames());
        tubelineAssemblerItem.setGoBefore(hashSet);
        tubelineAssemblerItem.setGoAfter(hashSet2);
        set.add(tubelineAssemblerItem);
    }

    private List getPrecedingWstHeuristicNames() {
        return Arrays.asList((Object[])new String[]{"CONNECTION_HANDLER", "FORWARDING_HANDLER"});
    }

    private List getFollowingWstHeuristicNames() {
        return Arrays.asList((Object[])new String[]{"WS_TRUST_POLICY_HANDLER"});
    }
}

