/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.binding;

import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.security.wst.binding.TrustDOMStructure;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.Base64Encoding;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.dom.marshal.MarshalException;

public class BinarySecret
extends TrustDOMStructure {
    private static final long serialVersionUID = 4725494712412800768L;
    public static final String NAME = "BinarySecret";
    public static final String XML_ATTRIB_BS_TYPE = "Type";
    private String id;
    private String type;
    private byte[] value;

    public BinarySecret() {
    }

    public BinarySecret(String string) {
        if (string != null) {
            this.namespaceUri = string;
        }
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] byArray) {
        this.value = byArray;
    }

    public void marshalContents(Element element, Map map) throws MarshalException {
        String string;
        assert (this.value != null);
        if (this.id == null) {
            this.id = DOMUtils.generateId(NAME);
        }
        if (null == (string = (String)map.get("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"))) {
            string = "wsu";
            map.put("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", string);
        }
        DOMUtils.addPrefixedAttribute(element, WSSConstants.WSU_ID_QNAME, string, this.id);
        DOMUtils.declareNamespace(element, WSSConstants.WSU_ID_QNAME.getNamespaceURI(), string, map);
        if (this.type != null) {
            BinarySecret.setAttribute(element, XML_ATTRIB_BS_TYPE, this.type);
        }
        BinarySecret.addTextContent(element, new Base64Encoding().encode(this.value));
    }

    public void unmarshalContents(Element element) throws MarshalException {
        this.id = BinarySecret.getAttributeValueAsString(element, WSSConstants.WSU_ID_QNAME);
        this.type = BinarySecret.getAttributeValueAsString(element, new QName(XML_ATTRIB_BS_TYPE));
        this.value = new Base64Encoding().decode(BinarySecret.getTextContent(element));
    }

    public String getName() {
        return NAME;
    }
}

