/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.binding;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import org.w3c.dom.Element;
import weblogic.wsee.security.wst.binding.TrustDOMStructure;
import weblogic.xml.dom.marshal.MarshalException;
import weblogic.xml.schema.types.IllegalLexicalValueException;
import weblogic.xml.schema.types.XSDDateTime;

public class Lifetime
extends TrustDOMStructure {
    public static final String NAME = "Lifetime";
    private Created created;
    private Expires expires;

    public Lifetime() {
        this.namespaceUri = "source of undefined namespace: " + Thread.currentThread().getStackTrace();
    }

    public Lifetime(String string) {
        if (string != null) {
            this.namespaceUri = string;
        }
    }

    public void setCreated(Calendar calendar, String string) {
        this.created = new Created(string);
        this.created.setTime(calendar);
    }

    public void setExpires(Calendar calendar, String string) {
        this.expires = new Expires(string);
        this.expires.setTime(calendar);
    }

    public void setPeriod(long l) {
        this.setPeriod(l, null);
    }

    public void setPeriod(long l, String string) {
        Date date = new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setTime(date);
        this.setCreated(gregorianCalendar, null);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar2.setTimeInMillis(date.getTime() + l);
        this.setExpires(gregorianCalendar2, null);
    }

    public Calendar getCreated() {
        if (this.created != null) {
            return this.created.getTime();
        }
        return null;
    }

    public Calendar getExpires() {
        if (this.expires != null) {
            return this.expires.getTime();
        }
        return null;
    }

    public void marshalContents(Element element, Map map) throws MarshalException {
        if (this.created != null) {
            this.created.marshal(element, null, map);
        }
        if (this.expires != null) {
            this.expires.marshal(element, null, map);
        }
    }

    public void unmarshalContents(Element element) throws MarshalException {
        Element element2;
        Element element3 = Lifetime.getElementByTagName(element, "Created", true);
        if (element3 != null) {
            this.created = new Created(element3.getNamespaceURI());
            this.created.unmarshal(element3);
        }
        if ((element2 = Lifetime.getElementByTagName(element, "Expires", true)) != null) {
            this.expires = new Expires(element2.getNamespaceURI());
            this.expires.unmarshal(element2);
        }
    }

    public String getName() {
        return NAME;
    }

    private static abstract class Time
    extends TrustDOMStructure {
        protected Calendar time;

        private Time() {
        }

        protected void setTime(Calendar calendar) {
            this.time = calendar;
        }

        protected Calendar getTime() {
            return this.time;
        }

        protected void initNamespaceUriAndPrefix(String string) {
            this.namespaceUri = string != null ? string : "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
            this.prefix = "wsu";
        }

        public void marshalContents(Element element, Map map) throws MarshalException {
            Time.addTextContent(element, XSDDateTime.getXml((Calendar)this.time));
        }

        public void unmarshalContents(Element element) throws MarshalException {
            try {
                this.time = XSDDateTime.convertXml((String)Time.getTextContent(element));
            }
            catch (IllegalLexicalValueException illegalLexicalValueException) {
                throw new MarshalException("Lifetime is invalid.");
            }
        }
    }

    private static final class Expires
    extends Time {
        public static final String NAME = "Expires";

        public Expires() {
            this.initNamespaceUriAndPrefix(null);
        }

        public Expires(String string) {
            this.initNamespaceUriAndPrefix(string);
        }

        public String getName() {
            return NAME;
        }
    }

    private static final class Created
    extends Time {
        public static final String NAME = "Created";

        public Created() {
            this.initNamespaceUriAndPrefix(null);
        }

        public Created(String string) {
            this.initNamespaceUriAndPrefix(string);
        }

        public String getName() {
            return NAME;
        }
    }
}

