/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.binding;

import java.util.Map;
import org.w3c.dom.Element;
import weblogic.wsee.security.wst.binding.TrustDOMStructure;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.dom.marshal.MarshalException;

public class RequestedSecurityToken
extends TrustDOMStructure {
    private static final long serialVersionUID = 1274568700804020443L;
    public static final String NAME = "RequestedSecurityToken";
    private static final SecurityTokenContextHandler EMPTY_CONTEXT = new SecurityTokenContextHandler();
    private transient SecurityToken securityToken;
    private transient SecurityTokenHandler tokenHandler;
    private String tokenType;

    public RequestedSecurityToken() {
    }

    public RequestedSecurityToken(String string) {
        this.namespaceUri = string;
    }

    public void setTokenHandler(SecurityTokenHandler securityTokenHandler) {
        this.tokenHandler = securityTokenHandler;
    }

    public SecurityTokenHandler getTokenHandler() {
        return this.tokenHandler;
    }

    public void setSecurityToken(SecurityToken securityToken) {
        this.securityToken = securityToken;
    }

    public SecurityToken getSecurityToken() {
        return this.securityToken;
    }

    public void marshalContents(Element element, Map map) throws MarshalException {
        if (this.securityToken == null) {
            throw new MarshalException("Security token can not be null");
        }
        this.securityToken.marshal(element, null, map);
    }

    public void unmarshalContents(Element element) throws MarshalException {
        Element element2 = RequestedSecurityToken.getFirstElement(element);
        if (element2 == null) {
            throw new MarshalException("RequestedSecurityToken can not be empty.");
        }
        if (this.tokenHandler == null) {
            throw new MarshalException("Can not find valid security token in RequestedSecurityToken: " + element2);
        }
        try {
            this.securityToken = this.tokenHandler.newSecurityToken(element2);
            Object object = this.securityToken.getCredential();
            SecurityToken securityToken = this.tokenHandler.getSecurityToken(this.tokenType, object, EMPTY_CONTEXT);
            if (securityToken != null) {
                this.securityToken = securityToken;
            }
        }
        catch (weblogic.xml.crypto.api.MarshalException marshalException) {
            throw new MarshalException(marshalException);
        }
        catch (WSSecurityException wSSecurityException) {
            throw new MarshalException(wSSecurityException);
        }
    }

    public String getName() {
        return NAME;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String string) {
        this.tokenType = string;
    }
}

