/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.framework;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.wsee.security.wst.faults.RequestFailedException;
import weblogic.wsee.security.wst.framework.TrustProcessor;
import weblogic.wsee.util.Verbose;

public class TrustProcessorFactory {
    private static final boolean verbose = Verbose.isVerbose(TrustProcessorFactory.class);
    private ConcurrentHashMap<String, TrustProcessor> processors = new ConcurrentHashMap();
    private static TrustProcessorFactory instance = new TrustProcessorFactory();

    private TrustProcessorFactory() {
        try {
            TrustProcessor trustProcessor = TrustProcessorFactory.createTrustProcessor("weblogic.wsee.security.wst.internal.IssueProcessor");
            this.register(trustProcessor);
            this.register("/SCT", trustProcessor);
            this.register("http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT", trustProcessor);
            this.register(TrustProcessorFactory.createTrustProcessor("weblogic.wsee.security.wst.internal.RenewProcessor"));
            this.register(TrustProcessorFactory.createTrustProcessor("weblogic.wsee.security.wst.internal.CancelProcessor"));
        }
        catch (RequestFailedException requestFailedException) {
            requestFailedException.printStackTrace();
        }
    }

    public static TrustProcessorFactory getInstance() {
        return instance;
    }

    public void register(TrustProcessor trustProcessor) {
        this.register(trustProcessor.getRequestType(), trustProcessor);
    }

    public void register(String string, TrustProcessor trustProcessor) {
        this.processors.put(string, trustProcessor);
    }

    public TrustProcessor getProcessor(String string) throws RequestFailedException {
        if (verbose) {
            Verbose.log(" looking up TrustProcessor for requestType='" + string + "'");
        }
        Set<Map.Entry<String, TrustProcessor>> set = this.processors.entrySet();
        for (Map.Entry<String, TrustProcessor> entry : set) {
            if (!string.endsWith(entry.getKey())) continue;
            if (verbose) {
                Verbose.log(" for requestType='" + string + "', we will return '" + entry.getValue().getClass().getName() + "'");
            }
            return entry.getValue();
        }
        throw new RequestFailedException("Can not find TrustProcessor for request type: " + string);
    }

    private static final TrustProcessor createTrustProcessor(String string) throws RequestFailedException {
        try {
            Class<?> clazz = Class.forName(string);
            return (TrustProcessor)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RequestFailedException("Can not find trust processor " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RequestFailedException("Can not access trust processor " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new RequestFailedException("Can not instantiate trust processor " + string);
        }
        catch (ClassCastException classCastException) {
            throw new RequestFailedException(string + " is not a trust processor.");
        }
    }
}

