/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.framework;

import java.util.HashMap;
import weblogic.wsee.security.wst.faults.InvalidRequestException;
import weblogic.wsee.security.wst.framework.TrustRequestor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustRequestorFactory {
    public static final String SPEC_V200502 = "http://schemas.xmlsoap.org/ws/2005/02/trust";
    public static final String SPEC_V13 = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    public static final String DEFAULT_SPEC = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    private static TrustRequestorFactory instance = new TrustRequestorFactory();
    private HashMap<String, String> implRegistry = new HashMap();

    private TrustRequestorFactory() {
        this.implRegistry.put(SPEC_V200502, "weblogic.wsee.security.wst.internal.TrustRequestorImpl");
        this.implRegistry.put("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "weblogic.wsee.security.wst.internal.TrustRequestorImpl");
    }

    public static TrustRequestorFactory getInstance() {
        return instance;
    }

    public TrustRequestor createTrustRequestor(String string) throws InvalidRequestException {
        return TrustRequestorFactory.newTrustRequestorInstance(this.implRegistry, string != null ? string : SPEC_V200502);
    }

    private static final TrustRequestor newTrustRequestorInstance(HashMap<String, String> hashMap, String string) throws InvalidRequestException {
        String string2 = hashMap.get(string);
        if (string2 == null) {
            throw new InvalidRequestException("Can not find the TrustRequestor implementation for spec: " + string);
        }
        try {
            Class<?> clazz = Class.forName(string2);
            return (TrustRequestor)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidRequestException("Can not load the impl class: " + string2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidRequestException("Can not access the impl class: " + string2);
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidRequestException("Can not instantiate the impl class: " + string2);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidRequestException(string2 + " must implement the TrustRequestor interface");
        }
    }
}

