/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.framework;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import weblogic.wsee.connection.ConnectionException;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.security.policy12.assertions.TransportBinding;
import weblogic.wsee.security.policy12.assertions.TransportToken;
import weblogic.wsee.security.saml.SAMLUtils;
import weblogic.wsee.security.wst.faults.InvalidRequestException;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.faults.WSTFaultUtil;
import weblogic.wsee.security.wst.framework.TrustRequestor;
import weblogic.wsee.security.wst.framework.TrustRequestorFactory;
import weblogic.wsee.security.wst.framework.TrustToken;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.helpers.SOAPHelper;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.SecurityTokenHelper;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.provider.SecurityToken;

public class TrustSoapClient {
    private static final String TRANSPORT_JMS = "jms";
    private static final String TRANSPORT_HTTPS = "https";
    private static final boolean verbose = Verbose.isVerbose(TrustSoapClient.class);
    private WSTContext wstCtx;
    private TrustRequestor trustRequestor;
    private String transport = "http";
    private String binding = "SOAP11";
    private boolean isWsspEnabled;
    private static final boolean DEBUG = false;

    public TrustSoapClient(WSTContext wSTContext) throws InvalidRequestException {
        this.isWsspEnabled = wSTContext.isWssp();
        this.wstCtx = wSTContext;
        if (this.isSoap12()) {
            this.binding = "SOAP12";
        }
        TrustRequestorFactory trustRequestorFactory = TrustRequestorFactory.getInstance();
        this.trustRequestor = trustRequestorFactory.createTrustRequestor(wSTContext.getTrustVersion());
    }

    private boolean isSoap12() {
        if (this.wstCtx.getSoapVersion() != null) {
            return "http://www.w3.org/2003/05/soap-envelope".equals(this.wstCtx.getSoapVersion());
        }
        return ((SoapMessageContext)this.wstCtx.getMessageContext()).isSoap12();
    }

    public void setTransport(String string) {
        this.transport = string;
    }

    public void setBinding(String string) {
        this.binding = string;
    }

    public SOAPMessage cancelTrustToken(SoapMessageContext soapMessageContext, String string, String string2) throws WSTFaultException {
        TrustToken trustToken = this.generateTrustToken(soapMessageContext, string, string2);
        Node node = this.trustRequestor.cancelRequestSecurityToken(trustToken, this.wstCtx);
        return this.invoke(soapMessageContext, node);
    }

    public SOAPMessage renewTrustToken(SoapMessageContext soapMessageContext, String string, String string2) throws WSTFaultException {
        TrustToken trustToken = this.generateTrustToken(soapMessageContext, string, string2);
        Node node = this.trustRequestor.renewRequestSecurityToken(trustToken, this.wstCtx);
        return this.invoke(soapMessageContext, node);
    }

    public SOAPMessage requestTrustToken() throws WSTFaultException {
        try {
            SoapMessageContext soapMessageContext = SOAPHelper.createEmptyRSTBaseMsgContext(this.isSoap12());
            SOAPHelper.initTrustMsgCtxProperties(this.wstCtx, soapMessageContext);
            this.updateTransport();
            Node node = this.trustRequestor.newRequestSecurityToken(this.wstCtx);
            SOAPMessage sOAPMessage = this.invoke(soapMessageContext, node);
            SOAPHelper.updateCookies(this.wstCtx.getMessageContext(), soapMessageContext);
            return sOAPMessage;
        }
        catch (SOAPException sOAPException) {
            WSTFaultUtil.raiseFault(new InvalidRequestException(sOAPException.getMessage()));
            return null;
        }
    }

    private SOAPMessage invoke(SoapMessageContext soapMessageContext, Node node) {
        try {
            SOAPHelper.createRSTBaseMsgContext(node, this.wstCtx, soapMessageContext);
            if (this.isWsspEnabled) {
                SOAPHelper.invokeWsspHandler(soapMessageContext, this.transport, this.binding, this.wstCtx.getBootstrapPolicy() != null);
            } else {
                SOAPHelper.invokeHandlers(soapMessageContext, this.transport, this.binding);
            }
            return soapMessageContext.getMessage();
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace(System.out);
            WSTFaultUtil.raiseFault(new InvalidRequestException(connectionException.getMessage()));
        }
        catch (SOAPException sOAPException) {
            sOAPException.printStackTrace(System.out);
            WSTFaultUtil.raiseFault(new InvalidRequestException(sOAPException.getMessage()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
            String string = iOException.getMessage();
            if (string.indexOf("unknown protocol: jms") > 0) {
                string = "STS endpoint must be set on the stub when using jms transport";
            }
            WSTFaultUtil.raiseFault(new InvalidRequestException(string));
        }
        return null;
    }

    private void updateTransportFromAppliesTo() {
        String string = this.wstCtx.getAppliesTo();
        if (string != null) {
            if (string.startsWith(TRANSPORT_JMS)) {
                this.setTransport(TRANSPORT_JMS);
            } else if (string.startsWith(TRANSPORT_HTTPS)) {
                this.setTransport(TRANSPORT_HTTPS);
            }
        }
    }

    private boolean updateTransportFromBootstrapPolicy() {
        NormalizedExpression normalizedExpression = this.wstCtx.getBootstrapPolicy();
        if (normalizedExpression != null) {
            TransportBinding transportBinding = (TransportBinding)normalizedExpression.getPolicyAssertion(TransportBinding.class);
            if (transportBinding != null) {
                TransportToken transportToken = transportBinding.getTransportToken();
                if (transportToken != null) {
                    if (transportToken.getHttpsToken() != null) {
                        if (verbose) {
                            Verbose.log(" setting Transport to HTTPS from Bootstrap Policy.");
                        }
                        this.setTransport(TRANSPORT_HTTPS);
                        return true;
                    }
                    if (verbose) {
                        Verbose.log("TransportToken contains NO HTTPS Token");
                    }
                } else if (verbose) {
                    Verbose.log("TransportBinding contains no TransportToken");
                }
            } else if (verbose) {
                Verbose.log("TransportBinding from bootstrap Policy is NULL.");
            }
        } else if (verbose) {
            Verbose.log("bootstrap Policy is NULL.");
        }
        return false;
    }

    private void updateTransport() {
        if (!this.updateTransportFromBootstrapPolicy()) {
            this.updateTransportFromAppliesTo();
            if (verbose) {
                Verbose.log(" set Transport to " + this.transport + " from 'AppliesTo'.");
            }
        }
        if (verbose) {
            Verbose.log(" Bootstrap Transport value is '" + this.transport + "'");
        }
    }

    public SecurityToken generateTrustToken(SoapMessageContext soapMessageContext, NormalizedExpression normalizedExpression, String string) {
        SOAPHelper.initTrustMsgCtxProperties(this.wstCtx, soapMessageContext);
        this.updateTransport();
        SOAPHelper.insertTokenToTrustMessage((MessageContext)soapMessageContext, normalizedExpression);
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(soapMessageContext);
        List list = this.getEquivalentSecurityTokens(wSSecurityContext, string);
        if (list.size() == 1) {
            return (SecurityToken)list.get(0);
        }
        WSTFaultUtil.raiseFault(new InvalidRequestException("Unable to generte Trust Token for token type: " + string));
        return null;
    }

    public TrustToken generateTrustToken(SoapMessageContext soapMessageContext, String string, String string2) {
        SOAPHelper.initTrustMsgCtxProperties(this.wstCtx, soapMessageContext);
        this.updateTransport();
        SOAPHelper.insertTokenToTrustMessage((MessageContext)soapMessageContext, string);
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(soapMessageContext);
        SecurityToken[] securityTokenArray = SecurityTokenHelper.findSecurityTokenByType(wSSecurityContext, string2);
        if (securityTokenArray.length == 1 && securityTokenArray[0] instanceof TrustToken) {
            return (TrustToken)securityTokenArray[0];
        }
        WSTFaultUtil.raiseFault(new InvalidRequestException("Unable to generte Trust Token for token type: " + string2));
        return null;
    }

    private List getEquivalentSecurityTokens(WSSecurityContext wSSecurityContext, String string) {
        ArrayList<SecurityToken> arrayList = new ArrayList<SecurityToken>();
        List list = wSSecurityContext.getSecurityTokens();
        for (SecurityToken securityToken : list) {
            if (!this.isEquivalentTokenType(securityToken.getValueType(), string)) continue;
            arrayList.add(securityToken);
        }
        return arrayList;
    }

    private boolean isEquivalentTokenType(String string, String string2) {
        if (string != null && string.equals(string2)) {
            return true;
        }
        if (this.isSameKindOfX509ValueType(string, string2)) {
            return true;
        }
        return SAMLUtils.isEquivalentSamlTokenType(string, string2);
    }

    private boolean isSameKindOfX509ValueType(String string, String string2) {
        if (null == string || null == string2) {
            return false;
        }
        int n = string.indexOf("#");
        int n2 = string2.indexOf("#");
        if (n == -1 || n2 == -1 || n != n2 || string.length() < n + 6) {
            return false;
        }
        return string.substring(0, n - 1).equals(string2.substring(0, n2 - 1)) && string.indexOf("x509-token") != -1 && "#X509".equals(string.substring(n, n + 5));
    }
}

