/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.framework;

import java.util.concurrent.ConcurrentHashMap;
import weblogic.wsee.security.wst.framework.TrustTokenProvider;
import weblogic.wsee.util.Verbose;

public class TrustTokenProviderRegistry {
    private static final boolean verbose = Verbose.isVerbose(TrustTokenProviderRegistry.class);
    private static TrustTokenProviderRegistry instance = new TrustTokenProviderRegistry();
    private ConcurrentHashMap<String, TrustTokenProvider> providers = new ConcurrentHashMap();

    private TrustTokenProviderRegistry() {
        this.registerProvider("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct", "weblogic.wsee.security.wssc.v13.sct.ServerSCCredentialProvider");
        this.registerProvider("http://schemas.xmlsoap.org/ws/2005/02/sc/sct", "weblogic.wsee.security.wssc.v200502.sct.ServerSCCredentialProvider");
    }

    public static TrustTokenProviderRegistry getInstance() {
        return instance;
    }

    public TrustTokenProvider registerProvider(String string, String string2) throws IllegalArgumentException {
        TrustTokenProvider trustTokenProvider = TrustTokenProviderRegistry.createTrustProvider(string2);
        this.registerProvider(string, trustTokenProvider);
        return trustTokenProvider;
    }

    public void registerProvider(String string, TrustTokenProvider trustTokenProvider) {
        this.providers.put(string, trustTokenProvider);
    }

    public TrustTokenProvider getTrustTokenProvider(String string) {
        if (verbose) {
            Verbose.log("looking up TokenProvider for tokenType='" + string + "'");
        }
        return this.providers.get(string);
    }

    private static final TrustTokenProvider createTrustProvider(String string) throws IllegalArgumentException {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
            return (TrustTokenProvider)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Can not find trust token provider: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Can not access trust token provider: " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Can not instantiate trust token provider: " + string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(string + " is not an instance of TrustTokenProvider");
        }
    }
}

