/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.framework;

import java.io.Serializable;
import java.security.Key;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.security.wst.helpers.TrustTokenHelper;
import weblogic.xml.crypto.wss.provider.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTContext
implements Serializable {
    private static final long serialVersionUID = -7901762602413666059L;
    private static final String WST_CONTEXT_PROP = "weblogic.wsee.security.wst.framework.WSTContext";
    private static final String WST_PREFIX = "wst";
    private static final String WSP_PREFIX = "wsp";
    private static final String WSA_PREFIX = "wsa";
    private static final String WSU_PREFIX = "wsu";
    private String action;
    private String appliesTo = null;
    private String tokenType = null;
    private Element appliesToElement = null;
    private String binarySecretType = null;
    private String context = null;
    private String computedKeyAlgorithm = null;
    private int keySize = 256;
    private long lifetimePeriod = 1800000L;
    private String symmetricKeyAlgorithm = "AES";
    private int symmetricKeyLength = 16;
    private String keyType = null;
    private SecurityToken onBehalfOfToken;
    private Element issuedTokenClaims = null;
    private boolean persistSession = false;
    private Calendar created;
    private Calendar expires;
    private transient MessageContext msgCtx;
    private HashMap<String, String> namespaces = new HashMap();
    private byte[] rstNonce;
    private transient Key symmetricKey = null;
    private String wsaNamespaceUri = null;
    private String wspNamespaceUri = null;
    private String wstNamespaceUri = null;
    private String wsuNamespaceUri = null;
    private boolean isWssp = false;
    private NormalizedExpression bootstrapPolicy = null;
    private NormalizedExpression outerPolicy = null;
    private String trustVersion = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    private String stsUri = null;
    private String endpointUri = null;
    private String soapVersion = null;

    public HashMap<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setContext(String string) {
        this.context = string;
    }

    public String getContext() {
        return this.context;
    }

    public void setAppliesTo(String string) {
        this.appliesTo = string;
    }

    public String getAppliesTo() {
        return this.appliesTo;
    }

    public Element getAppliesToElement() {
        return this.appliesToElement;
    }

    public void setAppliesToElement(Element element) {
        this.appliesToElement = element;
    }

    public void setWstNamespaceURI(String string) {
        this.wstNamespaceUri = string;
        this.namespaces.put(string, WST_PREFIX);
    }

    public String getWstNamespaceURI() {
        return this.wstNamespaceUri;
    }

    public void setWspNamespaceURI(String string) {
        this.wspNamespaceUri = string;
        this.namespaces.put(string, WSP_PREFIX);
    }

    public String getWspNamespaceURI() {
        return this.wspNamespaceUri;
    }

    public void setWsaNamespaceURI(String string) {
        this.wsaNamespaceUri = string;
        this.namespaces.put(string, WSA_PREFIX);
    }

    public String getWsaNamespaceURI() {
        return this.wsaNamespaceUri;
    }

    public void setWsuNamespaceURI(String string) {
        this.wsuNamespaceUri = string;
        this.namespaces.put(string, WSU_PREFIX);
    }

    public String getWsuNamespaceURI() {
        return this.wsuNamespaceUri;
    }

    public void setTokenType(String string) {
        this.tokenType = string;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setComputedKeyAlgorithm(String string) {
        this.computedKeyAlgorithm = string;
    }

    public String getComputedKeyAlgorithm() {
        return this.computedKeyAlgorithm;
    }

    public void setBinarySecretType(String string) {
        this.binarySecretType = string;
    }

    public String getBinarySecretType() {
        return this.binarySecretType;
    }

    public void setSymmetricKeyAlgorithm(String string) {
        this.symmetricKeyAlgorithm = string;
    }

    public String getSymmetricKeyAlgorithm() {
        return this.symmetricKeyAlgorithm;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public String getAction() {
        return this.action;
    }

    public void setSymmetricKeyLength(int n) {
        this.symmetricKeyLength = n;
    }

    public int getSymmetricKeyLength() {
        return this.symmetricKeyLength;
    }

    public void setLifetimePeriod(long l) {
        this.lifetimePeriod = l;
    }

    public long getLifetimePeriod() {
        return this.lifetimePeriod;
    }

    public void setKeySize(int n) {
        this.keySize = n;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setSymmetricKey(Key key) {
        this.symmetricKey = key;
    }

    public Key getSymmetricKey() {
        return this.symmetricKey;
    }

    public void setPersistSession(boolean bl) {
        this.persistSession = bl;
    }

    public boolean isSessionPersisted() {
        return this.persistSession;
    }

    public void setCreated(Calendar calendar) {
        this.created = calendar;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public void setExpires(Calendar calendar) {
        this.expires = calendar;
    }

    public Calendar getExpires() {
        return this.expires;
    }

    public void setRstNonce(byte[] byArray) {
        this.rstNonce = byArray;
    }

    public byte[] getRstNonce() {
        return this.rstNonce;
    }

    public void setMessageContext(MessageContext messageContext) {
        messageContext.setProperty(WST_CONTEXT_PROP, (Object)this);
        this.msgCtx = messageContext;
    }

    public MessageContext getMessageContext() {
        return this.msgCtx;
    }

    public NormalizedExpression getBootstrapPolicy() {
        return this.bootstrapPolicy;
    }

    public void setBootstrapPolicy(NormalizedExpression normalizedExpression) {
        this.bootstrapPolicy = normalizedExpression;
    }

    public void setIssuedTokenClaims(Element element) {
        this.issuedTokenClaims = element;
    }

    public boolean hasIssuedTokenClaims() {
        return this.issuedTokenClaims != null;
    }

    public Element getIssuedTokenClaims() {
        return this.issuedTokenClaims;
    }

    public static WSTContext getWSTContext(MessageContext messageContext) {
        WSTContext wSTContext = (WSTContext)messageContext.getProperty(WST_CONTEXT_PROP);
        if (wSTContext == null) {
            wSTContext = new WSTContext();
            wSTContext.setMessageContext(messageContext);
            Map map = (Map)messageContext.getProperty("weblogic.wsee.invoke_properties");
            if (map != null) {
                map.put(WST_CONTEXT_PROP, wSTContext);
            }
        }
        return wSTContext;
    }

    public void setTrustVersion(String string) {
        this.trustVersion = string;
    }

    public String getTrustVersion() {
        return this.trustVersion;
    }

    public String getStsUri() {
        return this.stsUri;
    }

    public void setStsUri(String string) {
        this.stsUri = string;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String string) {
        this.endpointUri = string;
    }

    public void initEndpoints(MessageContext messageContext) {
        String string = this.getAppliesTo();
        if (string == null) {
            string = (String)messageContext.getProperty("javax.xml.rpc.service.endpoint.address");
            this.setAppliesTo(string);
        }
        this.setEndpointUri(string);
        String string2 = null;
        if (!TrustTokenHelper.isWsscTokenType(this.tokenType)) {
            string2 = (String)messageContext.getProperty("weblogic.wsee.wst.saml.sts_endpoint_uri");
        }
        if (string2 == null) {
            string2 = (String)messageContext.getProperty("weblogic.wsee.wst.sts_endpoint_uri");
        }
        if (string2 == null) {
            string2 = string;
        }
        this.setStsUri(string2);
    }

    public boolean isWssp() {
        return this.isWssp;
    }

    public void setWssp(boolean bl) {
        this.isWssp = bl;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String string) {
        this.keyType = string;
    }

    public SecurityToken getOnBehalfOfToken() {
        return this.onBehalfOfToken;
    }

    public void setOnBehalfOfToken(SecurityToken securityToken) {
        this.onBehalfOfToken = securityToken;
    }

    public NormalizedExpression getOuterPolicy() {
        return this.outerPolicy;
    }

    public void setOuterPolicy(NormalizedExpression normalizedExpression) {
        this.outerPolicy = normalizedExpression;
    }

    public String getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(String string) {
        this.soapVersion = string;
    }
}

