/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.framework;

import java.util.List;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponse;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponseCollection;
import weblogic.wsee.security.wst.faults.InvalidRequestException;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.faults.WSTFaultUtil;
import weblogic.wsee.security.wst.framework.TrustSoapClient;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.helpers.BindingHelper;
import weblogic.wsee.security.wst.helpers.SOAPHelper;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;

public class WSTCredentialProviderHelper {
    private static final boolean verbose = Verbose.isVerbose(WSTCredentialProviderHelper.class);

    public static RequestSecurityTokenResponse createCredential(WSTContext wSTContext, SecurityTokenHandler securityTokenHandler) {
        try {
            return WSTCredentialProviderHelper.createCredential(WSTCredentialProviderHelper.getSoapClient(wSTContext), securityTokenHandler);
        }
        catch (WSTFaultException wSTFaultException) {
            WSTFaultUtil.raiseFault(wSTFaultException);
            return null;
        }
    }

    private static RequestSecurityTokenResponse createCredential(TrustSoapClient trustSoapClient, SecurityTokenHandler securityTokenHandler) throws WSTFaultException {
        SOAPMessage sOAPMessage = trustSoapClient.requestTrustToken();
        RequestSecurityTokenResponse requestSecurityTokenResponse = WSTCredentialProviderHelper.getRSTRfromSOAPMessage(sOAPMessage, securityTokenHandler, null);
        return requestSecurityTokenResponse;
    }

    public static RequestSecurityTokenResponse renewCredential(WSTContext wSTContext, Object object, SecurityTokenHandler securityTokenHandler, String string, String string2, String string3) {
        try {
            wSTContext.setAction(string3);
            SoapMessageContext soapMessageContext = SOAPHelper.createEmptyRSTBaseMsgContext(((SoapMessageContext)wSTContext.getMessageContext()).isSoap12());
            soapMessageContext.setProperty("weblogic.wsee.wssc.sct", object);
            SOAPMessage sOAPMessage = WSTCredentialProviderHelper.getSoapClient(wSTContext).renewTrustToken(soapMessageContext, string2, string);
            RequestSecurityTokenResponse requestSecurityTokenResponse = WSTCredentialProviderHelper.getRSTRfromSOAPMessage(sOAPMessage, securityTokenHandler, string);
            return requestSecurityTokenResponse;
        }
        catch (InvalidRequestException invalidRequestException) {
            WSTFaultUtil.raiseFault(invalidRequestException);
        }
        catch (WSTFaultException wSTFaultException) {
            WSTFaultUtil.raiseFault(wSTFaultException);
        }
        catch (SOAPException sOAPException) {
            WSTFaultUtil.raiseFault(new InvalidRequestException(sOAPException.getMessage()));
        }
        return null;
    }

    public static void cancelCredential(MessageContext messageContext, Object object, SecurityTokenHandler securityTokenHandler, String string, String string2, String string3) {
        if (object == null) {
            WSTFaultUtil.raiseFault(new InvalidRequestException("No credential to cancel token"));
        }
        WSTContext wSTContext = WSTContext.getWSTContext(messageContext);
        wSTContext.setAction(string3);
        try {
            SoapMessageContext soapMessageContext = SOAPHelper.createEmptyRSTBaseMsgContext(((SoapMessageContext)messageContext).isSoap12());
            soapMessageContext.setProperty("weblogic.wsee.wssc.sct", object);
            SOAPMessage sOAPMessage = WSTCredentialProviderHelper.getSoapClient(wSTContext).cancelTrustToken(soapMessageContext, string2, string);
            RequestSecurityTokenResponse requestSecurityTokenResponse = WSTCredentialProviderHelper.getRSTRfromSOAPMessage(sOAPMessage, securityTokenHandler, string);
            if (requestSecurityTokenResponse != null && requestSecurityTokenResponse.getRequestedTokenCancelled() != null) {
                return;
            }
            WSTFaultUtil.raiseFault(new InvalidRequestException("Unable to cancel token"));
        }
        catch (WSTFaultException wSTFaultException) {
            WSTFaultUtil.raiseFault(wSTFaultException);
        }
        catch (SOAPException sOAPException) {
            WSTFaultUtil.raiseFault(new InvalidRequestException(sOAPException.getMessage()));
        }
    }

    private static RequestSecurityTokenResponse getRSTRfromSOAPMessage(SOAPMessage sOAPMessage, SecurityTokenHandler securityTokenHandler, String string) throws WSTFaultException {
        Node node = SOAPHelper.getRSTBaseNode(sOAPMessage);
        if (node == null) {
            return null;
        }
        RequestSecurityTokenResponse requestSecurityTokenResponse = null;
        if (node.getLocalName().equals("RequestSecurityTokenResponseCollection")) {
            RequestSecurityTokenResponseCollection requestSecurityTokenResponseCollection = BindingHelper.unmarshalRSTRCNode(node, securityTokenHandler, string);
            List<RequestSecurityTokenResponse> list = requestSecurityTokenResponseCollection.getRequestSecurityTokenResponseCollection();
            if (list.size() <= 0) {
                throw new WSTFaultException(" SecureTokenService did not return a token in the returned RequestSecurityTokenResponseCollection ");
            }
            requestSecurityTokenResponse = list.get(0);
            return requestSecurityTokenResponse;
        }
        requestSecurityTokenResponse = BindingHelper.unmarshalRSTRNode(node, securityTokenHandler, string);
        return requestSecurityTokenResponse;
    }

    private static TrustSoapClient getSoapClient(WSTContext wSTContext) throws InvalidRequestException {
        TrustSoapClient trustSoapClient = new TrustSoapClient(wSTContext);
        return trustSoapClient;
    }

    private static String getSTSURIFromMBean(MessageContext messageContext, String string) {
        String string2 = null;
        WssPolicyContext wssPolicyContext = (WssPolicyContext)messageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
        if (wssPolicyContext != null && (string2 = wssPolicyContext.getWssConfiguration().getSTSURI(string)) == null) {
            string2 = wssPolicyContext.getWssConfiguration().getDefaultSTSURI();
        }
        return string2;
    }

    public static String getSTSURIFromConfig(SecurityTokenContextHandler securityTokenContextHandler, MessageContext messageContext, String string) {
        String string2 = (String)securityTokenContextHandler.getValue("weblogic.wsee.security.issuer_endpoint_ref");
        if (string2 == null) {
            string2 = WSTCredentialProviderHelper.getSTSURIFromMBean(messageContext, string);
        }
        return string2;
    }

    private static String getSTSPolicyFromMBean(MessageContext messageContext, String string) {
        String string2 = null;
        WssPolicyContext wssPolicyContext = (WssPolicyContext)messageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
        if (wssPolicyContext != null) {
            string2 = wssPolicyContext.getWssConfiguration().getSTSPolicy(string);
        }
        return string2;
    }

    public static NormalizedExpression getSTSPolicyFromConfig(SecurityTokenContextHandler securityTokenContextHandler, MessageContext messageContext, String string) throws PolicyException {
        WssPolicyContext wssPolicyContext;
        NormalizedExpression normalizedExpression = null;
        String string2 = null;
        if (securityTokenContextHandler != null) {
            normalizedExpression = (NormalizedExpression)securityTokenContextHandler.getValue("weblogic.wsee.security.wst_bootstrap_policy");
        }
        if (normalizedExpression == null) {
            string2 = WSTCredentialProviderHelper.getSTSPolicyFromMBean(messageContext, string);
        }
        if ((wssPolicyContext = (WssPolicyContext)messageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx")) != null && string2 != null) {
            normalizedExpression = wssPolicyContext.getPolicyServer().getPolicy(string2).normalize();
        }
        return normalizedExpression;
    }
}

