/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.framework.async;

import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.binding.BindingImpl;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Holder;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.security.wst.framework.async.AsyncTrustClientHelper;
import weblogic.wsee.util.EndpointAddressUtil;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss11.internal.WSS11Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncTrustClient {
    public static void process(MessageContext messageContext, String string, String string2, boolean bl) {
        try {
            try {
                AsyncTrustClient._process(messageContext, string, string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new WebServiceException((Throwable)malformedURLException);
            }
            catch (InterruptedException interruptedException) {
                throw new WebServiceException((Throwable)interruptedException);
            }
            catch (IOException iOException) {
                throw new WebServiceException((Throwable)iOException);
            }
            catch (ExecutionException executionException) {
                if (executionException.getCause() != null) {
                    throw new WebServiceException(executionException.getCause());
                }
                throw new WebServiceException((Throwable)executionException);
            }
            catch (WebServiceException webServiceException) {
                throw webServiceException;
            }
            catch (Throwable throwable) {
                throw new WebServiceException(throwable);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            PolicyContext.setPolicyIgnored(false);
            throw throwable;
        }
        PolicyContext.setPolicyIgnored(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _process(MessageContext messageContext, String string, String string2) throws InterruptedException, ExecutionException, IOException {
        String string3;
        Object object;
        String string4;
        WsdlPort wsdlPort = AsyncTrustClientHelper.getWsdlPort(messageContext);
        QName qName = wsdlPort.getName();
        WSService wSService = AsyncTrustClientHelper.getWSService(messageContext);
        boolean bl = false;
        Dispatch dispatch = null;
        if (AsyncTrustClientHelper.isAsyncClientTransportFeatureEnabled(messageContext)) {
            string4 = AsyncTrustClientHelper.getAsyncClientTransportFeatureOnTrust(messageContext, string);
            bl = string4 == AsyncTrustClientHelper.getAsyncWebServiceFeature(messageContext);
            ((AsyncClientTransportFeature)string4).addAsyncEndpointListener(new AsyncClientTransportFeature.AsyncEndpointListener(){

                public void endpointSet(AsyncClientTransportFeature asyncClientTransportFeature) {
                    Collections.addAll(((BindingImpl)asyncClientTransportFeature.getEndpoint().getBinding()).getKnownHeaders(), WSSConstants.SECURITY_QNAME, WSS11Constants.ENC_HEADER_QNAME);
                }

                public void endpointPublished(AsyncClientTransportFeature asyncClientTransportFeature) {
                }

                public void endpointDisposed(AsyncClientTransportFeature asyncClientTransportFeature) {
                }
            });
            dispatch = wSService.createDispatch(qName, SOAPMessage.class, Service.Mode.MESSAGE, new WebServiceFeature[]{string4});
            object = messageContext.getPropertyNames();
            while (object.hasNext()) {
                string3 = (String)object.next();
                dispatch.getRequestContext().put(string3, messageContext.getProperty(string3));
            }
        }
        string4 = EndpointAddressUtil.getEndpointAddress(messageContext);
        if (string != null && !string.equals("") && string4 != null && !string4.equals("") && !EndpointAddressUtil.getProtocolFromEndpointAddress(string4).equals(string) && string.equals("https")) {
            throw new MalformedURLException("Policy on STS endpoint requires " + string + " transport, but the endpoint address url of STS specified on client side doesn't comply with it :" + string4);
        }
        dispatch.getRequestContext().put("javax.xml.ws.service.endpoint.address", string4);
        object = (String)messageContext.getProperty("weblogic.wsee.addressing.Action");
        dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", object);
        Collections.addAll(((BindingImpl)dispatch.getBinding()).getKnownHeaders(), WSSConstants.SECURITY_QNAME, WSS11Constants.ENC_HEADER_QNAME);
        try {
            string3 = ((SOAPMessageContext)messageContext).getMessage();
            SOAPMessage sOAPMessage = AsyncTrustClient.invokeAsync((SOAPMessage)string3, (Dispatch<SOAPMessage>)dispatch);
            AsyncTrustClientHelper.setupCookies(messageContext, sOAPMessage.getMimeHeaders());
            ((SOAPMessageContext)messageContext).setMessage(sOAPMessage);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (!bl && dispatch instanceof Closeable) {
                ((Closeable)dispatch).close();
            }
            throw throwable;
        }
        if (!bl && dispatch instanceof Closeable) {
            ((Closeable)dispatch).close();
        }
    }

    private static SOAPMessage invokeAsync(SOAPMessage sOAPMessage, Dispatch<SOAPMessage> dispatch) throws InterruptedException, ExecutionException {
        final Holder holder = new Holder();
        final Semaphore semaphore = new Semaphore(0);
        dispatch.invokeAsync((Object)sOAPMessage, (AsyncHandler)new AsyncHandler<SOAPMessage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleResponse(Response<SOAPMessage> response) {
                try {
                    try {
                        holder.value = response.get();
                    }
                    catch (Throwable throwable) {
                        holder.value = throwable;
                        Object var4_3 = null;
                        semaphore.release();
                    }
                    Object var4_2 = null;
                    semaphore.release();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    semaphore.release();
                    throw throwable;
                }
            }
        });
        if (semaphore.tryAcquire(1L, TimeUnit.HOURS)) {
            if (holder.value instanceof SOAPMessage) {
                return (SOAPMessage)holder.value;
            }
            if (holder.value instanceof InterruptedException) {
                throw (InterruptedException)holder.value;
            }
            if (holder.value instanceof ExecutionException) {
                throw (ExecutionException)holder.value;
            }
            throw new WebServiceException((Throwable)holder.value);
        }
        throw new WebServiceException("Asynchronous trust client can not get asynchronous response within a given waiting time.");
    }
}

