/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.framework.async;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.MimeHeaders;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StringUtils;
import weblogic.wsee.mc.api.McFeature;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.util.EndpointAddressUtil;
import weblogic.wsee.wsdl.WsdlPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncTrustClientHelper {
    public static boolean isAsyncTrustRequired(MessageContext messageContext) {
        String string = (String)messageContext.getProperty("weblogic.wsee.security.wst.enforceAsyncTrustExchange");
        String string2 = (String)messageContext.getProperty("weblogic.wsee.security.wst.originalTargetEndpointAddress");
        String string3 = (String)messageContext.getProperty("javax.xml.rpc.service.endpoint.address");
        if (string2 != null && string3 != null) {
            int n = string2.indexOf(58);
            if (n > -1) {
                string2 = string2.substring(n);
            }
            if ((n = string3.indexOf(58)) > -1) {
                string3 = string3.substring(n);
            }
            if (!string2.equals(string3) && !"true".equalsIgnoreCase(string)) {
                return false;
            }
        }
        return AsyncTrustClientHelper.isJAXWS(messageContext) && AsyncTrustClientHelper.isAsyncClientTransportFeatureEnabled(messageContext);
    }

    public static boolean isAsyncClientTransportFeatureEnabled(MessageContext messageContext) {
        return (WebServiceFeature)messageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.ASYNC_CLIENT_FEATURE") instanceof AsyncClientTransportFeature;
    }

    public static boolean isMcFeatureEnabled(MessageContext messageContext) {
        return (WebServiceFeature)messageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.ASYNC_CLIENT_FEATURE") instanceof McFeature;
    }

    public static WebServiceFeature getAsyncWebServiceFeature(MessageContext messageContext) {
        return (WebServiceFeature)messageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.ASYNC_CLIENT_FEATURE");
    }

    public static boolean isJAXWS(MessageContext messageContext) {
        return "true".equalsIgnoreCase((String)messageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.JAX_WS_RUNTIME"));
    }

    public static WsdlPort getWsdlPort(MessageContext messageContext) {
        try {
            WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
            return wlMessageContext.getDispatcher().getWsdlPort();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static WSService getWSService(MessageContext messageContext) {
        return (WSService)messageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.SERVICE");
    }

    public static String getBindingID(String string, String string2) {
        if ("http".equals(string) || "https".equals(string)) {
            if ("SOAP11".equals(string2)) {
                return "http://schemas.xmlsoap.org/wsdl/soap/http";
            }
            if ("SOAP12".equals(string)) {
                return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
            }
        }
        return null;
    }

    public static AsyncClientTransportFeature getAsyncClientTransportFeatureOnTrust(MessageContext messageContext, String string) throws MalformedURLException {
        Endpoint endpoint;
        AsyncClientTransportFeature asyncClientTransportFeature = (AsyncClientTransportFeature)AsyncTrustClientHelper.getAsyncWebServiceFeature(messageContext);
        WSBinding wSBinding = (WSBinding)(endpoint = asyncClientTransportFeature.getEndpoint()).getBinding();
        boolean bl = wSBinding.isFeatureEnabled(MemberSubmissionAddressingFeature.class);
        Class clazz = bl ? MemberSubmissionEndpointReference.class : W3CEndpointReference.class;
        EndpointReference endpointReference = endpoint.getEndpointReference(clazz, new Element[0]);
        String string2 = new WSEndpointReference(endpointReference).getAddress();
        if (string2 != null && !string2.equals("") && string != null && !string.equals("") && !EndpointAddressUtil.getProtocolFromEndpointAddress(string2).equals(string) && string.equals("https")) {
            if (KernelStatus.isServer()) {
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                ServerMBean serverMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServer();
                String string3 = serverMBean.getListenAddress();
                SSLMBean sSLMBean = serverMBean.getSSL();
                int n = sSLMBean.getListenPort();
                String string4 = string2.substring(string2.indexOf(47, string2.indexOf("://") + 3));
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string).append("://").append(string3).append(":").append(n).append(string4);
                string2 = stringBuffer.toString();
                String string5 = UUID.randomUUID().toString();
                string2 = string2.endsWith("/") || string2.endsWith("\\") ? string2 + "TrustCallbackService-" + string5 : string2 + "/TrustCallbackService-" + string5;
                return new AsyncClientTransportFeature(string2);
            }
            throw new MalformedURLException("Policy on STS endpoint requires " + string + " transport, but the endpoint address url of async callback service specified on client side doesn't comply with it :" + string2);
        }
        return asyncClientTransportFeature;
    }

    public static void setupCookies(MessageContext messageContext, MimeHeaders mimeHeaders) {
        if (messageContext.getProperty("weblogic.wsee.transport.headers") != null) {
            messageContext.setProperty("weblogic.wsee.transport.headers", (Object)mimeHeaders);
        }
        AsyncTrustClientHelper.setSessionCookies(messageContext, mimeHeaders);
    }

    private static void setSessionCookies(MessageContext messageContext, MimeHeaders mimeHeaders) {
        Object object = messageContext.getProperty("javax.xml.rpc.session.maintain");
        if (object != null) {
            if (object instanceof Boolean) {
                String[] stringArray;
                if (((Boolean)object).booleanValue() && (stringArray = mimeHeaders.getHeader("Set-Cookie")) != null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (String string : stringArray) {
                        AsyncTrustClientHelper.addCookies(AsyncTrustClientHelper.cleanupCookie(string), hashMap);
                    }
                    boolean bl = !hashMap.isEmpty();
                    MimeHeaders mimeHeaders2 = AsyncTrustClientHelper.mergeMimeHeaderCookies(hashMap, messageContext);
                    if (!hashMap.isEmpty() || bl) {
                        for (String string : hashMap.keySet()) {
                            String string2 = (String)hashMap.get(string);
                            mimeHeaders2.addHeader("Cookie", string + "=" + string2);
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException("Value of javax.xml.rpc.session.maintain must be java.lang.Boolean");
            }
        }
    }

    private static void addCookies(String string, Map<String, String> map) {
        String[] stringArray;
        for (String string2 : stringArray = StringUtils.splitCompletely((String)string, (String)";")) {
            int n = string2.indexOf("=");
            if (n == -1 || n >= string2.length() - 1) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1, string2.length()).trim();
            map.put(string3, string4);
        }
    }

    private static String cleanupCookie(String string) {
        int n = (string = string.trim()).indexOf(59);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static MimeHeaders mergeMimeHeaderCookies(Map<String, String> map, MessageContext messageContext) {
        MimeHeaders mimeHeaders;
        HashMap<String, MimeHeaders> hashMap = (HashMap<String, MimeHeaders>)messageContext.getProperty("weblogic.wsee.invoke_properties");
        if (hashMap == null) {
            hashMap = new HashMap<String, MimeHeaders>();
            messageContext.setProperty("weblogic.wsee.invoke_properties", hashMap);
        }
        if ((mimeHeaders = (MimeHeaders)hashMap.get("weblogic.wsee.transport.headers")) == null) {
            mimeHeaders = new MimeHeaders();
            hashMap.put("weblogic.wsee.transport.headers", mimeHeaders);
        } else {
            String[] stringArray = mimeHeaders.getHeader("Cookie");
            if (stringArray != null) {
                for (String string : stringArray) {
                    AsyncTrustClientHelper.addCookies(string, map);
                }
                mimeHeaders.removeHeader("Cookie");
            }
        }
        return mimeHeaders;
    }
}

