/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.helpers;

import java.security.Key;
import java.security.SecureRandom;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.security.wst.binding.BinarySecret;
import weblogic.wsee.security.wst.binding.Entropy;
import weblogic.wsee.security.wst.binding.RSTBase;
import weblogic.wsee.security.wst.binding.RequestSecurityToken;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponse;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponseCollection;
import weblogic.wsee.security.wst.binding.TokenType;
import weblogic.wsee.security.wst.faults.InvalidRequestException;
import weblogic.wsee.security.wst.faults.RequestFailedException;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.KeyUtils;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.dom.marshal.MarshalException;

public class BindingHelper {
    private static final SecureRandom rand = new SecureRandom();
    private static final String DUMMY_NODE = "DummyROOT";

    public static RequestSecurityTokenResponse unmarshalRSTRNode(Node node, SecurityTokenHandler securityTokenHandler) throws InvalidRequestException {
        List<RequestSecurityTokenResponse> list;
        RequestSecurityTokenResponseCollection requestSecurityTokenResponseCollection;
        if ("RequestSecurityTokenResponse".equals(node.getLocalName())) {
            return BindingHelper.unmarshalRSTRNode(node, securityTokenHandler, null);
        }
        if ("RequestSecurityTokenResponseCollection".equals(node.getLocalName()) && (requestSecurityTokenResponseCollection = BindingHelper.unmarshalRSTRCNode(node, securityTokenHandler, null)) != null && !(list = requestSecurityTokenResponseCollection.getRequestSecurityTokenResponseCollection()).isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static RequestSecurityTokenResponse unmarshalFromRSTRorRSTRCNode(Node node, SecurityTokenHandler securityTokenHandler, String string) throws InvalidRequestException {
        List<RequestSecurityTokenResponse> list;
        RequestSecurityTokenResponseCollection requestSecurityTokenResponseCollection;
        if ("RequestSecurityTokenResponse".equals(node.getLocalName())) {
            return BindingHelper.unmarshalRSTRNode(node, securityTokenHandler, string);
        }
        if ("RequestSecurityTokenResponseCollection".equals(node.getLocalName()) && (requestSecurityTokenResponseCollection = BindingHelper.unmarshalRSTRCNode(node, securityTokenHandler, string)) != null && !(list = requestSecurityTokenResponseCollection.getRequestSecurityTokenResponseCollection()).isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static RequestSecurityTokenResponse unmarshalRSTRNode(Node node, SecurityTokenHandler securityTokenHandler, String string) throws InvalidRequestException {
        RequestSecurityTokenResponse requestSecurityTokenResponse = new RequestSecurityTokenResponse();
        requestSecurityTokenResponse.setTokenHandler(securityTokenHandler);
        if (string != null) {
            requestSecurityTokenResponse.setTokenType(new TokenType(string));
        }
        try {
            requestSecurityTokenResponse.unmarshal(node);
        }
        catch (MarshalException marshalException) {
            throw new InvalidRequestException(marshalException.getMessage());
        }
        return requestSecurityTokenResponse;
    }

    public static RequestSecurityTokenResponseCollection unmarshalRSTRCNode(Node node, SecurityTokenHandler securityTokenHandler) throws InvalidRequestException {
        return BindingHelper.unmarshalRSTRCNode(node, securityTokenHandler, null);
    }

    public static RequestSecurityTokenResponseCollection unmarshalRSTRCNode(Node node, SecurityTokenHandler securityTokenHandler, String string) throws InvalidRequestException {
        RequestSecurityTokenResponseCollection requestSecurityTokenResponseCollection = new RequestSecurityTokenResponseCollection();
        requestSecurityTokenResponseCollection.setTokenHandler(securityTokenHandler);
        if (string != null) {
            requestSecurityTokenResponseCollection.setTokenType(new TokenType(string));
        }
        try {
            requestSecurityTokenResponseCollection.unmarshal(node);
        }
        catch (MarshalException marshalException) {
            throw new InvalidRequestException(marshalException.getMessage());
        }
        return requestSecurityTokenResponseCollection;
    }

    public static RequestSecurityToken unmarshalRSTNode(Node node, SecurityTokenHandler securityTokenHandler) throws InvalidRequestException {
        RequestSecurityToken requestSecurityToken = new RequestSecurityToken();
        requestSecurityToken.setTokenHandler(securityTokenHandler);
        try {
            requestSecurityToken.unmarshal(node);
        }
        catch (MarshalException marshalException) {
            throw new InvalidRequestException(marshalException.getMessage());
        }
        return requestSecurityToken;
    }

    public static RequestSecurityToken unmarshalRSTNode(Node node) throws InvalidRequestException {
        return BindingHelper.unmarshalRSTNode(node, null);
    }

    public static Node marshalRST(RSTBase rSTBase, WSTContext wSTContext) throws RequestFailedException {
        Element element = BindingHelper.createDummyRootNode();
        try {
            rSTBase.marshal(element, null, wSTContext.getNamespaces());
        }
        catch (MarshalException marshalException) {
            throw new RequestFailedException("unable to marshal RSTR: " + marshalException.getMessage());
        }
        return DOMUtils.getFirstElement(element);
    }

    public static RequestSecurityTokenResponseCollection createEmptyRSTRC(WSTContext wSTContext) {
        String string = wSTContext.getWstNamespaceURI();
        RequestSecurityTokenResponseCollection requestSecurityTokenResponseCollection = new RequestSecurityTokenResponseCollection(string);
        return requestSecurityTokenResponseCollection;
    }

    public static BinarySecret createBinarySecret(String string, String string2, byte[] byArray) {
        BinarySecret binarySecret = new BinarySecret(string);
        binarySecret.setType(string2);
        binarySecret.setValue(KeyUtils.createNonce());
        return binarySecret;
    }

    public static BinarySecret createBinarySecret(String string, Key key, String string2) {
        BinarySecret binarySecret = new BinarySecret(string);
        binarySecret.setType(string2);
        binarySecret.setValue(key.getEncoded());
        return binarySecret;
    }

    public static final Entropy createNewEntropy(String string, String string2) {
        Entropy entropy = new Entropy(string);
        BinarySecret binarySecret = BindingHelper.createBinarySecret(string, string2, KeyUtils.createNonce());
        entropy.setBinarySecret(binarySecret);
        return entropy;
    }

    public static final Entropy createNewEntropy(String string, Key key, String string2) {
        Entropy entropy = new Entropy(string);
        BinarySecret binarySecret = BindingHelper.createBinarySecret(string, key, string2);
        entropy.setBinarySecret(binarySecret);
        return entropy;
    }

    private static Element createDummyRootNode() {
        return BindingHelper.getParser().newDocument().createElement(DUMMY_NODE);
    }

    private static DocumentBuilder getParser() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new AssertionError((Object)factoryConfigurationError);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AssertionError((Object)parserConfigurationException);
        }
    }
}

