/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.helpers;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import weblogic.wsee.security.bst.BSTCredentialProvider;
import weblogic.wsee.security.bst.ClientBSTCredentialProvider;
import weblogic.wsee.security.bst.StubPropertyBSTCredProv;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.WrapperCredentialProvider;
import weblogic.xml.crypto.wss.provider.CredentialProvider;

public class CredentialProviderHelper {
    private static final boolean verbose = Verbose.isVerbose(CredentialProviderHelper.class);

    public static List replaceCredentialProviderWithNewCert(List list, X509Certificate x509Certificate) {
        if (null == x509Certificate || null == list || list.isEmpty()) {
            return list;
        }
        if (verbose) {
            Verbose.say("Replace source of  server cert is:" + x509Certificate.toString());
        }
        ArrayList<BSTCredentialProvider> arrayList = new ArrayList<BSTCredentialProvider>();
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            CredentialProvider credentialProvider;
            CredentialProvider credentialProvider2 = null;
            Object e = list.get(i);
            if (e instanceof ClientBSTCredentialProvider) {
                if (verbose) {
                    Verbose.say("Replace ClientBSTCredentialProvider with this server cert ");
                }
                credentialProvider = (ClientBSTCredentialProvider)e;
                credentialProvider2 = ((ClientBSTCredentialProvider)credentialProvider).cloneAndReplaceServerCert(x509Certificate);
                if (verbose) {
                    Verbose.say("Replace ClientBSTCredentialProvider with this server cert ");
                }
            } else if (e instanceof WrapperCredentialProvider) {
                credentialProvider = (WrapperCredentialProvider)e;
                if (((WrapperCredentialProvider)credentialProvider).hasClientBSTCredentialProvider() || ((WrapperCredentialProvider)credentialProvider).hasStubPropertyBSTCredProv()) {
                    credentialProvider2 = ((WrapperCredentialProvider)credentialProvider).replaceServerCertOnClientBSTCredentialProvider(x509Certificate);
                    if (verbose) {
                        Verbose.say("Replace ClientBSTCredentialProvider in WrapperCredentialProvider with this server cert ");
                    }
                }
            } else if (e instanceof StubPropertyBSTCredProv) {
                credentialProvider = (StubPropertyBSTCredProv)e;
                credentialProvider2 = ((StubPropertyBSTCredProv)credentialProvider).cloneAndReplaceServerCert(x509Certificate);
            }
            if (null != credentialProvider2) {
                arrayList.add((BSTCredentialProvider)credentialProvider2);
                bl = true;
                continue;
            }
            arrayList.add((BSTCredentialProvider)e);
        }
        if (!bl) {
            arrayList.add(new StubPropertyBSTCredProv(x509Certificate, null));
        }
        if (verbose) {
            Verbose.say("New Credential Provider List is returned witth size = " + arrayList.size() + " that replaced the old list size = " + list.size());
        }
        return arrayList;
    }
}

