/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.helpers;

import com.sun.xml.ws.util.DOMUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.security.saml.SAMLCredential;
import weblogic.wsee.security.wss.plan.helper.SOAPSecurityHeaderHelper;
import weblogic.wsee.security.wst.faults.InvalidRequestException;
import weblogic.wsee.security.wst.faults.WSTFaultUtil;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.helpers.SOAPHelper;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.common.keyinfo.EncryptedKeyProvider;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionFactory;
import weblogic.xml.crypto.encrypt.api.dom.DOMDecryptContext;
import weblogic.xml.crypto.encrypt.api.keyinfo.EncryptedKey;
import weblogic.xml.crypto.wss.SecurityImpl;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss11.internal.STRType;
import weblogic.xml.crypto.wss11.internal.SecurityBuilderImpl;
import weblogic.xml.crypto.wss11.internal.WSS11Context;
import weblogic.xml.crypto.wss11.internal.enckey.EncryptedKeyToken;

public class EncryptedKeyInfoBuilder {
    private static final boolean verbose = Verbose.isVerbose(EncryptedKeyInfoBuilder.class);
    private static final boolean DEBUG = false;
    private WSS11Context securityCtx = null;
    private SecurityTokenContextHandler ctxHandler;
    private Element soapHeader = null;
    protected SecurityBuilderImpl securityBuilder = null;

    public EncryptedKeyInfoBuilder(WSSecurityContext wSSecurityContext, CredentialProvider credentialProvider) {
        this.createWSSecurityContext(wSSecurityContext, credentialProvider);
        this.ctxHandler = new SecurityTokenContextHandler(this.securityCtx);
        this.securityBuilder = new SecurityBuilderImpl(this.securityCtx);
    }

    private void createWSSecurityContext(WSSecurityContext wSSecurityContext, CredentialProvider credentialProvider) {
        try {
            SoapMessageContext soapMessageContext = SOAPHelper.createEmptyRSTBaseMsgContext(true);
            this.soapHeader = soapMessageContext.getMessage().getSOAPHeader();
            this.securityCtx = new WSS11Context(this.soapHeader, null, null, null);
            EncryptedKeyInfoBuilder.transferCredntialProviders(wSSecurityContext, this.securityCtx);
            if (null != credentialProvider) {
                if (verbose) {
                    Verbose.log("setting CredentialProvider =" + credentialProvider.toString());
                }
                this.securityCtx.addCredentialProvider(credentialProvider);
            }
        }
        catch (SOAPException sOAPException) {
            WSTFaultUtil.raiseFault(new InvalidRequestException("Failed to create WSSecurityContext in trust for building EncryptedKey element."));
        }
    }

    private static void transferCredntialProviders(WSSecurityContext wSSecurityContext, WSS11Context wSS11Context) {
        Map map = wSSecurityContext.getCredentialProviders();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            wSS11Context.setCredentialProvider((CredentialProvider)iterator.next());
        }
    }

    private static EncryptionMethod getEncryptionMethod(String string) throws XMLEncryptionException, InvalidAlgorithmParameterException {
        XMLEncryptionFactory xMLEncryptionFactory = XMLEncryptionFactory.getInstance();
        return xMLEncryptionFactory.newEncryptionMethod(string, null, null);
    }

    private static List getSTRTypes(QName qName, String string) {
        ArrayList<STRType> arrayList = new ArrayList<STRType>();
        arrayList.add(new STRType(qName, string));
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node getEncryptedKeyNode(WSTContext wSTContext) throws WSSecurityException {
        Node node;
        block12: {
            Node node2;
            block11: {
                try {
                    try {
                        boolean bl;
                        String string;
                        List list;
                        String string2;
                        EncryptionMethod encryptionMethod;
                        EncryptionMethod encryptionMethod2;
                        Key key;
                        if (verbose) {
                            Verbose.log("Getting Encrypted Key Node for SAML Issued Token .........");
                        }
                        if (null == (key = this.securityBuilder.getEncryptedKeyToken(encryptionMethod2 = EncryptedKeyInfoBuilder.getEncryptionMethod("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"), encryptionMethod = EncryptedKeyInfoBuilder.getEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes256-cbc"), string2 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", list = EncryptedKeyInfoBuilder.getSTRTypes(WSSConstants.KEY_IDENTIFIER_QNAME, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1"), string = null, bl = true, this.ctxHandler))) {
                            if (verbose) {
                                Verbose.log("Unable to get EncryptedKey for tokenType =" + string2);
                            }
                            Node node3 = null;
                            Object var12_13 = null;
                            this.securityCtx = null;
                            this.securityBuilder = null;
                            this.soapHeader = null;
                            this.ctxHandler = null;
                            return node3;
                        }
                        EncryptedKeyToken encryptedKeyToken = (EncryptedKeyToken)this.securityCtx.getSecurityTokens("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey").get(0);
                        if (null == encryptedKeyToken) {
                            if (verbose) {
                                Verbose.log("Unable to build EncryptedKeyToken for tokenType =http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                            }
                            node2 = null;
                            break block11;
                        }
                        wSTContext.setSymmetricKey(key);
                        EncryptedKeyInfoBuilder.debugKey(key, "Created symmetricKey from EncryptedKey for wstCtx ");
                        node = this.buildEncryptedKeyInfoNode();
                        break block12;
                    }
                    catch (WSSecurityException wSSecurityException) {
                        throw wSSecurityException;
                    }
                    catch (Exception exception) {
                        throw new WSSecurityException(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    this.securityCtx = null;
                    this.securityBuilder = null;
                    this.soapHeader = null;
                    this.ctxHandler = null;
                    throw throwable;
                }
            }
            Object var12_14 = null;
            this.securityCtx = null;
            this.securityBuilder = null;
            this.soapHeader = null;
            this.ctxHandler = null;
            return node2;
        }
        Object var12_15 = null;
        this.securityCtx = null;
        this.securityBuilder = null;
        this.soapHeader = null;
        this.ctxHandler = null;
        return node;
    }

    public static void debugKey(Key key, String string) {
        if (verbose) {
            if (key == null) {
                Verbose.log(string + " key is null");
                return;
            }
            Verbose.log("Key for " + string + " Algo =" + key.getAlgorithm() + " Format = " + key.getFormat());
        }
    }

    private Node buildEncryptedKeyInfoNode() throws Exception {
        Element element = SOAPSecurityHeaderHelper.getFirstChildElement(this.soapHeader, SecurityImpl.ENCRYPTED_KEY_QNAME);
        Element element2 = DOMUtil.createDom().createElementNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        element2.setPrefix("sig");
        if (null != element) {
            element2.appendChild(element2.getOwnerDocument().importNode(element, true));
        } else if (verbose) {
            Verbose.log("Unable to find EncryptedKey element!!!!!");
        }
        return element2;
    }

    public static void processEncryptedKey(SAMLCredential sAMLCredential, MessageContext messageContext) throws WSSecurityException, MarshalException {
        if (null == sAMLCredential || null == messageContext) {
            throw new IllegalArgumentException("Null SAMLCredential = " + (null == sAMLCredential) + " MessageContext msgCtx = null  is " + (null == messageContext));
        }
        Element element = sAMLCredential.getEncryptedKey();
        WSSecurityContext wSSecurityContext = (WSSecurityContext)messageContext.getProperty("weblogic.xml.crypto.wss.WSSecurityContext");
        if (null == element || null == wSSecurityContext) {
            throw new IllegalArgumentException("Null EncryptedKey element = " + (null == element) + " WSSecurityContext securityCtx = null  " + (null == wSSecurityContext));
        }
        if (verbose) {
            Verbose.log("Processing EncryptedKey element to get EncryptedKeyProvider ");
        }
        KeySelector keySelector = wSSecurityContext.getKeySelector();
        DOMDecryptContext dOMDecryptContext = new DOMDecryptContext(keySelector, element);
        dOMDecryptContext.setProperty("javax.xml.rpc.handler.MessageContext", messageContext);
        dOMDecryptContext.setProperty("weblogic.xml.crypto.wss.WSSecurityContext", wSSecurityContext);
        XMLEncryptionFactory xMLEncryptionFactory = wSSecurityContext.getEncryptionFactory();
        EncryptedKey encryptedKey = (EncryptedKey)xMLEncryptionFactory.unmarshalEncryptedType(dOMDecryptContext);
        EncryptedKeyProvider encryptedKeyProvider = null;
        try {
            encryptedKeyProvider = new EncryptedKeyProvider(encryptedKey, dOMDecryptContext);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            if (verbose) {
                Verbose.log((Object)"XMLEncryptionException  when getting EncryptedKeyProvider from EncryptedKey ", xMLEncryptionException);
            }
            throw new WSSecurityException(xMLEncryptionException, WSSConstants.FAILURE_INVALID);
        }
        sAMLCredential.setEncryptedKeyProvider(encryptedKeyProvider);
        KeySelectorResult keySelectorResult = encryptedKeyProvider.getKey("http://www.w3.org/2000/09/xmldsig#hmac-sha1", KeySelector.Purpose.VERIFY);
        sAMLCredential.setSymmetircKey(keySelectorResult.getKey());
        if (verbose) {
            Verbose.log("set EncryptedKeyProvider in SAMLCrential");
        }
        EncryptedKeyInfoBuilder.debugKey(keySelectorResult.getKey(), "Set symmetricKey from input EncryptedKey into SAML Credentail");
    }
}

