/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.helpers;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.Detail;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.addressing.ClientAddressingHandler;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.ConnectionFactory;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.connection.transport.https.SSLAdapter;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.security.WssClientHandler;
import weblogic.wsee.security.bst.StubPropertyBSTCredProv;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertionFactory;
import weblogic.wsee.security.wssc.base.sct.SCCredentialProactiveRequestor;
import weblogic.wsee.security.wssc.utils.WSSCCompatibilityUtil;
import weblogic.wsee.security.wst.faults.InvalidRequestException;
import weblogic.wsee.security.wst.faults.RequestFailedException;
import weblogic.wsee.security.wst.faults.WSTFaultUtil;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.framework.async.AsyncTrustClient;
import weblogic.wsee.security.wst.framework.async.AsyncTrustClientHelper;
import weblogic.wsee.security.wst.helpers.CredentialProviderHelper;
import weblogic.wsee.security.wst.helpers.TrustTokenHelper;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss11.internal.WSS11Context;

public class SOAPHelper {
    private static final String SCT_CANCEL = "/SCT/Cancel";
    private static final String SCT_RENEW = "/SCT/Renew";
    private static final boolean DEBUG = false;
    private static final boolean verbose = Verbose.isVerbose(SOAPHelper.class);

    public static SoapMessageContext createEmptyRSTBaseMsgContext(boolean bl) throws SOAPException {
        MessageFactory messageFactory = WLMessageFactory.getInstance().getMessageFactory(bl);
        SOAPMessage sOAPMessage = messageFactory.createMessage();
        SoapMessageContext soapMessageContext = new SoapMessageContext(bl);
        soapMessageContext.setMessage(sOAPMessage);
        return soapMessageContext;
    }

    public static SoapMessageContext createRSTBaseMsgContext(Node node, WSTContext wSTContext) throws SOAPException {
        return SOAPHelper.createRSTBaseMsgContext(node, wSTContext, SOAPHelper.createEmptyRSTBaseMsgContext(((SoapMessageContext)wSTContext.getMessageContext()).isSoap12()));
    }

    public static SoapMessageContext createRSTBaseMsgContext(Node node, WSTContext wSTContext, SoapMessageContext soapMessageContext) throws SOAPException {
        assert (soapMessageContext != null);
        SOAPMessage sOAPMessage = soapMessageContext.getMessage();
        SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
        SOAPHelper.declareNamespacesToSOAPEnv(sOAPEnvelope, wSTContext);
        SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
        node = sOAPBody.getOwnerDocument().importNode(node, true);
        sOAPBody.appendChild(node);
        return soapMessageContext;
    }

    public static void updateCookies(MessageContext messageContext, SoapMessageContext soapMessageContext) {
        MimeHeaders mimeHeaders;
        Map map;
        if (((Boolean)soapMessageContext.getProperty("javax.xml.rpc.session.maintain")).booleanValue() && (map = (Map)soapMessageContext.getProperty("weblogic.wsee.invoke_properties")) != null && (mimeHeaders = (MimeHeaders)map.get("weblogic.wsee.transport.headers")) != null) {
            messageContext.setProperty("weblogic.wsee.transport.headers", (Object)mimeHeaders);
            map = (Map)messageContext.getProperty("weblogic.wsee.invoke_properties");
            if (map != null) {
                map.put("weblogic.wsee.transport.headers", mimeHeaders);
            }
        }
    }

    public static void initTrustMsgCtxProperties(WSTContext wSTContext, SoapMessageContext soapMessageContext) {
        Object object;
        Object object2;
        Object object3;
        String string;
        Object object4;
        SCCredentialProactiveRequestor sCCredentialProactiveRequestor;
        String string2;
        String string3;
        String string4;
        boolean bl;
        String string5;
        MessageContext messageContext = wSTContext.getMessageContext();
        soapMessageContext.setProperty("weblogic.wsee.complex", "true");
        String string6 = wSTContext.getAction();
        if (string6 == null) {
            WSTFaultUtil.raiseFault(new InvalidRequestException("Action must be set in WSTContext"));
        }
        soapMessageContext.setProperty("weblogic.wsee.addressing.Action", string6);
        soapMessageContext.setProperty("javax.xml.rpc.service.endpoint.address", wSTContext.getStsUri());
        soapMessageContext.setProperty("weblogic.wsee.addressing.From", messageContext.getProperty("weblogic.wsee.addressing.From"));
        if (messageContext.containsProperty("weblogic.wsee.addressing.version")) {
            soapMessageContext.setProperty("weblogic.wsee.addressing.version", messageContext.getProperty("weblogic.wsee.addressing.version"));
        }
        if ((string5 = (String)messageContext.getProperty("weblogic.wsee.policy.compat.preference")) != null && !"".equals(string5)) {
            soapMessageContext.setProperty("weblogic.wsee.policy.compat.preference", string5);
        }
        NormalizedExpression normalizedExpression = null;
        boolean bl2 = bl = messageContext.getProperty("weblogic.wsee.security.trust_claim") != null;
        if (bl) {
            normalizedExpression = wSTContext.getBootstrapPolicy();
            if (normalizedExpression == null) {
                throw new IllegalArgumentException("Missing STS Trust Policy");
            }
        } else {
            boolean bl3 = false;
            switch (WSSCCompatibilityUtil.getWSSCVersion(string5)) {
                case 1: {
                    bl3 = false;
                    break;
                }
                case 2: {
                    bl3 = string6.endsWith(SCT_CANCEL) || string6.endsWith(SCT_RENEW);
                    break;
                }
                default: {
                    bl3 = string6.endsWith(SCT_CANCEL);
                }
            }
            if (bl3) {
                normalizedExpression = wSTContext.getOuterPolicy();
                if (normalizedExpression == null) {
                    normalizedExpression = wSTContext.getBootstrapPolicy();
                }
            } else {
                normalizedExpression = wSTContext.getBootstrapPolicy();
            }
        }
        if (normalizedExpression != null) {
            soapMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", normalizedExpression);
            soapMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", normalizedExpression);
        }
        WssPolicyContext wssPolicyContext = (WssPolicyContext)messageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
        soapMessageContext.setProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx", wssPolicyContext);
        soapMessageContext.setProperty("weblogic.wsee.security.wst_bootstrap_policy", messageContext.getProperty("weblogic.wsee.security.wst_bootstrap_policy"));
        soapMessageContext.setProperty("weblogic.wsee.wst.sts_endpoint_uri", null);
        soapMessageContext.setProperty("weblogic.wsee.wst.saml.sts_endpoint_uri", messageContext.getProperty("weblogic.wsee.wst.saml.sts_endpoint_uri"));
        soapMessageContext.setProperty("weblogic.wsee.security.bst.stsEncryptCert", messageContext.getProperty("weblogic.wsee.security.bst.stsEncryptCert"));
        soapMessageContext.setProperty("weblogic.wsee.security.trust_soap_version", messageContext.getProperty("weblogic.wsee.security.trust_soap_version"));
        soapMessageContext.setProperty("weblogic.wsee.security.wst_onbehalfof_user", messageContext.getProperty("weblogic.wsee.security.wst_onbehalfof_user"));
        soapMessageContext.setProperty("weblogic.wsee.security.trust_version", messageContext.getProperty("weblogic.wsee.security.trust_version"));
        WSSecurityContext wSSecurityContext = SOAPHelper.createWSSecurityContext(soapMessageContext, wSTContext.isWssp());
        boolean bl4 = TrustTokenHelper.isWsscTokenType(wSTContext.getTokenType());
        Object object5 = messageContext.getProperty("weblogic.wsee.security.message_age");
        Long l = null;
        if (bl4) {
            l = (Long)messageContext.getProperty("weblogic.wsee.wssc.sct.lifetime");
            if (null == l) {
                if (null != object5 && object5 instanceof Integer) {
                    l = 1800000L;
                    if (verbose) {
                        Verbose.say("SCT lifetime value set to default =" + l);
                    }
                }
            } else if (verbose) {
                Verbose.say("SCT lifetime value set with SCT_LIFETIME_PROPERTY of " + l);
            }
        } else if (null != object5 && object5 instanceof Integer) {
            l = (long)((Integer)object5).intValue() * 1000L;
        }
        if (null != l) {
            wSTContext.setLifetimePeriod(l);
            if (verbose) {
                Verbose.say("WST lifetime period = " + wSTContext.getLifetimePeriod());
            }
        }
        if (null != object5 && object5 instanceof Integer) {
            soapMessageContext.setProperty("weblogic.wsee.security.message_age", object5);
            if (verbose) {
                Verbose.say("Trust WSS_MESSAGE_AGE = " + object5);
            }
        }
        SOAPHelper.initSecurityContext(messageContext, soapMessageContext, wSSecurityContext, bl4);
        Object object6 = messageContext.getProperty("javax.xml.rpc.session.maintain");
        boolean bl5 = true;
        if (object6 != null && object6 instanceof Boolean) {
            bl5 = (Boolean)object6;
        }
        if (bl5) {
            soapMessageContext.setProperty("javax.xml.rpc.session.maintain", new Boolean(true));
        } else {
            soapMessageContext.setProperty("javax.xml.rpc.session.maintain", new Boolean(false));
        }
        String string7 = (String)messageContext.getProperty("weblogic.wsee.transport.jms.url");
        if (string7 != null) {
            soapMessageContext.setProperty("weblogic.wsee.transport.jms.url", string7);
        }
        if ((string4 = (String)messageContext.getProperty("javax.xml.rpc.security.auth.username")) != null) {
            soapMessageContext.setProperty("javax.xml.rpc.security.auth.username", string4);
        }
        if ((string3 = (String)messageContext.getProperty("javax.xml.rpc.security.auth.password")) != null) {
            soapMessageContext.setProperty("javax.xml.rpc.security.auth.password", string3);
        }
        if ((string2 = (String)messageContext.getProperty("weblogic.wsee.transport.jms.messagetype")) != null) {
            soapMessageContext.setProperty("weblogic.wsee.transport.jms.messagetype", string2);
        }
        TransportInfo transportInfo = (TransportInfo)messageContext.getProperty("weblogic.wsee.security.wst_transportinfo");
        SSLAdapter sSLAdapter = (SSLAdapter)messageContext.getProperty("weblogic.wsee.security.wst_ssladapter");
        if (transportInfo != null) {
            soapMessageContext.setProperty("weblogic.wsee.connection.transportinfo", transportInfo);
        }
        if (sSLAdapter != null) {
            soapMessageContext.setProperty("weblogic.wsee.client.ssladapter", sSLAdapter);
        }
        if ((sCCredentialProactiveRequestor = (SCCredentialProactiveRequestor)messageContext.getProperty("weblogic.wsee.security.wssc.sct.scCredentialProactiveRequestor")) != null) {
            soapMessageContext.setProperty("weblogic.wsee.security.wssc.sct.scCredentialProactiveRequestor", sCCredentialProactiveRequestor);
        }
        if ((object4 = messageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.ASYNC_CLIENT_FEATURE")) != null) {
            soapMessageContext.setProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.ASYNC_CLIENT_FEATURE", object4);
        }
        if ((string = (String)messageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.JAX_WS_RUNTIME")) != null) {
            soapMessageContext.setProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.JAX_WS_RUNTIME", string);
        }
        if ((object3 = messageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.SERVICE")) != null) {
            soapMessageContext.setProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.SERVICE", object3);
        }
        try {
            object2 = WlMessageContext.narrow(messageContext);
            object = ((WlMessageContext)object2).getDispatcher();
            if (object != null) {
                soapMessageContext.setDispatcher((Dispatcher)object);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        soapMessageContext.setProperty("weblogic.wsee.security.wst.Wss11Runtime", wSTContext.isWssp());
        object2 = (String)messageContext.getProperty("weblogic.wsee.security.wst.enforceAsyncTrustExchange");
        if (object2 != null) {
            soapMessageContext.setProperty("weblogic.wsee.security.wst.enforceAsyncTrustExchange", object2);
        }
        if ((object = (String)messageContext.getProperty("javax.xml.rpc.service.endpoint.address")) != null) {
            soapMessageContext.setProperty("weblogic.wsee.security.wst.originalTargetEndpointAddress", object);
        }
    }

    private static void handleFault(SoapMessageContext soapMessageContext) {
        Throwable throwable = soapMessageContext.getFault();
        if (throwable != null) {
            throw new JAXRPCException(throwable);
        }
    }

    public static void invokeWsspHandler(SoapMessageContext soapMessageContext, String string, String string2) throws IOException {
        SOAPHelper.invokeWsspHandler(soapMessageContext, string, string2, false);
    }

    public static void invokeWsspHandler(SoapMessageContext soapMessageContext, String string, String string2, boolean bl) throws IOException {
        if (AsyncTrustClientHelper.isAsyncTrustRequired(soapMessageContext)) {
            AsyncTrustClient.process(soapMessageContext, string, string2, bl);
            return;
        }
        ClientAddressingHandler clientAddressingHandler = new ClientAddressingHandler();
        if (!clientAddressingHandler.handleRequest(soapMessageContext)) {
            SOAPHelper.handleFault(soapMessageContext);
        }
        weblogic.wsee.security.wssp.handlers.WssClientHandler wssClientHandler = null;
        if (bl && !(wssClientHandler = new weblogic.wsee.security.wssp.handlers.WssClientHandler()).handleRequest(soapMessageContext)) {
            SOAPHelper.handleFault(soapMessageContext);
        }
        Connection connection = ConnectionFactory.instance().createClientConnection(string, string2);
        connection.send(soapMessageContext);
        connection.receive(soapMessageContext);
        if (bl && !wssClientHandler.handleResponse(soapMessageContext)) {
            SOAPHelper.handleFault(soapMessageContext);
        }
        if (!clientAddressingHandler.handleResponse(soapMessageContext)) {
            SOAPHelper.handleFault(soapMessageContext);
        }
    }

    public static void invokeHandlers(SoapMessageContext soapMessageContext, String string, String string2) throws IOException {
        ClientAddressingHandler clientAddressingHandler = new ClientAddressingHandler();
        if (!clientAddressingHandler.handleRequest(soapMessageContext)) {
            SOAPHelper.handleFault(soapMessageContext);
        }
        WssClientHandler wssClientHandler = new WssClientHandler();
        NormalizedExpression normalizedExpression = (NormalizedExpression)soapMessageContext.getProperty("weblogic.wsee.policy.effectiveRequestPolicy");
        boolean bl = SecurityPolicyAssertionFactory.hasSecurityPolicy(normalizedExpression);
        if (bl) {
            if (!wssClientHandler.handleRequest(soapMessageContext)) {
                SOAPHelper.handleFault(soapMessageContext);
            }
        } else {
            string = "https";
        }
        Connection connection = ConnectionFactory.instance().createClientConnection(string, string2);
        connection.send(soapMessageContext);
        connection.receive(soapMessageContext);
        if (bl && !wssClientHandler.handleResponse(soapMessageContext)) {
            SOAPHelper.handleFault(soapMessageContext);
        }
        if (!clientAddressingHandler.handleResponse(soapMessageContext)) {
            SOAPHelper.handleFault(soapMessageContext);
        }
    }

    public static Node getRSTBaseNode(SOAPMessage sOAPMessage) throws RequestFailedException {
        Object object;
        try {
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            object = sOAPBody.getFault();
            if (object != null) {
                throw new RequestFailedException(SOAPHelper.getFaultMessage((SOAPFault)object));
            }
        }
        catch (SOAPException sOAPException) {
            throw new RequestFailedException(sOAPException.getMessage());
        }
        for (object = sOAPBody.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object.getNodeType() != 1) continue;
            return object;
        }
        throw new RequestFailedException("SOAP Body does not contain any elements");
    }

    private static void declareNamespacesToSOAPEnv(SOAPEnvelope sOAPEnvelope, WSTContext wSTContext) {
        Set<Map.Entry<String, String>> set = wSTContext.getNamespaces().entrySet();
        for (Map.Entry<String, String> entry : set) {
            DOMUtils.declareNamespace((Element)sOAPEnvelope, entry.getKey(), entry.getValue());
        }
    }

    private static String getFaultMessage(SOAPFault sOAPFault) {
        Detail detail = sOAPFault.getDetail();
        if (detail == null) {
            return "";
        }
        String string = detail.toString();
        for (Node node = detail.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3) continue;
            string = node.getNodeValue();
        }
        return string;
    }

    public static void insertTokenToTrustMessage(MessageContext messageContext, NormalizedExpression normalizedExpression) {
        NormalizedExpression normalizedExpression2 = (NormalizedExpression)messageContext.getProperty("weblogic.wsee.policy.effectiveRequestPolicy");
        if (normalizedExpression != null) {
            messageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", (Object)normalizedExpression);
            WSTContext wSTContext = WSTContext.getWSTContext(messageContext);
            boolean bl = wSTContext.isWssp();
            if (bl) {
                new WssClientHandler().handleRequest(messageContext);
            } else {
                new WssClientHandler(false).handleRequest(messageContext);
            }
        }
        messageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", (Object)normalizedExpression2);
    }

    public static void insertTokenToTrustMessage(MessageContext messageContext, String string) {
        NormalizedExpression normalizedExpression = null;
        try {
            PolicyServer policyServer = new PolicyServer();
            normalizedExpression = policyServer.getPolicy(string).normalize();
        }
        catch (PolicyException policyException) {
            throw new IllegalArgumentException("Fatal Error.  Unable to load policy '" + string + "'");
        }
        SOAPHelper.insertTokenToTrustMessage(messageContext, normalizedExpression);
    }

    private static void initSecurityContext(MessageContext messageContext, SoapMessageContext soapMessageContext, WSSecurityContext wSSecurityContext, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        List<StubPropertyBSTCredProv> list;
        Map map = WSSecurityContext.getCredentialProviders(messageContext);
        if (map == null || map.size() == 0) {
            list = (ArrayList)messageContext.getProperty("weblogic.wsee.security.wss.CredentialProviderList");
        } else {
            list = new ArrayList();
            object3 = map.entrySet().iterator();
            while (object3.hasNext()) {
                list.add((StubPropertyBSTCredProv)((Map.Entry)object3.next()).getValue());
            }
        }
        object3 = null;
        if (bl) {
            object3 = messageContext.getProperty("weblogic.wsee.security.bst.serverEncryptCert");
        } else {
            object3 = messageContext.getProperty("weblogic.wsee.security.bst.stsEncryptCert");
            if (null == object3) {
                object3 = messageContext.getProperty("weblogic.wsee.security.bst.serverEncryptCert");
                if (null != object3 && verbose) {
                    Verbose.say("weblogic.wsee.security.bst.serverEncryptCert is  used for the STS Server Certificate");
                }
            } else if (verbose) {
                Verbose.say("weblogic.wsee.security.bst.stsEncryptCert is  used for the STS Server Certificate");
            }
        }
        if (object3 != null) {
            soapMessageContext.setProperty("weblogic.wsee.security.bst.serverEncryptCert", object3);
            if (verbose) {
                Verbose.say("The Server Encypt Certificate in Trust Msg Ctx is " + object3.toString());
            }
            if (list != null && !list.isEmpty()) {
                list = CredentialProviderHelper.replaceCredentialProviderWithNewCert(list, (X509Certificate)object3);
            } else if (messageContext.getProperty("weblogic.wsee.security.bst.stsEncryptCert") != null) {
                list = new ArrayList();
                list.add(new StubPropertyBSTCredProv((X509Certificate)object3, null));
                if (verbose) {
                    Verbose.say("New StubPropertyBSTCredProv is added with Server Cert");
                }
            }
        }
        if (list != null) {
            soapMessageContext.setProperty("weblogic.wsee.security.wss.CredentialProviderList", list);
            wSSecurityContext.addCredentialProviders(list);
            soapMessageContext.setProperty("weblogic.xml.crypto.wss.WSSecurityContext", wSSecurityContext);
        }
        if ((object2 = messageContext.getProperty("weblogic.wsee.security.bst.serverVerifyCert")) != null) {
            soapMessageContext.setProperty("weblogic.wsee.security.bst.serverVerifyCert", object2);
        }
        if ((object = messageContext.getProperty("weblogic.wsee.security.wss.TrustManager")) != null) {
            soapMessageContext.setProperty("weblogic.wsee.security.wss.TrustManager", object);
        }
    }

    private static WSSecurityContext createWSSecurityContext(SoapMessageContext soapMessageContext, boolean bl) {
        try {
            if (bl) {
                SOAPHeader sOAPHeader = soapMessageContext.getMessage().getSOAPHeader();
                return new WSS11Context((Node)sOAPHeader, null, null, null);
            }
            return new WSSecurityContext(soapMessageContext);
        }
        catch (SOAPException sOAPException) {
            WSTFaultUtil.raiseFault(new InvalidRequestException("Failed to create WSSecurityContext in trust."));
            return null;
        }
    }
}

