/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.helpers;

import java.util.Calendar;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import weblogic.wsee.security.configuration.TimestampConfiguration;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.wst.binding.RequestSecurityToken;
import weblogic.wsee.security.wst.binding.TokenType;
import weblogic.wsee.security.wst.faults.RequestFailedException;
import weblogic.wsee.security.wst.framework.TrustToken;
import weblogic.wsee.security.wst.framework.TrustTokenProvider;
import weblogic.wsee.security.wst.framework.TrustTokenProviderRegistry;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.SecurityTokenHelper;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;

public class TrustTokenHelper {
    private static final boolean verbose = Verbose.isVerbose(TrustTokenHelper.class);

    public static boolean isExpired(MessageContext messageContext, Calendar calendar, Calendar calendar2) {
        WssPolicyContext wssPolicyContext = (WssPolicyContext)messageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
        TimestampConfiguration timestampConfiguration = wssPolicyContext != null ? wssPolicyContext.getWssConfiguration().getTimestampConfig() : new TimestampConfiguration();
        try {
            timestampConfiguration.checkExpiration(calendar, calendar2);
        }
        catch (SOAPFaultException sOAPFaultException) {
            return true;
        }
        return false;
    }

    public static TrustTokenProvider resolveTrustProvider(String string) throws RequestFailedException {
        TrustTokenProviderRegistry trustTokenProviderRegistry = TrustTokenProviderRegistry.getInstance();
        TrustTokenProvider trustTokenProvider = trustTokenProviderRegistry.getTrustTokenProvider(string);
        if (trustTokenProvider == null) {
            throw new RequestFailedException("Trust is unable to handle token type: " + string);
        }
        if (verbose) {
            Verbose.log(" for tokenType='" + string + "', returning TTP='" + trustTokenProvider.getClass().getName() + "'");
        }
        return trustTokenProvider;
    }

    public static TrustTokenProvider resolveTrustProvider(RequestSecurityToken requestSecurityToken, SecurityTokenReference securityTokenReference) throws RequestFailedException {
        String string = null;
        TokenType tokenType = requestSecurityToken.getTokenType();
        if (tokenType != null) {
            if (verbose) {
                Verbose.log(" resolveTrustProvider tokenType from RST= '" + tokenType + "'");
            }
            string = tokenType.getTokenType();
        } else {
            string = securityTokenReference.getValueType();
            if (verbose) {
                Verbose.log(" resolveTrustProvider tokenType from STR= '" + tokenType + "'");
            }
        }
        return TrustTokenHelper.resolveTrustProvider(string);
    }

    public static TrustToken getTrustCredentialFromSecurityContext(WSTContext wSTContext, SecurityTokenReference securityTokenReference) {
        Object object;
        MessageContext messageContext = wSTContext.getMessageContext();
        if (messageContext == null) {
            return null;
        }
        WSSecurityContext wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
        if (wSSecurityContext == null) {
            return null;
        }
        String string = securityTokenReference.getReferenceURI();
        if (string == null) {
            object = securityTokenReference.getKeyIdentifier();
            if (object != null) {
                string = new String(object.getIdentifier());
            }
        } else if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if (string == null) {
            return null;
        }
        object = SecurityTokenHelper.findSecurityTokenByIdInContext(wSSecurityContext, securityTokenReference.getValueType(), string);
        if (object instanceof TrustToken) {
            return (TrustToken)object;
        }
        return null;
    }

    public static boolean isWsscTokenType(String string) {
        if (null == string) {
            return false;
        }
        return string.endsWith("/sct");
    }
}

