/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.internal;

import org.w3c.dom.Node;
import weblogic.wsee.security.wst.binding.CancelTarget;
import weblogic.wsee.security.wst.binding.RequestSecurityToken;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponse;
import weblogic.wsee.security.wst.binding.RequestedTokenCancelled;
import weblogic.wsee.security.wst.faults.InvalidRequestException;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.framework.TrustToken;
import weblogic.wsee.security.wst.framework.TrustTokenProvider;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.helpers.BindingHelper;
import weblogic.wsee.security.wst.helpers.TrustTokenHelper;
import weblogic.wsee.security.wst.internal.ProcessorBase;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;

public class CancelProcessor
extends ProcessorBase {
    public String getRequestType() {
        return "/Cancel";
    }

    public Node processRequestSecurityToken(Node node, WSTContext wSTContext) throws WSTFaultException {
        RequestSecurityToken requestSecurityToken = BindingHelper.unmarshalRSTNode(node, CancelProcessor.getSecurityTokenHandler(wSTContext));
        CancelTarget cancelTarget = requestSecurityToken.getCancelTarget();
        if (cancelTarget == null) {
            throw new InvalidRequestException("CancelTarget must be specified in RST");
        }
        SecurityTokenReference securityTokenReference = cancelTarget.getSecurityTokenReference();
        TrustTokenProvider trustTokenProvider = TrustTokenHelper.resolveTrustProvider(securityTokenReference.getValueType());
        TrustToken trustToken = trustTokenProvider.resolveTrustToken(wSTContext, securityTokenReference);
        trustTokenProvider.cancelTrustToken(wSTContext, trustToken);
        RequestSecurityTokenResponse requestSecurityTokenResponse = CancelProcessor.createRSTR(requestSecurityToken, wSTContext);
        RequestedTokenCancelled requestedTokenCancelled = new RequestedTokenCancelled(wSTContext.getWstNamespaceURI());
        requestSecurityTokenResponse.setRequestedTokenCancelled(requestedTokenCancelled);
        return BindingHelper.marshalRST(requestSecurityTokenResponse, wSTContext);
    }
}

