/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.internal;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.spec.SecretKeySpec;
import weblogic.wsee.security.wst.binding.BinarySecret;
import weblogic.wsee.security.wst.binding.ComputedKey;
import weblogic.wsee.security.wst.binding.Entropy;
import weblogic.wsee.security.wst.binding.RequestedProofToken;
import weblogic.wsee.security.wst.faults.BadRequestException;
import weblogic.wsee.security.wst.faults.InvalidRequestException;
import weblogic.wsee.security.wst.faults.RequestFailedException;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.helpers.BindingHelper;
import weblogic.xml.crypto.utils.KeyUtils;

public class EntropyHandler {
    private WSTContext wstContext;
    private Entropy reqEntropy;
    private Entropy resEntropy;
    private RequestedProofToken rpt;
    private Key key;

    public EntropyHandler(WSTContext wSTContext, Entropy entropy) throws WSTFaultException {
        this.wstContext = wSTContext;
        this.reqEntropy = entropy;
        try {
            this.init();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RequestFailedException("Unable to generate key for " + wSTContext.getSymmetricKeyAlgorithm() + " in size " + wSTContext.getKeySize());
        }
    }

    public EntropyHandler(WSTContext wSTContext, Key key) throws WSTFaultException {
        this.wstContext = wSTContext;
        this.reqEntropy = null;
        this.key = key;
        try {
            this.handleNoReqEntropy(key);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RequestFailedException("Unable to generate key for " + wSTContext.getSymmetricKeyAlgorithm() + " in size " + wSTContext.getKeySize());
        }
    }

    public EntropyHandler(WSTContext wSTContext, BinarySecret binarySecret) throws WSTFaultException {
        this.wstContext = wSTContext;
        this.reqEntropy = null;
        try {
            this.handleRequestorBinarySecret(binarySecret);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RequestFailedException("Unable to generate key for " + wSTContext.getSymmetricKeyAlgorithm() + " in size " + wSTContext.getKeySize());
        }
    }

    private void init() throws NoSuchAlgorithmException, WSTFaultException {
        if (this.reqEntropy == null) {
            this.handleNoReqEntropy();
        } else if (this.reqEntropy.getBinarySecret() != null) {
            this.handleRequestorBinarySecret(this.reqEntropy.getBinarySecret());
        }
    }

    private void handleRequestorBinarySecret(BinarySecret binarySecret) throws NoSuchAlgorithmException, WSTFaultException {
        String string = binarySecret.getType();
        if (string == null || string.endsWith("/SymmetricKey")) {
            this.key = new SecretKeySpec(binarySecret.getValue(), this.wstContext.getSymmetricKeyAlgorithm());
        } else {
            if (string.endsWith("/AsymmetricKey")) {
                throw new BadRequestException("Asymmetric key is not net supported");
            }
            if (string.endsWith("/Nonce")) {
                String string2 = this.wstContext.getWstNamespaceURI();
                this.resEntropy = BindingHelper.createNewEntropy(string2, string2 + "/Nonce");
                ComputedKey computedKey = new ComputedKey(string2);
                computedKey.setUri(string2 + "/CK/PSHA1");
                this.rpt = new RequestedProofToken(string2);
                this.rpt.setComputedKey(computedKey);
                try {
                    this.key = KeyUtils.generateKey(binarySecret.getValue(), this.resEntropy.getBinarySecret().getValue(), this.wstContext.getSymmetricKeyAlgorithm(), this.wstContext.getKeySize());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RequestFailedException("Unable to compute key from entropies");
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new RequestFailedException("Unable to compute key from entropies");
                }
            } else {
                throw new InvalidRequestException("Unknown BinarySecret type: " + string);
            }
        }
    }

    private void handleNoReqEntropy() throws NoSuchAlgorithmException {
        this.key = KeyUtils.newSecretKey(this.wstContext.getSymmetricKeyAlgorithm(), this.wstContext.getKeySize());
        this.handleNoReqEntropy(this.key);
    }

    private void handleNoReqEntropy(Key key) throws NoSuchAlgorithmException {
        this.rpt = new RequestedProofToken(this.wstContext.getWstNamespaceURI());
        String string = this.rpt.getNamespaceURI();
        BinarySecret binarySecret = BindingHelper.createBinarySecret(string, key, string + "/SymmetricKey");
        this.rpt.setBinarySecret(binarySecret);
    }

    public Entropy getResponseEntropy(Key key) {
        String string = this.rpt.getNamespaceURI();
        if (null == string) {
            string = this.wstContext.getWstNamespaceURI();
        }
        return BindingHelper.createNewEntropy(string, key, string + "/SymmetricKey");
    }

    public Entropy getResponseEntropy() {
        return this.resEntropy;
    }

    public Key getKey() {
        return this.key;
    }

    public RequestedProofToken getRequestedProofToken() {
        return this.rpt;
    }
}

