/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.internal;

import java.security.Key;
import org.w3c.dom.Node;
import weblogic.wsee.security.saml.SAMLUtils;
import weblogic.wsee.security.wst.binding.Entropy;
import weblogic.wsee.security.wst.binding.OnBehalfOf;
import weblogic.wsee.security.wst.binding.RequestSecurityToken;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponse;
import weblogic.wsee.security.wst.binding.RequestedAttachedReference;
import weblogic.wsee.security.wst.binding.RequestedProofToken;
import weblogic.wsee.security.wst.binding.RequestedSecurityToken;
import weblogic.wsee.security.wst.binding.TokenReferenceBase;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.framework.TrustToken;
import weblogic.wsee.security.wst.framework.TrustTokenProvider;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.helpers.BindingHelper;
import weblogic.wsee.security.wst.helpers.EncryptedKeyInfoBuilder;
import weblogic.wsee.security.wst.helpers.TrustTokenHelper;
import weblogic.wsee.security.wst.internal.EntropyHandler;
import weblogic.wsee.security.wst.internal.ProcessorBase;
import weblogic.xml.crypto.wss.provider.SecurityToken;

public class IssueProcessor
extends ProcessorBase {
    public String getRequestType() {
        return "/Issue";
    }

    public Node processRequestSecurityToken(Node node, WSTContext wSTContext) throws WSTFaultException {
        Object object;
        SecurityToken securityToken;
        OnBehalfOf onBehalfOf;
        RequestSecurityToken requestSecurityToken = BindingHelper.unmarshalRSTNode(node);
        RequestSecurityTokenResponse requestSecurityTokenResponse = IssueProcessor.createRSTR(requestSecurityToken, wSTContext);
        IssueProcessor.setRequestType(requestSecurityToken, requestSecurityTokenResponse, wSTContext);
        this.setAppliesTo(requestSecurityToken, requestSecurityTokenResponse, wSTContext);
        this.setLifetime(requestSecurityToken, requestSecurityTokenResponse, wSTContext, false);
        this.setKeySize(requestSecurityToken, requestSecurityTokenResponse, wSTContext);
        String string = IssueProcessor.setTokenType(requestSecurityToken, requestSecurityTokenResponse, wSTContext);
        this.setKeyType(requestSecurityToken, string, wSTContext);
        TrustTokenProvider trustTokenProvider = TrustTokenHelper.resolveTrustProvider(string);
        EntropyHandler entropyHandler = new EntropyHandler(wSTContext, requestSecurityToken.getEntropy());
        Key key = entropyHandler.getKey();
        wSTContext.setSymmetricKey(key);
        EncryptedKeyInfoBuilder.debugKey(wSTContext.getSymmetricKey(), "Gerenated secretKey and Saved Key onto RSTR");
        Entropy entropy = entropyHandler.getResponseEntropy();
        if (entropy != null) {
            requestSecurityTokenResponse.setEntropy(entropy);
        }
        if ((onBehalfOf = requestSecurityToken.getOnBehalfOf()) != null) {
            securityToken = onBehalfOf.getSecurityToken();
            wSTContext.setOnBehalfOfToken(securityToken);
        }
        securityToken = trustTokenProvider.issueTrustToken(wSTContext);
        RequestedSecurityToken requestedSecurityToken = new RequestedSecurityToken(wSTContext.getWstNamespaceURI());
        requestedSecurityToken.setSecurityToken(securityToken);
        requestSecurityTokenResponse.setRequestedSecurityToken(requestedSecurityToken);
        String string2 = wSTContext.getKeyType();
        if (SAMLUtils.isSamlTokenType(string) && SAMLUtils.isSymmetricKeyType(string2)) {
            object = new EntropyHandler(wSTContext, wSTContext.getSymmetricKey());
            entropy = ((EntropyHandler)object).getResponseEntropy(wSTContext.getSymmetricKey());
            EncryptedKeyInfoBuilder.debugKey(wSTContext.getSymmetricKey(), "Saving Symmetric Key onto RSTR from wstCtx");
            if (entropy != null) {
                requestSecurityTokenResponse.setEntropy(entropy);
            }
        }
        if (string2 != null && string2.endsWith("Bearer")) {
            requestSecurityTokenResponse.setRequestedProofToken(null);
        } else {
            object = entropyHandler.getRequestedProofToken();
            if (object != null) {
                requestSecurityTokenResponse.setRequestedProofToken((RequestedProofToken)object);
            }
        }
        if (securityToken.getId() == null) {
            object = new RequestedAttachedReference(wSTContext.getWstNamespaceURI());
            ((TokenReferenceBase)object).setSecurityTokenReference(trustTokenProvider.createSecurityTokenReference(wSTContext, (TrustToken)securityToken));
            requestSecurityTokenResponse.setRequestedAttachedReference((RequestedAttachedReference)object);
        }
        return BindingHelper.marshalRST(requestSecurityTokenResponse, wSTContext);
    }
}

