/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.internal;

import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.wst.binding.AppliesTo;
import weblogic.wsee.security.wst.binding.KeySize;
import weblogic.wsee.security.wst.binding.KeyType;
import weblogic.wsee.security.wst.binding.Lifetime;
import weblogic.wsee.security.wst.binding.RequestSecurityToken;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponse;
import weblogic.wsee.security.wst.binding.RequestType;
import weblogic.wsee.security.wst.binding.TokenType;
import weblogic.wsee.security.wst.faults.BadRequestException;
import weblogic.wsee.security.wst.framework.TrustProcessor;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;

public abstract class ProcessorBase
implements TrustProcessor {
    protected static SecurityTokenHandler getSecurityTokenHandler(WSTContext wSTContext) {
        WssPolicyContext wssPolicyContext;
        MessageContext messageContext = wSTContext.getMessageContext();
        if (messageContext != null && (wssPolicyContext = (WssPolicyContext)messageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx")) != null) {
            try {
                SecurityTokenHandler securityTokenHandler = wssPolicyContext.getWssConfiguration().getTokenHandler(wSTContext.getTokenType(), null);
                return securityTokenHandler;
            }
            catch (WssConfigurationException wssConfigurationException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static RequestSecurityTokenResponse createRSTR(RequestSecurityToken requestSecurityToken, WSTContext wSTContext) {
        String string = wSTContext.getWstNamespaceURI();
        RequestSecurityTokenResponse requestSecurityTokenResponse = new RequestSecurityTokenResponse(string);
        return requestSecurityTokenResponse;
    }

    protected static void setRequestType(RequestSecurityToken requestSecurityToken, RequestSecurityTokenResponse requestSecurityTokenResponse, WSTContext wSTContext) throws BadRequestException {
        RequestType requestType = requestSecurityToken.getRequestType();
        if (requestType == null) {
            throw new BadRequestException("RequestType is missing in RST");
        }
        String string = requestType.getRequestType();
        requestType = new RequestType(wSTContext.getWstNamespaceURI());
        requestType.setRequestType(string);
        requestSecurityTokenResponse.setRequestType(requestType);
    }

    protected static String setTokenType(RequestSecurityToken requestSecurityToken, RequestSecurityTokenResponse requestSecurityTokenResponse, WSTContext wSTContext) throws BadRequestException {
        String string = null;
        TokenType tokenType = requestSecurityToken.getTokenType();
        if (tokenType == null) {
            string = wSTContext.getTokenType();
        } else {
            string = tokenType.getTokenType();
            wSTContext.setTokenType(string);
        }
        if (string == null) {
            throw new BadRequestException("Can not determine requested token type from RST or WSTContext.");
        }
        tokenType = new TokenType(requestSecurityTokenResponse.getNamespaceURI());
        tokenType.setTokenType(string);
        requestSecurityTokenResponse.setTokenType(tokenType);
        return string;
    }

    protected void setAppliesTo(RequestSecurityToken requestSecurityToken, RequestSecurityTokenResponse requestSecurityTokenResponse, WSTContext wSTContext) {
        AppliesTo appliesTo = requestSecurityToken.getAppliesTo();
        if (appliesTo != null) {
            AppliesTo appliesTo2 = new AppliesTo(appliesTo.getNamespaceURI());
            if (appliesTo.getElement() != null) {
                appliesTo2.setElement(appliesTo.getElement());
                wSTContext.setAppliesToElement(appliesTo.getElement());
            } else {
                String string = appliesTo.getEndpointReference();
                appliesTo2.setEndpointReference(wSTContext.getWsaNamespaceURI(), string);
                wSTContext.setAppliesTo(string);
            }
            requestSecurityTokenResponse.setAppliesTo(appliesTo2);
        } else if (wSTContext.getAppliesToElement() != null) {
            AppliesTo appliesTo3 = new AppliesTo(wSTContext.getWspNamespaceURI());
            appliesTo3.setElement(wSTContext.getAppliesToElement());
            requestSecurityTokenResponse.setAppliesTo(appliesTo3);
        } else if (wSTContext.getAppliesTo() != null) {
            AppliesTo appliesTo4 = new AppliesTo(wSTContext.getWspNamespaceURI());
            appliesTo4.setEndpointReference(wSTContext.getWsaNamespaceURI(), wSTContext.getAppliesTo());
            requestSecurityTokenResponse.setAppliesTo(appliesTo4);
        }
    }

    protected void setLifetime(RequestSecurityToken requestSecurityToken, RequestSecurityTokenResponse requestSecurityTokenResponse, WSTContext wSTContext, boolean bl) {
        Lifetime lifetime = requestSecurityToken.getLifetime();
        if (lifetime == null) {
            lifetime = new Lifetime(wSTContext.getWstNamespaceURI());
            lifetime.setPeriod(wSTContext.getLifetimePeriod(), wSTContext.getWsuNamespaceURI());
        }
        if (bl) {
            long l = lifetime.getExpires().getTimeInMillis() - lifetime.getCreated().getTimeInMillis();
            lifetime.setPeriod(l, wSTContext.getWsuNamespaceURI());
        }
        requestSecurityTokenResponse.setLifetime(lifetime);
        wSTContext.setCreated(lifetime.getCreated());
        wSTContext.setExpires(lifetime.getExpires());
    }

    protected void setKeySize(RequestSecurityToken requestSecurityToken, RequestSecurityTokenResponse requestSecurityTokenResponse, WSTContext wSTContext) {
        KeySize keySize = requestSecurityToken.getKeySize();
        int n = keySize == null ? wSTContext.getKeySize() : keySize.getSize();
        keySize = new KeySize(requestSecurityTokenResponse.getNamespaceURI());
        keySize.setSize(n);
        requestSecurityTokenResponse.setKeySize(keySize);
        wSTContext.setKeySize(n);
    }

    protected void setKeyType(RequestSecurityToken requestSecurityToken, String string, WSTContext wSTContext) {
        KeyType keyType = requestSecurityToken.getKeyType();
        if (keyType != null) {
            wSTContext.setKeyType(keyType.getKeyType());
        }
    }
}

