/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.internal;

import org.w3c.dom.Node;
import weblogic.wsee.security.wst.binding.RenewTarget;
import weblogic.wsee.security.wst.binding.RequestSecurityToken;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponse;
import weblogic.wsee.security.wst.binding.RequestedSecurityToken;
import weblogic.wsee.security.wst.faults.InvalidRequestException;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.framework.TrustToken;
import weblogic.wsee.security.wst.framework.TrustTokenProvider;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.helpers.BindingHelper;
import weblogic.wsee.security.wst.helpers.TrustTokenHelper;
import weblogic.wsee.security.wst.internal.ProcessorBase;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;

public class RenewProcessor
extends ProcessorBase {
    public String getRequestType() {
        return "/Renew";
    }

    public Node processRequestSecurityToken(Node node, WSTContext wSTContext) throws WSTFaultException {
        RequestSecurityToken requestSecurityToken = BindingHelper.unmarshalRSTNode(node, RenewProcessor.getSecurityTokenHandler(wSTContext));
        RequestSecurityTokenResponse requestSecurityTokenResponse = RenewProcessor.createRSTR(requestSecurityToken, wSTContext);
        RenewProcessor.setRequestType(requestSecurityToken, requestSecurityTokenResponse, wSTContext);
        this.setLifetime(requestSecurityToken, requestSecurityTokenResponse, wSTContext, true);
        RenewTarget renewTarget = requestSecurityToken.getRenewTarget();
        if (renewTarget == null) {
            throw new InvalidRequestException("RenewTarget is missing in renewal RST");
        }
        SecurityTokenReference securityTokenReference = renewTarget.getSecurityTokenReference();
        TrustTokenProvider trustTokenProvider = TrustTokenHelper.resolveTrustProvider(requestSecurityToken, securityTokenReference);
        TrustToken trustToken = trustTokenProvider.resolveTrustToken(wSTContext, securityTokenReference);
        trustTokenProvider.renewTrustToken(wSTContext, trustToken);
        RequestedSecurityToken requestedSecurityToken = new RequestedSecurityToken(wSTContext.getWstNamespaceURI());
        requestedSecurityToken.setSecurityToken(trustToken);
        requestSecurityTokenResponse.setRequestedSecurityToken(requestedSecurityToken);
        return BindingHelper.marshalRST(requestSecurityTokenResponse, wSTContext);
    }
}

