/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.internal;

import java.util.Locale;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import weblogic.wsee.addressing.AddressingHelper;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.reliability.policy.ReliabilityPolicyAssertionsFactory;
import weblogic.wsee.security.WssServerPolicyHandler;
import weblogic.wsee.security.wst.binding.RequestSecurityTokenResponseCollection;
import weblogic.wsee.security.wst.faults.BadRequestException;
import weblogic.wsee.security.wst.faults.RequestFailedException;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.faults.WSTFaultUtil;
import weblogic.wsee.security.wst.framework.TrustProcessor;
import weblogic.wsee.security.wst.framework.TrustProcessorFactory;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.helpers.BindingHelper;
import weblogic.wsee.security.wst.helpers.SOAPHelper;
import weblogic.wsee.security.wst.internal.WSTServerHandler;
import weblogic.wsee.util.Verbose;

public class STSMessageHandler
extends WSTServerHandler {
    private static final boolean verbose = Verbose.isVerbose(STSMessageHandler.class);
    private static final String STS_POLICY_VALIDATION_OFF = "weblogic.wsee.security.wst.sts.policy.validation.off";

    public boolean handleTrustRequest(SOAPMessageContext sOAPMessageContext, String string) {
        if (verbose) {
            Verbose.log(" handleTrustRequest  action arg value='" + string + "'");
        }
        if (!Boolean.getBoolean(STS_POLICY_VALIDATION_OFF)) {
            this.validatePolicy(sOAPMessageContext);
        }
        if (sOAPMessageContext.containsProperty("weblogic.wsee.security.wssp.handlers.wst_heuristic")) {
            sOAPMessageContext.removeProperty("weblogic.wsee.security.wssp.handlers.wst_heuristic");
        }
        String string2 = STSMessageHandler.amendRSTRAction(string);
        if (verbose) {
            Verbose.log(" handleTrustRequest  amended action arg value='" + string2 + "'");
        }
        try {
            Object object;
            RequestSecurityTokenResponseCollection requestSecurityTokenResponseCollection;
            WSTContext wSTContext = this.initWSTContext(sOAPMessageContext, string2);
            boolean bl = false;
            if (string2.toLowerCase(Locale.ENGLISH).startsWith("http://docs.oasis-open.org/ws-sx/ws-trust/200512".toLowerCase(Locale.ENGLISH))) {
                bl = true;
            }
            Node node = SOAPHelper.getRSTBaseNode(sOAPMessageContext.getMessage());
            TrustProcessor trustProcessor = STSMessageHandler.getTrustProcessorFromAction(string);
            Node node2 = trustProcessor.processRequestSecurityToken(node, wSTContext);
            Object object2 = node2;
            if (bl) {
                requestSecurityTokenResponseCollection = BindingHelper.createEmptyRSTRC(wSTContext);
                object = BindingHelper.marshalRST(requestSecurityTokenResponseCollection, wSTContext);
                node2 = object.getOwnerDocument().importNode(node2, true);
                object.appendChild(node2);
                object2 = object;
            }
            requestSecurityTokenResponseCollection = SOAPHelper.createRSTBaseMsgContext((Node)object2, wSTContext).getMessage();
            sOAPMessageContext.setMessage((SOAPMessage)requestSecurityTokenResponseCollection);
            object = AddressingHelper.getAddressingProvider((MessageContext)sOAPMessageContext);
            ((WlMessageContext)sOAPMessageContext).getHeaders().addHeader(object.createActionHeader(string2));
            boolean bl2 = "true".equalsIgnoreCase((String)sOAPMessageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.JAX_WS_RUNTIME"));
            if (bl2) {
                sOAPMessageContext.setProperty("javax.xml.rpc.soap.http.soapaction.uri", (Object)string2);
            }
        }
        catch (PolicyException policyException) {
            WSTFaultUtil.raiseFault(new BadRequestException("Unable to read trust boot strap policy: " + policyException.getMessage()));
        }
        catch (SOAPException sOAPException) {
            WSTFaultUtil.raiseFault(new BadRequestException("SOAP Exception on reading trust boot strap policy: " + sOAPException.getMessage()));
        }
        catch (WSTFaultException wSTFaultException) {
            wSTFaultException.printStackTrace();
            WSTFaultUtil.raiseFault(wSTFaultException);
        }
        return false;
    }

    private void validatePolicy(SOAPMessageContext sOAPMessageContext) {
        GenericHandler genericHandler = this.getPolicyHandler();
        boolean bl = genericHandler.handleRequest((MessageContext)sOAPMessageContext);
        if (!bl) {
            String string = "";
            try {
                string = " " + DOMUtils.toXMLString((Node)sOAPMessageContext.getMessage().getSOAPBody().getFault());
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
            WSTFaultUtil.raiseFault(new WSTFaultException("Failed to validate trust request against policy." + string));
        }
    }

    protected GenericHandler getPolicyHandler() {
        WssServerPolicyHandler wssServerPolicyHandler = new WssServerPolicyHandler();
        return wssServerPolicyHandler;
    }

    private WSTContext initWSTContext(SOAPMessageContext sOAPMessageContext, String string) throws PolicyException, SOAPException {
        WSTContext wSTContext = WSTContext.getWSTContext((MessageContext)sOAPMessageContext);
        wSTContext.setAppliesTo((String)sOAPMessageContext.getProperty("weblogic.wsee.connection.end_point_address"));
        wSTContext.setAction(string);
        boolean bl = ReliabilityPolicyAssertionsFactory.hasRMPolicy(PolicyContext.getEndpointPolicy((MessageContext)sOAPMessageContext));
        boolean bl2 = "true".equalsIgnoreCase((String)sOAPMessageContext.getProperty("weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.JAX_WS_RUNTIME"));
        if (bl || bl2) {
            wSTContext.setPersistSession(true);
        }
        STSMessageHandler.determineTokenType(wSTContext, string);
        STSMessageHandler.setTrustNamespace(wSTContext, string);
        return wSTContext;
    }

    private static final String amendRSTRAction(String string) {
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue".equals(string)) {
            return "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTRC/IssueFinal";
        }
        int n = string.indexOf("/trust/RST/");
        if (n > 0) {
            return string.substring(0, n) + "/trust/RSTR/" + string.substring(n + "/trust/RST/".length(), string.length());
        }
        n = string.indexOf("ws-trust/200512/RST/");
        if (n > 0) {
            return string.substring(0, n) + "ws-trust/200512/RSTR/" + string.substring(n + "ws-trust/200512/RST/".length(), string.length());
        }
        return string;
    }

    private static TrustProcessor getTrustProcessorFromAction(String string) throws RequestFailedException {
        TrustProcessorFactory trustProcessorFactory = TrustProcessorFactory.getInstance();
        int n = string.lastIndexOf(47);
        String string2 = string.substring(n);
        TrustProcessor trustProcessor = string2.equalsIgnoreCase("/SCT") ? trustProcessorFactory.getProcessor(string) : trustProcessorFactory.getProcessor(string2);
        if (trustProcessor == null) {
            throw new RequestFailedException("Can not find trust processor to handle action:" + string);
        }
        return trustProcessor;
    }

    private static void determineTokenType(WSTContext wSTContext, String string) throws SOAPException {
        String string2;
        if (verbose) {
            Verbose.log(" about to look up token type for action='" + string.toLowerCase(Locale.ENGLISH) + "'");
        }
        if ((string2 = string.toLowerCase(Locale.ENGLISH)).indexOf("sct") > -1) {
            if (string2.indexOf("http://schemas.xmlsoap.org/ws/2005/02/trust") > -1) {
                wSTContext.setTokenType("http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
            } else if (string2.indexOf("http://docs.oasis-open.org/ws-sx/ws-trust/200512") > -1) {
                wSTContext.setTokenType("sct_v13");
            } else {
                throw new SOAPException(" Error.  While attempting to determine STS token type.  Unexpected action URI='" + string + "'");
            }
        }
    }

    private static void setTrustNamespace(WSTContext wSTContext, String string) throws SOAPException {
        String string2;
        if (verbose) {
            Verbose.log(" about to set trust ns for action='" + string.toLowerCase(Locale.ENGLISH) + "'");
        }
        if ((string2 = string.toLowerCase(Locale.ENGLISH)).indexOf("http://schemas.xmlsoap.org/ws/2005/02/trust") > -1) {
            wSTContext.setWstNamespaceURI("http://schemas.xmlsoap.org/ws/2005/02/trust");
        } else if (string2.indexOf("http://docs.oasis-open.org/ws-sx/ws-trust/200512") > -1) {
            wSTContext.setWstNamespaceURI("http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        } else {
            throw new SOAPException(" Error.  While attempting to determine WS-Trust namespace.  Unexpected action URI='" + string + "'");
        }
    }
}

