/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.internal;

import javax.servlet.http.HttpServletRequest;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.wsee.connection.transport.servlet.HttpTransportUtils;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyMath;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.policy.WssPolicyUtils;
import weblogic.wsee.security.wst.internal.WSTServerHandler;

public class STSPolicyHandler
extends WSTServerHandler {
    private static final String DEFAULT_BOOTSTRAP_POLICY = "SecurityTokenService.xml";
    private static final String INCLUDE_SCT_POLICY = "AddSctToken.xml";
    private static final String SCT_CANCEL = "/SCT/Cancel";
    private static final String SCT_RENEW = "/SCT/Renew";

    public boolean handleTrustRequest(SOAPMessageContext sOAPMessageContext, String string) {
        NormalizedExpression normalizedExpression;
        NormalizedExpression normalizedExpression2 = normalizedExpression = NormalizedExpression.createUnitializedExpression();
        if (!STSPolicyHandler.isTransportSecure(sOAPMessageContext)) {
            NormalizedExpression normalizedExpression3 = STSPolicyHandler.getPolicy(sOAPMessageContext, DEFAULT_BOOTSTRAP_POLICY);
            normalizedExpression2 = PolicyMath.merge(normalizedExpression2, normalizedExpression3);
            normalizedExpression = PolicyMath.merge(normalizedExpression, normalizedExpression3);
        }
        sOAPMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", (Object)normalizedExpression2);
        sOAPMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", (Object)normalizedExpression);
        return true;
    }

    private static boolean isTransportSecure(SOAPMessageContext sOAPMessageContext) {
        HttpServletRequest httpServletRequest = HttpTransportUtils.getHttpServletRequest((MessageContext)sOAPMessageContext);
        if (httpServletRequest != null) {
            return httpServletRequest.isSecure();
        }
        return false;
    }

    private static NormalizedExpression getPolicy(SOAPMessageContext sOAPMessageContext, String string) {
        try {
            WssPolicyContext wssPolicyContext = (WssPolicyContext)sOAPMessageContext.getProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
            return WssPolicyUtils.getPolicy(wssPolicyContext, string);
        }
        catch (PolicyException policyException) {
            return NormalizedExpression.createUnitializedExpression();
        }
    }
}

