/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.internal;

import java.util.Locale;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.security.saml.SAMLIssuedTokenHelper;
import weblogic.wsee.security.wst.binding.AlgorithmUri;
import weblogic.wsee.security.wst.binding.AppliesTo;
import weblogic.wsee.security.wst.binding.CancelTarget;
import weblogic.wsee.security.wst.binding.ComputedKeyAlgorithm;
import weblogic.wsee.security.wst.binding.Entropy;
import weblogic.wsee.security.wst.binding.KeySize;
import weblogic.wsee.security.wst.binding.KeyType;
import weblogic.wsee.security.wst.binding.Lifetime;
import weblogic.wsee.security.wst.binding.OnBehalfOf;
import weblogic.wsee.security.wst.binding.RenewTarget;
import weblogic.wsee.security.wst.binding.RequestSecurityToken;
import weblogic.wsee.security.wst.binding.RequestType;
import weblogic.wsee.security.wst.binding.SecondaryParameters;
import weblogic.wsee.security.wst.binding.TokenReferenceBase;
import weblogic.wsee.security.wst.binding.TokenType;
import weblogic.wsee.security.wst.binding.TrustDOMStructure;
import weblogic.wsee.security.wst.faults.BadRequestException;
import weblogic.wsee.security.wst.faults.WSTFaultException;
import weblogic.wsee.security.wst.framework.TrustRequestor;
import weblogic.wsee.security.wst.framework.TrustToken;
import weblogic.wsee.security.wst.framework.TrustTokenProvider;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.security.wst.helpers.BindingHelper;
import weblogic.wsee.security.wst.helpers.TrustTokenHelper;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;

public class TrustRequestorImpl
implements TrustRequestor {
    private static final boolean verbose = Verbose.isVerbose(TrustRequestorImpl.class);

    public Node newRequestSecurityToken(WSTContext wSTContext) throws WSTFaultException {
        Object object;
        TrustDOMStructure trustDOMStructure;
        String string = this.getWSTNamespaceUri(wSTContext);
        RequestSecurityToken requestSecurityToken = new RequestSecurityToken(string);
        requestSecurityToken.setContext(wSTContext.getContext());
        RequestType requestType = new RequestType(string);
        requestType.setRequestType(string + "/Issue");
        requestSecurityToken.setRequestType(requestType);
        String string2 = this.setTokenType(wSTContext, requestSecurityToken);
        this.setKeyType(wSTContext, requestSecurityToken);
        this.setOnBehalfOf(wSTContext, requestSecurityToken);
        String string3 = wSTContext.getAppliesTo();
        Element element = wSTContext.getAppliesToElement();
        if (string3 != null) {
            trustDOMStructure = new AppliesTo(wSTContext.getWspNamespaceURI());
            ((AppliesTo)trustDOMStructure).setEndpointReference(wSTContext.getWsaNamespaceURI(), string3);
            requestSecurityToken.setAppliesTo((AppliesTo)trustDOMStructure);
        } else if (element != null) {
            trustDOMStructure = new AppliesTo(wSTContext.getWspNamespaceURI());
            ((AppliesTo)trustDOMStructure).setElement(element);
            requestSecurityToken.setAppliesTo((AppliesTo)trustDOMStructure);
        }
        if (string2 == null && string3 == null && element == null) {
            throw new BadRequestException("Either TokenType or AppliesTo should be defined");
        }
        trustDOMStructure = null;
        String string4 = wSTContext.getBinarySecretType();
        if (!"none".equals(string4)) {
            if (string4 == null) {
                string4 = string + "/Nonce";
            }
            if (string4.endsWith("/Nonce")) {
                trustDOMStructure = BindingHelper.createNewEntropy(string, string4);
                wSTContext.setRstNonce(((Entropy)trustDOMStructure).getBinarySecret().getValue());
            } else if (string4.endsWith("/SymmetricKey") || string4.endsWith("/AsymmetricKey")) {
                // empty if block
            }
            requestSecurityToken.setEntropy((Entropy)trustDOMStructure);
        }
        if (wSTContext.getLifetimePeriod() != -1L) {
            object = new Lifetime(string);
            ((Lifetime)object).setPeriod(wSTContext.getLifetimePeriod(), wSTContext.getWsuNamespaceURI());
            requestSecurityToken.setLifetime((Lifetime)object);
        }
        if (wSTContext.getKeySize() != -1) {
            object = new KeySize(string);
            ((KeySize)object).setSize(wSTContext.getKeySize());
            requestSecurityToken.setKeySize((KeySize)object);
        }
        if (wSTContext.hasIssuedTokenClaims()) {
            object = new SAMLIssuedTokenHelper(wSTContext.getIssuedTokenClaims());
            SecondaryParameters secondaryParameters = ((SAMLIssuedTokenHelper)object).biuldSecondaryParameters();
            requestSecurityToken.setSecondaryParameters(secondaryParameters);
            wSTContext.setComputedKeyAlgorithm(string + "/CK/PSHA1");
        }
        if (wSTContext.getComputedKeyAlgorithm() != null) {
            object = new ComputedKeyAlgorithm(string);
            ((AlgorithmUri)object).setUri(wSTContext.getComputedKeyAlgorithm());
            requestSecurityToken.setComputedKeyAlgorithm((ComputedKeyAlgorithm)object);
        }
        return BindingHelper.marshalRST(requestSecurityToken, wSTContext);
    }

    public Node renewRequestSecurityToken(TrustToken trustToken, WSTContext wSTContext) throws WSTFaultException {
        TrustDOMStructure trustDOMStructure;
        String string = this.getWSTNamespaceUri(wSTContext);
        RequestSecurityToken requestSecurityToken = new RequestSecurityToken(string);
        RequestType requestType = new RequestType(string);
        requestType.setRequestType(string + "/Renew");
        requestSecurityToken.setRequestType(requestType);
        String string2 = wSTContext.getTokenType();
        if (string2 != null) {
            trustDOMStructure = new TokenType(string);
            ((TokenType)trustDOMStructure).setTokenType(string2);
        }
        trustDOMStructure = new RenewTarget(string);
        TrustTokenProvider trustTokenProvider = TrustTokenHelper.resolveTrustProvider(string2 == null ? trustToken.getValueType() : string2);
        SecurityTokenReference securityTokenReference = trustTokenProvider.createSecurityTokenReference(wSTContext, trustToken);
        ((TokenReferenceBase)trustDOMStructure).setSecurityTokenReference(securityTokenReference);
        requestSecurityToken.setRenewTarget((RenewTarget)trustDOMStructure);
        Lifetime lifetime = new Lifetime(string);
        lifetime.setPeriod(wSTContext.getLifetimePeriod(), wSTContext.getWsuNamespaceURI());
        requestSecurityToken.setLifetime(lifetime);
        return BindingHelper.marshalRST(requestSecurityToken, wSTContext);
    }

    public Node cancelRequestSecurityToken(TrustToken trustToken, WSTContext wSTContext) throws WSTFaultException {
        String string = this.getWSTNamespaceUri(wSTContext);
        TrustTokenProvider trustTokenProvider = TrustTokenHelper.resolveTrustProvider(trustToken.getValueType());
        SecurityTokenReference securityTokenReference = trustTokenProvider.createSecurityTokenReference(wSTContext, trustToken);
        RequestSecurityToken requestSecurityToken = new RequestSecurityToken(string);
        RequestType requestType = new RequestType(string);
        requestType.setRequestType(string + "/Cancel");
        requestSecurityToken.setRequestType(requestType);
        CancelTarget cancelTarget = new CancelTarget(string);
        cancelTarget.setSecurityTokenReference(securityTokenReference);
        requestSecurityToken.setCancelTarget(cancelTarget);
        Node node = BindingHelper.marshalRST(requestSecurityToken, wSTContext);
        return node;
    }

    public Node validateRequestSecurityToken(TrustToken trustToken, WSTContext wSTContext) throws WSTFaultException {
        throw new RuntimeException("NYI");
    }

    private String getWSTNamespaceUri(WSTContext wSTContext) throws WSTFaultException {
        String string = wSTContext.getWstNamespaceURI();
        if (string == null) {
            String string2 = wSTContext.getTrustVersion();
            if (string2 == null) {
                throw new WSTFaultException(" could not get WS-Trust namespace from WSTContext.  WSTContext.getTrustVersion == null !");
            }
            String string3 = string2.toLowerCase(Locale.ENGLISH);
            if (verbose) {
                Verbose.log(" getting wstNsUri from trust version='" + string3 + "'");
            }
            if (string3.startsWith("http://schemas.xmlsoap.org/ws/2005/02/trust")) {
                string = "http://schemas.xmlsoap.org/ws/2005/02/trust";
            } else if (string3.startsWith("http://docs.oasis-open.org/ws-sx/ws-trust/200512")) {
                string = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
            } else {
                throw new WSTFaultException(" could not get WS-Trust namespace. unknown WS-Trust Version='" + string3 + "'");
            }
            if (verbose) {
                Verbose.log(" setting wstNsUri to '" + string + "'");
            }
            wSTContext.setWstNamespaceURI(string);
        } else if (verbose) {
            Verbose.log("got WS-Trust namespace from WSTContext='" + string + "'");
        }
        return string;
    }

    private String setTokenType(WSTContext wSTContext, RequestSecurityToken requestSecurityToken) {
        String string = wSTContext.getTokenType();
        if (string != null) {
            TokenType tokenType = new TokenType(wSTContext.getWstNamespaceURI());
            tokenType.setTokenType(string);
            requestSecurityToken.setTokenType(tokenType);
        }
        return string;
    }

    private void setKeyType(WSTContext wSTContext, RequestSecurityToken requestSecurityToken) {
        String string = wSTContext.getKeyType();
        if (string != null) {
            KeyType keyType = new KeyType(wSTContext.getWstNamespaceURI());
            keyType.setKeyType(string);
            requestSecurityToken.setKeyType(keyType);
        }
    }

    private void setOnBehalfOf(WSTContext wSTContext, RequestSecurityToken requestSecurityToken) {
        SecurityToken securityToken = wSTContext.getOnBehalfOfToken();
        if (securityToken != null) {
            OnBehalfOf onBehalfOf = new OnBehalfOf(wSTContext.getWstNamespaceURI());
            onBehalfOf.setSecurityToken(securityToken);
            requestSecurityToken.setOnBehalfOf(onBehalfOf);
        }
    }
}

