/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.security.wst.internal;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;

public abstract class WSTServerHandler
extends GenericHandler {
    protected static final String RST_ACTION_V200502 = "/trust/RST/";
    protected static final String RSTR_ACTION_V200502 = "/trust/RSTR/";
    protected static final String RST_ACTION_V13 = "ws-trust/200512/RST/";
    protected static final String RSTR_ACTION_V13 = "ws-trust/200512/RSTR/";

    public abstract boolean handleTrustRequest(SOAPMessageContext var1, String var2);

    public boolean handleRequest(MessageContext messageContext) {
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        String string = WSTServerHandler.getActionFromContext((MessageContext)sOAPMessageContext);
        if (!WSTServerHandler.isRST(string)) {
            return true;
        }
        return this.handleTrustRequest(sOAPMessageContext, string);
    }

    public QName[] getHeaders() {
        return new QName[0];
    }

    private static boolean isRST(String string) {
        return string != null && (string.indexOf(RST_ACTION_V200502) > -1 || string.indexOf(RST_ACTION_V13) > -1);
    }

    private static String getActionFromContext(MessageContext messageContext) {
        WlMessageContext wlMessageContext;
        MsgHeaders msgHeaders;
        ActionHeader actionHeader;
        String string = (String)messageContext.getProperty("weblogic.wsee.addressing.Action");
        if (string == null && (actionHeader = (ActionHeader)(msgHeaders = (wlMessageContext = WlMessageContext.narrow(messageContext)).getHeaders()).getHeader(ActionHeader.TYPE)) != null) {
            string = actionHeader.getActionURI();
            messageContext.setProperty("weblogic.wsee.addressing.Action", (Object)string);
        }
        return string;
    }
}

