/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.sender.DefaultProvider;

import com.sun.istack.Nullable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.wsee.WseePersistLogger;
import weblogic.wsee.WseeSenderLogger;
import weblogic.wsee.jaxws.framework.RetryDelayCalculator;
import weblogic.wsee.jaxws.persistence.PersistentMessage;
import weblogic.wsee.jaxws.persistence.PersistentMessageFactory;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.sender.DefaultProvider.ConversationCancelledExceptionImpl;
import weblogic.wsee.sender.DefaultProvider.RequestStore;
import weblogic.wsee.sender.api.ConversationStatusCallback;
import weblogic.wsee.sender.api.PermanentSendException;
import weblogic.wsee.sender.api.Resources;
import weblogic.wsee.sender.api.SendException;
import weblogic.wsee.sender.api.SendRequest;
import weblogic.wsee.sender.api.Sender;
import weblogic.wsee.sender.api.SenderNotReadyException;
import weblogic.wsee.sender.api.SendingServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conversation {
    private static final Logger LOGGER = Logger.getLogger(Conversation.class.getName());
    private String _name;
    private Resources _resources;
    private State _state;
    private RetryDelayCalculator _sendDelayCalculator;
    private transient ReentrantReadWriteLock _stateLock = new ReentrantReadWriteLock(false);
    private transient RequestStore _store;
    private transient List<Long> _pendingRequestSeqNums;
    private transient Map<Long, RequestInfo> _pendingRequestInfos;
    private transient long _maxSeqNum;
    private final transient ReentrantReadWriteLock _pendingRequestsLock = new ReentrantReadWriteLock(false);
    private transient Sender _sender;
    private transient ConversationStatusCallback _callback;
    private transient Throwable _lastSendError;
    private transient ReentrantReadWriteLock _lastSendErrorLock = new ReentrantReadWriteLock(false);
    private transient boolean _sendingFlag;
    private final transient Object _sendingFlagMonitor = "_sendingFlagMonitor";
    private transient boolean _stopFlag;
    private final transient Object _stopFlagMonitor = "_stopFlagMonitor";
    private transient TimerManager _timerMgr;
    private transient Timer _sendTimer;
    private final transient Object _sendTimerMonitor = "_sendTimerMonitor";
    private int _improperTimerEventCount = 0;

    public Conversation() {
    }

    public Conversation(String string, RequestStore requestStore, Resources resources) throws SendingServiceException {
        this._name = string;
        this._resources = new Resources(resources);
        this.setState(State.NEW);
        this.start(requestStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State state) {
        try {
            this._stateLock.writeLock().lock();
            this._state = state;
            Object var3_2 = null;
            this._stateLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._stateLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        try {
            this._stateLock.readLock().lock();
            State state = this._state;
            Object var3_2 = null;
            this._stateLock.readLock().unlock();
            return state;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._stateLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(RequestStore requestStore) throws SendingServiceException {
        long l;
        Object object;
        this._store = requestStore;
        try {
            this._pendingRequestsLock.writeLock().lock();
            object = this._store.getPendingRequests(this._name);
            this._pendingRequestSeqNums = new ArrayList<Long>();
            this._pendingRequestInfos = new LinkedHashMap<Long, RequestInfo>();
            this._maxSeqNum = 0L;
            Iterator<SendRequest> iterator = object.iterator();
            while (iterator.hasNext()) {
                SendRequest sendRequest = iterator.next();
                l = sendRequest.getSequenceNumber();
                this._pendingRequestSeqNums.add(l);
                this._pendingRequestInfos.put(l, new RequestInfo());
                if (l <= this._maxSeqNum) continue;
                this._maxSeqNum = l;
            }
            Object var8_8 = null;
            this._pendingRequestsLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this._pendingRequestsLock.writeLock().unlock();
            throw throwable;
        }
        this._sender = this._resources.getSenderFactory().createSender(this._name);
        this._callback = this._resources.getSenderFactory().getStatusCallback(this._name);
        this._timerMgr = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager();
        this.cancelSendTimer();
        object = this._resources.getOptions().getBaseRetransmissionInterval();
        if (object == null) {
            try {
                object = DatatypeFactory.newInstance().newDuration("P0DT3S");
            }
            catch (Exception exception) {
                WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                throw new RuntimeException(exception.toString(), exception);
            }
        }
        long l2 = ((Duration)object).getTimeInMillis(new Date());
        l = l2 << 10;
        long l3 = this._resources.getOptions().isExponentialBackoffEnabled() ? 2L : 1L;
        this._sendDelayCalculator = new RetryDelayCalculator(l2, l, l3);
        Sender.ConversationCallback conversationCallback = new Sender.ConversationCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void conversationReady() {
                try {
                    Conversation.this._stateLock.readLock().lock();
                    Conversation.this.clearLastSendError();
                    if (Conversation.this._state == State.NEW) {
                        Conversation.this._state = State.READY;
                        Conversation.this.scheduleImmediateSend();
                    }
                    Object var2_1 = null;
                    Conversation.this._stateLock.readLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    Conversation.this._stateLock.readLock().unlock();
                    throw throwable;
                }
            }

            public void sendSucceeded(long l) {
            }

            public boolean conversationFailedToStart(Throwable throwable) {
                if (throwable instanceof PermanentSendException) {
                    Conversation.this.closeConversationOnError(throwable);
                    return true;
                }
                Conversation.this.setLastSendError(throwable);
                return false;
            }

            public boolean sendFailed(long l, Throwable throwable) {
                if (throwable instanceof PermanentSendException) {
                    Conversation.this.invalidateRequestOnError(l, throwable);
                    return true;
                }
                Conversation.this.setLastSendError(throwable);
                return false;
            }
        };
        this._sender.setConversationCallback(conversationCallback);
    }

    public void addRequest(SendRequest sendRequest) throws SendingServiceException {
        try {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding request " + sendRequest + " to pending requests for conversation " + this._name);
                }
                this._pendingRequestsLock.writeLock().lock();
                sendRequest.setConversationName(this._name);
                if (sendRequest.getSequenceNumber() < 1L) {
                    sendRequest.setSequenceNumber(++this._maxSeqNum);
                } else if (sendRequest.getSequenceNumber() > this._maxSeqNum) {
                    this._maxSeqNum = sendRequest.getSequenceNumber();
                }
                this._pendingRequestSeqNums.add(sendRequest.getSequenceNumber());
                this._pendingRequestInfos.put(sendRequest.getSequenceNumber(), new RequestInfo());
                this._store.put(sendRequest.getMessageId(), sendRequest);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Added new request to conversation " + this._name + ". Current count = " + this._pendingRequestSeqNums.size());
                }
                this.scheduleImmediateSend();
            }
            catch (Exception exception) {
                this._pendingRequestSeqNums.remove(sendRequest.getSequenceNumber());
                throw new SendingServiceException(exception.toString(), exception);
            }
            Object var4_2 = null;
            this._pendingRequestsLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this._pendingRequestsLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastSendError(Throwable throwable) {
        try {
            this._lastSendErrorLock.writeLock().lock();
            this._lastSendError = throwable;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Set last send error on conversation " + this._name + ": " + throwable);
            }
            Object var3_2 = null;
            this._lastSendErrorLock.writeLock().unlock();
        }
        catch (Throwable throwable2) {
            Object var3_3 = null;
            this._lastSendErrorLock.writeLock().unlock();
            throw throwable2;
        }
    }

    private void clearLastSendError() {
        this.setLastSendError(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getLastSendError() {
        try {
            this._lastSendErrorLock.readLock().lock();
            Throwable throwable = this._lastSendError;
            Object var3_2 = null;
            this._lastSendErrorLock.readLock().unlock();
            return throwable;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._lastSendErrorLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSendError() {
        try {
            this._lastSendErrorLock.readLock().lock();
            boolean bl = this._lastSendError != null;
            Object var3_2 = null;
            this._lastSendErrorLock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._lastSendErrorLock.readLock().unlock();
            throw throwable;
        }
    }

    public List<Long> getPendingRequestSeqNums() throws SendingServiceException {
        try {
            this._pendingRequestsLock.readLock().lock();
            ArrayList<Long> arrayList = new ArrayList<Long>(this._pendingRequestSeqNums);
            Object var3_3 = null;
            this._pendingRequestsLock.readLock().unlock();
            return arrayList;
        }
        catch (Exception exception) {
            try {
                throw new SendingServiceException(exception.toString(), exception);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this._pendingRequestsLock.readLock().unlock();
                throw throwable;
            }
        }
    }

    public SendRequest getRequestBySequenceNumber(long l) throws SendingServiceException {
        SendRequest sendRequest = this._store.get(this._name, l);
        if (sendRequest == null) {
            throw new SendingServiceException(WseeSenderLogger.logSendRequestWithSeqNumNotFoundLoggable((String)this._name, (long)l).getMessage());
        }
        return sendRequest;
    }

    public void acknowledgeRequests(long l, long l2) throws SendingServiceException {
        try {
            try {
                this._pendingRequestsLock.writeLock().lock();
                ArrayList<Long> arrayList = new ArrayList<Long>(this._pendingRequestSeqNums);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    long l3 = (Long)iterator.next();
                    if (l3 < l || l3 > l2) continue;
                    SendRequest sendRequest = this._store.get(this._name, l3);
                    if (sendRequest == null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Request " + l3 + " has already been removed from pending requests for conversation " + this._name);
                        }
                    } else {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Ack'ing/removing request " + sendRequest + " from pending requests for conversation " + this._name);
                        }
                        this._store.remove(sendRequest.getObjectId());
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Removed ack'd request " + sendRequest + " from conversation " + this._name + ". Current count = " + this._pendingRequestSeqNums.size());
                        }
                    }
                    this._pendingRequestSeqNums.remove(l3);
                    this._pendingRequestInfos.remove(l3);
                }
                Object var11_8 = null;
                this._pendingRequestsLock.writeLock().unlock();
            }
            catch (Exception exception) {
                throw new SendingServiceException(exception.toString(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this._pendingRequestsLock.writeLock().unlock();
            throw throwable;
        }
    }

    public void closeConversation() throws SendException, StoreException {
        this.stop();
        this.setState(State.CLOSED);
        this._store.removeAllPendingRequests(this._name);
    }

    public void cancelConversation() throws SendException, StoreException {
        ConversationCancelledExceptionImpl conversationCancelledExceptionImpl = new ConversationCancelledExceptionImpl(this._name);
        conversationCancelledExceptionImpl.fillInStackTrace();
        this.closeConversationOnError(conversationCancelledExceptionImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws SendException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("!! Stopping conversation: " + this._name + " and closing sender for it");
        }
        this.setState(State.STOPPED);
        Object object = this._stopFlagMonitor;
        synchronized (object) {
            this._stopFlag = true;
        }
        this.cancelSendTimer();
        this._sender.close();
        this._sender = null;
    }

    void startSending() {
        this.scheduleImmediateSend();
    }

    private void scheduleFutureSend() {
        this.scheduleSendTimerDontUseDirectly(this._sendDelayCalculator.getNextRetryDelayMillis());
    }

    private void scheduleImmediateSend() {
        if (this.isSending()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Bypassing immediate send due to already sending. Conversation name: " + this._name);
            }
            return;
        }
        if (this.hasSendError()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Bypassing immediate send due to previous send failure. Waiting for next scheduled send. Conversation name: " + this._name);
            }
            this.scheduleFutureSend();
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Scheduling immediate send. Conversation name: " + this._name);
        }
        this.scheduleSendTimerDontUseDirectly(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSendTimerDontUseDirectly(long l) {
        Object object = this._sendTimerMonitor;
        synchronized (object) {
            if (this._sendTimer == null || !this.hasSendError() && l == 0L) {
                this.cancelSendTimer();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Setting send timer into future by " + l + " ms");
                }
                this._sendTimer = this._timerMgr.schedule(new TimerListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void timerExpired(Timer timer) {
                        Object object = Conversation.this._sendTimerMonitor;
                        synchronized (object) {
                            Conversation.this._sendTimer = null;
                        }
                        if (Conversation.this._sender == null) {
                            Conversation.this._improperTimerEventCount++;
                            object = "Timer still active in Conversation that has been stopped!. This has happened " + Conversation.this._improperTimerEventCount + " times in conversation: " + Conversation.this._name;
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine((String)object);
                            }
                            return;
                        }
                        Conversation.this.sendPendingRequests();
                    }
                }, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSending() {
        Object object = this._sendingFlagMonitor;
        synchronized (object) {
            return this._sendingFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPendingRequests() {
        Object object;
        Object object2 = this._sendingFlagMonitor;
        synchronized (object2) {
            if (this._sendingFlag) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Aborting sendPendingRequests because we are already in sendPendingRequests on another thread");
                }
                return;
            }
            this._sendingFlag = true;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("In sendPendingRequests for conversation " + this._name);
            }
        }
        try {
            boolean bl;
            this.cancelSendTimer();
            Object object3 = this._stopFlagMonitor;
            synchronized (object3) {
                bl = this._stopFlag;
            }
            long l = -1L;
            block18: while (!bl) {
                Long[] longArray = this.getNextRequestInfoBatch(l);
                if (longArray.length < 1) {
                    if (!LOGGER.isLoggable(Level.FINE)) break;
                    LOGGER.fine("No more pending requests found for this pass, sender going back to sleep");
                    break;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(longArray.length + " pending requests found for this pass");
                }
                for (Long l2 : longArray) {
                    Object var11_15;
                    RequestInfo requestInfo;
                    l = l2;
                    try {
                        this._pendingRequestsLock.readLock().lock();
                        requestInfo = this._pendingRequestInfos.get(l2);
                        if (requestInfo == null) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Ignoring send of request with seqNum " + l2 + " as it is no longer managed by this Conversation (probably has been ack'd/removed)");
                            }
                            var11_15 = null;
                            this._pendingRequestsLock.readLock().unlock();
                            continue;
                        }
                        requestInfo.request = this._store.get(this._name, l2);
                    }
                    catch (Throwable throwable) {
                        var11_15 = null;
                        this._pendingRequestsLock.readLock().unlock();
                        throw throwable;
                    }
                    var11_15 = null;
                    this._pendingRequestsLock.readLock().unlock();
                    if (requestInfo.request == null) {
                        bl = true;
                        continue block18;
                    }
                    Object object4 = this.sendOneRequest(requestInfo);
                    if (object4 == Sender.SendResult.FAILURE) {
                        if (this.getLastSendError() instanceof PermanentSendException || this.getLastSendError() instanceof SenderNotReadyException) {
                            bl = true;
                            continue block18;
                        }
                        if (this._resources.getOptions().isInOrder()) {
                            bl = true;
                            continue block18;
                        }
                    } else {
                        this.markRequestSent(requestInfo.seqNum, requestInfo, (Sender.SendResult)((Object)object4));
                    }
                    object4 = this._stopFlagMonitor;
                    synchronized (object4) {
                        bl = this._stopFlag;
                    }
                }
            }
            Object var14_17 = null;
            object = this._sendingFlagMonitor;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            Object object5 = this._sendingFlagMonitor;
            synchronized (object5) {
                this._sendingFlag = false;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Finished with sendPendingRequests for conversation: " + this._name);
                }
                this.scheduleFutureSend();
            }
            throw throwable;
        }
        synchronized (object) {
            this._sendingFlag = false;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Finished with sendPendingRequests for conversation: " + this._name);
            }
            this.scheduleFutureSend();
        }
    }

    private void markRequestSent(long l, @Nullable RequestInfo requestInfo, Sender.SendResult sendResult) {
        if (this.getState() != State.READY) {
            this.setState(State.READY);
        }
        this.clearLastSendError();
        if (requestInfo != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Successful send for request " + l + " on conversation " + this._name + ". Pending request count: " + this._pendingRequestSeqNums.size());
            }
            requestInfo.lastSendTime = System.currentTimeMillis();
            requestInfo.lastSendDelay = this._sendDelayCalculator.getCurrentRetryDelayMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSendTimer() {
        Object object = this._sendTimerMonitor;
        synchronized (object) {
            if (this._sendTimer != null) {
                this._sendTimer.cancel();
                this._sendTimer = null;
                this._improperTimerEventCount = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sender.SendResult sendOneRequest(RequestInfo requestInfo) {
        Sender.SendResult sendResult;
        SendRequest sendRequest;
        SendRequest sendRequest2 = sendRequest = requestInfo.request;
        synchronized (sendRequest2) {
            try {
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                PrivilegedExceptionAction<Sender.SendResult> privilegedExceptionAction = new PrivilegedExceptionAction<Sender.SendResult>(){

                    @Override
                    public Sender.SendResult run() throws Exception {
                        return Conversation.this._sender.send(sendRequest);
                    }
                };
                PersistentMessage persistentMessage = (PersistentMessage)sendRequest.getPayload();
                sendResult = persistentMessage != null && persistentMessage.getContext() != null ? PersistentMessageFactory.getInstance().runActionInContext(persistentMessage.getContext(), authenticatedSubject, privilegedExceptionAction) : this._sender.send(sendRequest);
                this.setLastSendError(null);
                this._sendDelayCalculator.reset();
            }
            catch (PermanentSendException permanentSendException) {
                boolean bl;
                this.setLastSendError(permanentSendException);
                Object object = this._stopFlagMonitor;
                synchronized (object) {
                    bl = this._stopFlag;
                }
                if (!bl) {
                    this.invalidateRequestOnError(sendRequest.getSequenceNumber(), permanentSendException);
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Got send error on request " + sendRequest + " for stopped conversation " + this._name + ": " + permanentSendException.toString());
                }
                sendResult = Sender.SendResult.FAILURE;
            }
            catch (Throwable throwable) {
                this.setLastSendError(throwable);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Got send error on request " + sendRequest + " for conversation " + this._name + ": " + throwable.toString());
                }
                sendResult = Sender.SendResult.FAILURE;
            }
        }
        return sendResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long[] getNextRequestInfoBatch(long l) {
        block8: {
            this._pendingRequestsLock.readLock().lock();
            if (!this._pendingRequestSeqNums.isEmpty()) break block8;
            Long[] longArray = new Long[]{};
            Object var11_4 = null;
            this._pendingRequestsLock.readLock().unlock();
            return longArray;
        }
        try {
            LinkedList<Long> linkedList = new LinkedList<Long>();
            Long[] longArray = this._pendingRequestSeqNums.iterator();
            while (longArray.hasNext()) {
                long l2 = longArray.next();
                if (l2 <= l) continue;
                RequestInfo requestInfo = this._pendingRequestInfos.get(l2);
                requestInfo.request = this._store.get(this._name, l2);
                if (requestInfo.lastSendTime > 0L && this.getState() == State.READY) {
                    long l3 = System.currentTimeMillis() - requestInfo.lastSendTime;
                    if (l3 < requestInfo.lastSendDelay) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine("Bypassing send of request " + requestInfo.request + " on conversation " + this._name + " as it was sent before too recently: (" + l3 + " ms ago)");
                        continue;
                    }
                } else if (this.getState() != State.READY && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Ignoring 'last send' times on all requests in this conversation because of it's state: " + (Object)((Object)this.getState()) + ". Will honor 'last send' times when the conversation is READY");
                }
                linkedList.add(l2);
            }
            longArray = linkedList.toArray(new Long[linkedList.size()]);
            Object var11_5 = null;
            this._pendingRequestsLock.readLock().unlock();
            return longArray;
        }
        catch (Throwable throwable) {
            Object var11_6 = null;
            this._pendingRequestsLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConversationOnError(Throwable throwable) {
        if (this.getState() == State.CLOSED || this.getState() == State.STOPPED) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Closing conversation " + this._name + " on permanent/fatal error: " + throwable.toString());
        }
        try {
            try {
                this._pendingRequestsLock.readLock().lock();
                if (this._pendingRequestSeqNums.size() > 0) {
                    for (long l : this._pendingRequestSeqNums) {
                        SendRequest sendRequest = this._store.get(this._name, l);
                        try {
                            this._callback.deliveryFailure(sendRequest, Arrays.asList(throwable));
                        }
                        catch (Exception exception) {
                            WseeSenderLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                        }
                    }
                }
                Object var8_6 = null;
                this._pendingRequestsLock.readLock().unlock();
            }
            catch (Throwable throwable2) {
                Object var8_7 = null;
                this._pendingRequestsLock.readLock().unlock();
                throw throwable2;
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable3) {
            Object var10_10 = null;
            try {
                this.closeConversation();
            }
            catch (Exception exception) {
                WseeSenderLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
            throw throwable3;
        }
        try {
            this.closeConversation();
        }
        catch (Exception exception) {
            WseeSenderLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
    }

    private void invalidateRequestOnError(long l, Throwable throwable) {
        SendRequest sendRequest;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Invalidating msg num " + l + " on conversation " + this._name + " due to permanent/fatal error: " + throwable.toString());
        }
        if ((sendRequest = this._store.get(this._name, l)) != null) {
            try {
                this._callback.deliveryFailure(sendRequest, Arrays.asList(throwable));
            }
            catch (Exception exception) {
                WseeSenderLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
            try {
                this.acknowledgeRequests(l, l);
            }
            catch (Exception exception) {
                WseeSenderLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.info("Didn't find msg num " + l + " while trying to invalidate it on conversation " + this._name + " due to permanent/fatal error: " + throwable.toString());
        }
    }

    private class RequestInfo {
        int pos;
        long seqNum;
        long lastSendTime;
        long lastSendDelay;
        SendRequest request;

        private RequestInfo() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NEW,
        READY,
        CLOSED,
        STOPPED;

    }
}

