/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.sender.DefaultProvider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.WseeSenderLogger;
import weblogic.wsee.sender.DefaultProvider.Conversation;
import weblogic.wsee.sender.DefaultProvider.RequestStore;
import weblogic.wsee.sender.api.ConversationNotFoundException;
import weblogic.wsee.sender.api.Preferences;
import weblogic.wsee.sender.api.Resources;
import weblogic.wsee.sender.api.SendException;
import weblogic.wsee.sender.api.SendRequest;
import weblogic.wsee.sender.api.SendingServiceException;
import weblogic.wsee.sender.spi.SendingServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSendingServiceProvider
implements SendingServiceProvider {
    private static final Logger LOGGER = Logger.getLogger(DefaultSendingServiceProvider.class.getName());
    private Preferences _prefs;
    private String _logicalStoreName;
    private RequestStore _store;
    private Map<String, Conversation> _convMap;
    private final ReentrantReadWriteLock _convMapLock = new ReentrantReadWriteLock(false);

    public DefaultSendingServiceProvider(Preferences preferences) throws SendingServiceException {
        this._prefs = preferences;
        this._logicalStoreName = this._prefs == null || this._prefs.getLogicalStoreName() == null ? null : this._prefs.getLogicalStoreName();
        this.initStore();
    }

    private void initStore() throws SendingServiceException {
        this._convMap = new HashMap<String, Conversation>();
        try {
            this._store = RequestStore.getStore(this._logicalStoreName);
        }
        catch (Exception exception) {
            throw new SendingServiceException(exception.toString(), exception);
        }
    }

    @Override
    public void addConversation(String string, Resources resources) throws SendingServiceException {
        this.internalAddConversation(string, resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalAddConversation(String string, Resources resources) throws SendingServiceException {
        try {
            this._convMapLock.writeLock().lock();
            if (this._convMap.containsKey(string)) {
                throw new ConversationNotFoundException(WseeSenderLogger.logConversationExistsLoggable((String)string).getMessage());
            }
            Conversation conversation = new Conversation(string, this._store, resources);
            this._convMap.put(string, conversation);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("DefaultSendingServiceProvider new conversation count: " + this._convMap.size());
                this.dumpConversations();
            }
            conversation.startSending();
            Object var5_4 = null;
            this._convMapLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._convMapLock.writeLock().unlock();
            throw throwable;
        }
    }

    @Override
    public void continueConversation(String string, Resources resources) throws SendingServiceException {
        try {
            try {
                this._convMapLock.writeLock().lock();
                if (this._convMap.containsKey(string)) {
                    Conversation conversation = this._convMap.get(string);
                    conversation.stop();
                    this._convMap.remove(string);
                }
                this.internalAddConversation(string, resources);
            }
            catch (SendException sendException) {
                throw new SendingServiceException(sendException.toString(), sendException);
            }
            Object var5_5 = null;
            this._convMapLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this._convMapLock.writeLock().unlock();
            throw throwable;
        }
    }

    @Override
    public void cancelConversation(String string) throws SendingServiceException {
        try {
            Conversation conversation = this.getConversation(string);
            conversation.cancelConversation();
        }
        catch (Exception exception) {
            throw new SendingServiceException(exception.toString(), exception);
        }
        this.removeConversationFromMap(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConversationFromMap(String string) {
        try {
            this._convMapLock.writeLock().lock();
            this._convMap.remove(string);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("DefaultSendingServiceProvider remaining conversation count: " + this._convMap.size());
                this.dumpConversations();
            }
            Object var3_2 = null;
            this._convMapLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._convMapLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean conversationExists(String string) throws SendingServiceException {
        try {
            this._convMapLock.readLock().lock();
            boolean bl = this._convMap.containsKey(string);
            Object var4_3 = null;
            this._convMapLock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._convMapLock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public void addRequest(String string, SendRequest sendRequest) throws SendingServiceException {
        Conversation conversation = this.getConversation(string);
        conversation.addRequest(sendRequest);
    }

    private void dumpConversations() {
        if (LOGGER.isLoggable(Level.FINER)) {
            Set<String> set = this._convMap.keySet();
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : set) {
                Conversation conversation = this._convMap.get(string);
                if (conversation == null) continue;
                stringBuffer.append("   ").append(string).append(": ").append((Object)conversation.getState()).append("\n");
            }
            LOGGER.finer("Current Conversations:\n" + stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Conversation getConversation(String string) throws SendingServiceException {
        try {
            this._convMapLock.readLock().lock();
            Conversation conversation = this._convMap.get(string);
            if (conversation == null) {
                throw new ConversationNotFoundException(WseeSenderLogger.logConversationNotFoundLoggable((String)string).getMessage());
            }
            Conversation conversation2 = conversation;
            Object var5_4 = null;
            this._convMapLock.readLock().unlock();
            return conversation2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._convMapLock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public List<Long> getPendingRequests(String string) throws SendingServiceException {
        Conversation conversation = this.getConversation(string);
        return conversation.getPendingRequestSeqNums();
    }

    @Override
    public SendRequest getRequestBySequenceNumber(String string, long l) throws SendingServiceException {
        Conversation conversation = this.getConversation(string);
        return conversation.getRequestBySequenceNumber(l);
    }

    @Override
    public SendRequest getRequestByMessageID(String string) throws SendingServiceException {
        try {
            SendRequest sendRequest = (SendRequest)this._store.get(string);
            if (sendRequest == null) {
                throw new SendingServiceException(WseeSenderLogger.logSendRequestNotFoundLoggable((String)string).getMessage());
            }
            return sendRequest;
        }
        catch (Exception exception) {
            throw new SendingServiceException(exception.toString(), exception);
        }
    }

    @Override
    public void acknowledgeRequests(String string, long l, long l2) throws SendingServiceException {
        Conversation conversation = this.getConversation(string);
        conversation.acknowledgeRequests(l, l2);
    }

    @Override
    public void closeConversation(String string) throws SendingServiceException {
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("SendingService closing conversation: " + string);
            }
            Conversation conversation = this.getConversation(string);
            conversation.closeConversation();
        }
        catch (SendingServiceException sendingServiceException) {
            throw sendingServiceException;
        }
        catch (Exception exception) {
            throw new SendingServiceException(exception.toString(), exception);
        }
        this.removeConversationFromMap(string);
    }

    @Override
    public void stopConversation(String string) throws SendingServiceException {
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("SendingService stopping conversation: " + string);
            }
            Conversation conversation = this.getConversation(string);
            conversation.stop();
        }
        catch (SendingServiceException sendingServiceException) {
            throw sendingServiceException;
        }
        catch (Exception exception) {
            throw new SendingServiceException(exception.toString(), exception);
        }
        this.removeConversationFromMap(string);
    }

    @Override
    public void stop() throws SendingServiceException {
        try {
            try {
                this._convMapLock.readLock().lock();
                for (Conversation conversation : this._convMap.values()) {
                    conversation.stop();
                }
                Object var4_4 = null;
                this._convMapLock.readLock().unlock();
            }
            catch (Exception exception) {
                throw new SendingServiceException(exception.toString(), exception);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this._convMapLock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public Preferences getPreferences() {
        return this._prefs;
    }
}

