/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.sender.DefaultProvider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.persistence.LogicalStore;
import weblogic.wsee.persistence.StoreConnection;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.sender.DefaultProvider.RequestStoreConnection;
import weblogic.wsee.sender.api.SendRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestStore
extends LogicalStore<String, SendRequest> {
    private static final String CONNECTION_NAME = RequestStore.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CONNECTION_NAME);
    private static final RequestStore _instance = new RequestStore();

    public static RequestStore getStore(String string) throws StoreException {
        return (RequestStore)_instance.getOrCreateLogicalStore(string, CONNECTION_NAME);
    }

    private RequestStore() {
    }

    private RequestStore(String string) throws StoreException {
        super(string, CONNECTION_NAME);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(" == RequestStore created for " + this.getName() + " and connection " + CONNECTION_NAME);
        }
    }

    public RequestStore createLogicalStore(String string, String string2) throws StoreException {
        return new RequestStore(string);
    }

    @Override
    protected StoreConnection<String, SendRequest> createStoreConnection(String string, String string2) throws StoreException {
        return new RequestStoreConnection(string, string2);
    }

    public List<SendRequest> getPendingRequests(String string) {
        List list = this.getStoreConnections();
        ArrayList<SendRequest> arrayList = new ArrayList<SendRequest>();
        for (StoreConnection storeConnection : list) {
            List<SendRequest> list2 = ((RequestStoreConnection)storeConnection).getPendingRequests(string);
            arrayList.addAll(arrayList.size(), list2);
        }
        return arrayList;
    }

    public boolean removeAllPendingRequests(String string) throws StoreException {
        List list = this.getStoreConnections();
        boolean bl = false;
        for (StoreConnection storeConnection : list) {
            bl |= ((RequestStoreConnection)storeConnection).removeAllPendingRequests(string);
        }
        return bl;
    }

    public SendRequest get(String string, long l) {
        StoreConnection storeConnection;
        List list = this.getStoreConnections();
        SendRequest sendRequest = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && (sendRequest = ((RequestStoreConnection)(storeConnection = iterator.next())).get(string, l)) == null) {
        }
        return sendRequest;
    }

    static {
        _instance.toString();
    }
}

